/*--------------------------------------------------------------------
 * FICHERO:  AhoraEs.c
 * OBJETIVO: Decir la fecha y la hora por pantalla
 * AUTOR:    Pedro Reina
 * FECHA:    S.28.9.1996
 *------------------------------------------------------------------*/

/*--------------------------------------------------------------------
 * Ficheros de cabecera
 *------------------------------------------------------------------*/

#include <dos.h>  /* struct date  getdate()  struct time  gettime() */

/*--------------------------------------------------------------------
 * Definicin de tipos
 *------------------------------------------------------------------*/

typedef long int entero;

/*--------------------------------------------------------------------
 * Declaracin de funciones
 *------------------------------------------------------------------*/

entero DiaSemana (entero, entero, entero);

/*--------------------------------------------------------------------
 * Programa principal
 *------------------------------------------------------------------*/

int main (void)
  {
  char * Nombre = "DLMXJVS";
  struct date d;
  struct time t;

  getdate(&d);
  gettime(&t);

  printf ("\nAhora es: %c.%d.%d.%d, %02d:%02d:%02d\n",
           Nombre [DiaSemana (d.da_year, d.da_mon, d.da_day)],
           d.da_day, d.da_mon, d.da_year,
           t.ti_hour, t.ti_min, t.ti_sec);

  return ( 0 );
  }

/*--------------------------------------------------------------------
 * Definicin de funciones
 *------------------------------------------------------------------*/

/*--------------------------------------------------------------------
 * FUNCION:  DiaSemana()
 * OBJETIVO: Decir el da de la semana de una fecha
 * ENTRADAS: El ao, el mes y el da
 * SALIDAS:  Un entero que indica el da de la semana, con este convenio:
 *           0 -> Domingo, 1 -> Lunes, ..., 6 -> Sbado
 * EJEMPLO:  DiaSemana (1994,10,31)
 *------------------------------------------------------------------*/
entero DiaSemana (entero Ano, entero Mes, entero Dia)
  {
  entero Sem, Factor;

  Factor = 365 * Ano + Dia + 31*(Mes-1);
  if ( Mes < 3 ) { Ano--; }
  Factor += (entero)(Ano/4.0) - (entero)(.75*((entero)(Ano/100.0)+1));
  if ( Mes >= 3 ) { Factor -= (entero)(.4*Mes + 2.3); }
  Sem = Factor - 7*(entero)(Factor/7) - 1;
  if ( Sem == -1 ) { Sem = 6; }
  return ( Sem );
  }
