/*--------------------------------------------------------------------
 * FICHERO:  Ayuda.c
 * OBJETIVO: Dar un sistema sencillo de ayuda
 * AUTOR:    Pedro Reina
 * FECHA:    J.15.1.1998
 *------------------------------------------------------------------*/

/*--------------------------------------------------------------------
 * Ficheros de cabecera
 *------------------------------------------------------------------*/

#include "Calendar.h"

/*--------------------------------------------------------------------
 * Declaracin de funciones
 *------------------------------------------------------------------*/

// Ninguna

/*--------------------------------------------------------------------
 * Definicin de macros constantes
 *------------------------------------------------------------------*/

#define FIN_RECURSO_TEXTO  254

/*--------------------------------------------------------------------
 * Definicin de macros funciones
 *------------------------------------------------------------------*/

// Ninguno

/*--------------------------------------------------------------------
 * Definicin de variables globales
 *------------------------------------------------------------------*/

char * NombreRecurso;  // Nombre del recurso de texto
char * Titulo;         // Ttulo para la ventana

/*--------------------------------------------------------------------
 * Definicin de funciones
 *------------------------------------------------------------------*/

/*--------------------------------------------------------------------
 * FUNCION:  MuestraAyuda()
 * OBJETIVO: Lanzar un cuadro de dilogo que pueda mostrar un recurso
 *           de texto.
 * ENTRADAS: La ventana padre que lanza el cuadro de dilogo, el ttulo
 *           del cuadro y el recurso de texto
 * SALIDA:   Ninguna
 *------------------------------------------------------------------*/
void
MuestraAyuda
  (
  HWND  VentanaPadre,
  char *IdTitulo,
  char *IdRecurso
  )
  {
  NombreRecurso = IdRecurso;
  Titulo = IdTitulo;
  DialogBox (Aplic, "Ayuda", VentanaPadre, PunteroAyuda);
  }

/*--------------------------------------------------------------------
 * FUNCION:  ProcedimientoAyuda()
 * OBJETIVO: Recibir los mensajes de Windows para el cuadro de
 *           dilogo Ayuda
 *------------------------------------------------------------------*/
#pragma argsused
BOOL FAR PASCAL
ProcedimientoAyuda
  (
  HWND   Ventana,        // Ventana a la que se enva el mensaje
  UINT   Mensaje,        // El mensaje
  WPARAM ParametroCorto, // Informacin adicional
  LPARAM ParametroLargo  // Informacin adicional
  )
  {
  BOOL    Respuesta = FALSE;
  HANDLE  Recurso;
  static HGLOBAL     Memoria;
  static char far   *TextoPuro;
  unsigned char far *Texto;
  int Tamano, i, j, Salto;

  switch ( Mensaje )
    {
    case WM_INITDIALOG:
      SetWindowText (Ventana, Titulo);
      CentraVentana (Ventana);
      Recurso = LoadResource (Aplic,
                    FindResource(Aplic, NombreRecurso, "TEXTO"));
      Texto = LockResource (Recurso);
      for ( Tamano=0 ; Texto[Tamano] != FIN_RECURSO_TEXTO ; Tamano++)
        ;
      Memoria = GlobalAlloc (GMEM_FIXED, Tamano+1);
      TextoPuro = GlobalLock (Memoria);
      for ( i=0 , j=0 , Salto=0 ; i<Tamano ; )
        {
        if ( Texto[i] == 13 )
          {
          i+=2;
          Salto++;
          }
        else if ( !Salto )  { TextoPuro[j++] = Texto[i++]; }
        else
          {
          if ( Salto == 1 )  { TextoPuro[j++] = 32; }
          else
            {
            while ( --Salto )
              {
              TextoPuro[j++] = 13;
              TextoPuro[j++] = 10;
              }
            }
          Salto = 0;
          }
        }
      TextoPuro[j] = NULL;
      GlobalUnlock (Recurso);
      FreeResource (Recurso);
      SetDlgItemText (Ventana, ID_TEXTO, TextoPuro);
      Respuesta = TRUE;
      break;

    case WM_COMMAND:
      switch ( ParametroCorto )
        {
        case IDCANCEL:
        case IDOK:
          GlobalUnlock (Memoria);
          GlobalFree (Memoria);
          EndDialog (Ventana, 0);
          Respuesta = TRUE;
          break;
        }
      break;
    }

  return ( Respuesta );
  }