/*--------------------------------------------------------------------
 * FICHERO:  Calendar.c
 * OBJETIVO: Mdulo principal del "Calendario"
 * AUTOR:    Pedro Reina
 * FECHA:    J.15.1.1998
 *------------------------------------------------------------------*/

/*--------------------------------------------------------------------
 * Ficheros de cabecera
 *------------------------------------------------------------------*/

#include "Calendar.h"

/*--------------------------------------------------------------------
 * Declaracin de funciones
 *------------------------------------------------------------------*/

LONG FAR PASCAL ProcedimientoPrincipal (HWND,UINT,WPARAM,LPARAM);
void BotonNormal (HWND,int);
void BotonDefecto (HWND,int);

/*--------------------------------------------------------------------
 * Definicin de macros constantes
 *------------------------------------------------------------------*/

// Ninguno

/*--------------------------------------------------------------------
 * Definicin de macros funciones
 *------------------------------------------------------------------*/

/*--------------------------------------------------------------------
 * MACRO:    ConfirmaSalida()
 * OBJETIVO: Pedir al usuario confirmacin para salir del programa
 *------------------------------------------------------------------*/
#define ConfirmaSalida(v) (MessageBox(v,                   \
                           "Quieres salir del programa?", \
                           "Salir", MB_ICONQUESTION | MB_OKCANCEL) == IDOK)

/*--------------------------------------------------------------------
 * MACRO:    Error()
 * OBJETIVO: Notificar un error
 * ENTRADAS: La ventana que llama y el texto del error
 *------------------------------------------------------------------*/
#define Error(v,t) (MessageBox(v,t,"Error",MB_ICONSTOP | MB_OK))

/*--------------------------------------------------------------------
 * MACRO:    AnchoPantalla()
 * OBJETIVO: Calcular el ancho total de la pantalla
 *------------------------------------------------------------------*/
#define AnchoPantalla()  GetSystemMetrics(SM_CXSCREEN)

/*--------------------------------------------------------------------
 * MACRO:    AltoPantalla()
 * OBJETIVO: Calcular el alto total de la pantalla
 *------------------------------------------------------------------*/
#define AltoPantalla()  GetSystemMetrics(SM_CYSCREEN)

/*--------------------------------------------------------------------
 * Definicin de variables globales
 *------------------------------------------------------------------*/

FARPROC PunteroAyuda;
FARPROC PunteroAcercaDe;
HANDLE  Aplic;

/*--------------------------------------------------------------------
 * Programa principal
 *------------------------------------------------------------------*/
#pragma argsused
int PASCAL
WinMain
  (
  HANDLE Instancia,    // Manejador de instancia de aplicacin
  HANDLE Anterior,     // Manejador de instancia anterior
  LPSTR  Parametros,   // Cadena con la lnea de parmetros
  int    ModoMostrar   // Aplicacin como ventana o como icono
  )
  {
  HWND     VentanaPrincipal;
  MSG      Mensaje;
  WNDCLASS Clase;
  HMENU    MenuControl;

  // Almacenamos la Instancia en una variable global
  Aplic = Instancia;

  // Si es necesario, registramos la clase de ventana
  if ( !Anterior )
    {
    // Estilo de ventana
    Clase.style = CS_HREDRAW | CS_VREDRAW;

    // Funcin que maneja la ventana
    Clase.lpfnWndProc = ProcedimientoPrincipal;

    // Octetos extra
    Clase.cbClsExtra = 0;

    // Octetos extra
    Clase.cbWndExtra = DLGWINDOWEXTRA;

    // Instancia de aplicacin
    Clase.hInstance = Instancia;

    // Icono al minimizar
    Clase.hIcon = LoadIcon (Instancia,"Calendar");

    // Cursor
    Clase.hCursor = LoadCursor (NULL,IDC_ARROW);

    // Pincel de fondo
    Clase.hbrBackground = COLOR_WINDOW + 1;

    // Recurso de men
    Clase.lpszMenuName = NULL;

    // Nombre de la clase de ventana
    Clase.lpszClassName = "Calendar";

    if ( !RegisterClass (&Clase) )
      { return ( FALSE ); }
    }

  // Creamos la ventana principal
  VentanaPrincipal = CreateDialog (Instancia, "Principal", 0, NULL);

  // Cambiamos el men del cuadro de control
  MenuControl = GetSystemMenu (VentanaPrincipal, FALSE);
  DeleteMenu (MenuControl, SC_SIZE,     MF_BYCOMMAND);
  DeleteMenu (MenuControl, SC_MAXIMIZE, MF_BYCOMMAND);

  // Preparamos las llamadas a los cuadros de dilogo
  PunteroAyuda = MakeProcInstance (ProcedimientoAyuda, Aplic);
  PunteroAcercaDe = MakeProcInstance (ProcedimientoAcercaDe, Aplic);

  // Mostramos la ventana
  CentraVentana (VentanaPrincipal);
  ShowWindow (VentanaPrincipal, ModoMostrar);

  // Manejamos los mensajes
  while ( GetMessage (&Mensaje, NULL, NULL, NULL) )
    {
    TranslateMessage (&Mensaje);
    DispatchMessage (&Mensaje);
    }

  return ( Mensaje.wParam );
  }

/*--------------------------------------------------------------------
 * Definicin de funciones
 *------------------------------------------------------------------*/

/*--------------------------------------------------------------------
 * FUNCION:  ProcedimientoPrincipal()
 * OBJETIVO: Recibir los mensajes de Windows para la clase
 *           de ventanas principal de esta aplicacin
 *------------------------------------------------------------------*/
LONG FAR PASCAL
ProcedimientoPrincipal
  (
  HWND   Ventana,        // Ventana a la que se enva el mensaje
  UINT   Mensaje,        // El mensaje
  WPARAM ParametroCorto, // Informacin adicional
  LPARAM ParametroLargo  // Informacin adicional
  )
  {
  static int    Opcion = ID_HOY;
  static entero Mes, Ano;

  BOOL        Respuesta = FALSE;
  PAINTSTRUCT Pintura;
  HDC         Contexto;

  switch ( Mensaje )
    {
    case WM_CREATE:
      Mes = MesHoy();
      Ano = AnoHoy();
      Respuesta = TRUE;
      break;

    case WM_KEYDOWN:
      BotonNormal (Ventana, Opcion);
      switch ( ParametroCorto )
        {
        case VK_TAB:
          if ( GetKeyState (VK_SHIFT) < 0 )  { Opcion--; }
          else                               { Opcion++; }
          break;
        case VK_RIGHT: Opcion++; break;
        case VK_LEFT:  Opcion--; break;
        case VK_SPACE:
        case VK_RETURN:
          SendMessage (Ventana, WM_COMMAND, Opcion, 0L);
          break;
        case VK_ESCAPE:
        case 'S': SendMessage (Ventana, WM_COMMAND, ID_SALIR, 0L);    break;
        case 'C': SendMessage (Ventana, WM_COMMAND, ID_ACERCADE, 0L); break;
        case 'Y': SendMessage (Ventana, WM_COMMAND, ID_AYUDA, 0L);    break;
        case 'O': SendMessage (Ventana, WM_COMMAND, ID_ANOANT, 0L);   break;
        case 'A': SendMessage (Ventana, WM_COMMAND, ID_ANOSIG, 0L);   break;
        case 'H': SendMessage (Ventana, WM_COMMAND, ID_HOY, 0L);      break;
        case 'M': SendMessage (Ventana, WM_COMMAND, ID_MESSIG, 0L);   break;
        case 'E': SendMessage (Ventana, WM_COMMAND, ID_MESANT, 0L);   break;
        case 'T': SendMessage (Ventana, WM_COMMAND, ID_AUTOR, 0L);    break;
        }
      if ( Opcion > ID_AUTOR )  { Opcion = ID_ANOANT; }
      if ( Opcion < ID_ANOANT )  { Opcion = ID_AUTOR; }
      BotonDefecto (Ventana, Opcion);
      break;

    case WM_COMMAND:
      switch ( ParametroCorto )
        {
        case ID_ANOANT:
          if ( Ano == 1900 )
            { Error (Ventana, "No se admite un ao anterior"); }
          else
            { Ano--; }
          InvalidateRect (Ventana, NULL, TRUE);
          Respuesta = TRUE;
          break;

        case ID_MESANT:
          if ( Ano == 1900 && Mes == 1 )
            { Error (Ventana, "No se admite un ao anterior"); }
          else
            {
            Mes--;
            if ( Mes == 0 )
              {
              Mes = 12;
              Ano--;
              }
            }
          InvalidateRect (Ventana, NULL, TRUE);
          Respuesta = TRUE;
          break;

        case ID_HOY:
          Mes = MesHoy();
          Ano = AnoHoy();
          InvalidateRect (Ventana, NULL, TRUE);
          Respuesta = TRUE;
          break;

        case ID_ANOSIG:
          if ( Ano == 2100 )
            { Error (Ventana, "No se admite un ao posterior"); }
          else
            { Ano++; }
          InvalidateRect (Ventana, NULL, TRUE);
          Respuesta = TRUE;
          break;

        case ID_MESSIG:
          if ( Ano == 2100 && Mes == 12 )
            { Error (Ventana, "No se admite un ao posterior"); }
          else
            {
            Mes++;
            if ( Mes == 13 )
              {
              Mes = 1;
              Ano++;
              }
            }
          InvalidateRect (Ventana, NULL, TRUE);
          Respuesta = TRUE;
          break;

        case ID_SALIR:
          SendMessage (Ventana, WM_CLOSE, 0, 0L);
          Respuesta = TRUE;
          break;

        case ID_AYUDA:
          MuestraAyuda (Ventana, "Ayuda", "AyudaPrincipal");
          break;

        case ID_ACERCADE:
          DialogBox (Aplic,"AcercaDe",Ventana,PunteroAcercaDe);
          Respuesta = TRUE;
          break;

        case ID_AUTOR:
          MuestraAyuda (Ventana, "Autor", "AyudaAutor");
          break;
        }
      SetFocus (Ventana);
      break;

    case WM_PAINT:
      Contexto = BeginPaint (Ventana,&Pintura);
      EscribeMes (Ventana, Contexto, Mes, Ano);
      EndPaint (Ventana,&Pintura);
      break;

    case WM_CLOSE:
      if ( ConfirmaSalida (Ventana) )
        { SendMessage (Ventana, WM_DESTROY, 0, 0L); }
      break;

    case WM_DESTROY: PostQuitMessage (0);  break;

    default:
      Respuesta = DefWindowProc (Ventana, Mensaje,
                                 ParametroCorto, ParametroLargo);
      break;
    }

  return ( Respuesta );
  }

/*--------------------------------------------------------------------
 * FUNCION:  BotonNormal()
 * OBJETIVO: Poner un boton de un cuadro de dilogo como normal
 * ENTRADAS: La ventana del cuadro y el identificador del botn
 * SALIDAS:  Ninguna
 *------------------------------------------------------------------*/
void
BotonNormal
  (
  HWND Ventana,
  int  Opcion
  )
  {
  HWND Boton;

  Boton = GetDlgItem (Ventana, Opcion);
  SetWindowLong (Boton, GWL_STYLE, BS_PUSHBUTTON | WS_CHILD | WS_VISIBLE);
  InvalidateRect (Boton, NULL, TRUE);
  UpdateWindow (Boton);
  }

/*--------------------------------------------------------------------
 * FUNCION:  BotonDefecto()
 * OBJETIVO: Poner un boton de un cuadro de dilogo como botn por defecto
 * ENTRADAS: La ventana del cuadro y el identificador del botn
 * SALIDAS:  Ninguna
 *------------------------------------------------------------------*/
void
BotonDefecto
  (
  HWND Ventana,
  int  Opcion
  )
  {
  HWND Boton;

  Boton = GetDlgItem (Ventana, Opcion);
  SetWindowLong (Boton, GWL_STYLE, BS_DEFPUSHBUTTON | WS_CHILD | WS_VISIBLE);
  InvalidateRect (Boton, NULL, TRUE);
  UpdateWindow (Boton);
  }

/*--------------------------------------------------------------------
 * FUNCION:  CentraVentana()
 * OBJETIVO: Centrar una ventana en pantalla
 * ENTRADAS: La ventana
 * SALIDAS:  Lgica, que indica si ha cambiado la posicin de la ventana
 * NOTA:     Slo se cambia la posicin
 *------------------------------------------------------------------*/
BOOL
CentraVentana
  (
  HWND Ventana
  )
  {
  BOOL Respuesta = FALSE;
  RECT Info;
  int  AnchoVentana, AltoVentana, Izquierda, Arriba;

  GetWindowRect (Ventana, &Info);

  AnchoVentana = Info.right - Info.left;
  AltoVentana = Info.bottom - Info.top;

  Izquierda = (AnchoPantalla()-AnchoVentana) / 2;
  Arriba = (AltoPantalla()-AltoVentana) / 2;

  if ( Izquierda >= 0 && Arriba >= 0 )
    {
    SetWindowPos (Ventana, HWND_TOP, Izquierda, Arriba, 0, 0,
                  SWP_NOACTIVATE | SWP_NOSIZE | SWP_NOREDRAW | SWP_NOZORDER);
    Respuesta = TRUE;
    }

  return ( Respuesta );
  }