/*--------------------------------------------------------------------
 * FICHERO:  Mes.c
 * OBJETIVO: Manejar los meses de cada ao
 * AUTOR:    Pedro Reina
 * FECHA:    J.15.1.1998
 *------------------------------------------------------------------*/

/*--------------------------------------------------------------------
 * Ficheros de cabecera
 *------------------------------------------------------------------*/

#include "Calendar.h"
#include <dos.h>     // struct date  getdate()
#include <stdio.h>   // sprintf()
#include <string.h>  // strlen()

/*--------------------------------------------------------------------
 * Declaracin de funciones
 *------------------------------------------------------------------*/

BOOL EsBisiesto (entero);
entero DiaSemana (entero,entero,entero);

/*--------------------------------------------------------------------
 * Definicin de funciones
 *------------------------------------------------------------------*/

/*--------------------------------------------------------------------
 * FUNCION:  EscribeMes()
 * OBJETIVO: Escribir en una ventana los das de un mes
 * ENTRADAS: La ventana padre, un contexto para dibujar,
 *           el mes y el ao
 * SALIDAS:  Ninguna
 *------------------------------------------------------------------*/
void EscribeMes
  (
  HWND   Ventana,
  HDC    Contexto,
  entero Mes,
  entero Ano
  )
  {
  static char *NombreMes[] = { "Enero","Febrero","Marzo","Abril",
                               "Mayo","Junio","Julio","Agosto",
                               "Septiembre","Octubre","Noviembre",
                               "Diciembre" };
  static char *NombreSemana[] = { "Lun","Mar","Mi","Jue",
                                  "Vie","Sb", "Dom"};
  static int Longitud[] = { 31,28,31,30,31,30,31,31,30,31,30,31 };
  char Texto[20];
  int Dia, Fila, Columna, Tope, Ancho, AnchoVentana, Alto;

  RECT Info;
  TEXTMETRIC Metrica;

  // Calculamos las medidas que vamos a usar
  GetClientRect (Ventana, &Info);
  AnchoVentana = Info.right;
  GetTextMetrics (Contexto, &Metrica);
  Alto = 1.5 * Metrica.tmHeight;
  Fila = Alto/2;
  Ancho = AnchoVentana/8;

  // Ajustamos el modo de presentar texto
  SetTextAlign (Contexto, TA_CENTER);

  // Usamos los colores del sistema
  SetTextColor (Contexto, GetSysColor(COLOR_WINDOWTEXT));
  SetBkColor (Contexto, GetSysColor(COLOR_WINDOW));

  // Escribimos el nombre del mes y el ao
  sprintf (Texto, "%s %ld", NombreMes[Mes-1], Ano);
  TextOut (Contexto, AnchoVentana/2, Fila, Texto, strlen(Texto));
  Fila += 1.5*Alto;

  // Escribimos los nombres abreviados de los das de la semana
  for ( Dia = 1 ; Dia < 8 ; Dia++ )
    { TextOut (Contexto, Ancho*Dia, Fila, NombreSemana[Dia-1], 3); }
  Fila += Alto;

  // Calculamos cuntos das tiene el mes
  Tope = Longitud [Mes-1];
  if ( Mes == 2 && EsBisiesto(Ano) )  { Tope++; }

  // Calculamos dnde empezar a escribir
  Columna = DiaSemana (Ano, Mes, 1) - 1;
  if ( Columna == -1 )  { Columna = 6; }

  // Escribimos los das
  for ( Dia = 1 ; Dia <= Tope ; Dia++ )
    {
    sprintf (Texto, "%d", Dia);
    TextOut (Contexto, Ancho*(Columna+1), Fila, Texto, strlen(Texto));
    Columna++;
    if ( Columna == 7 )
      {
      Columna = 0;
      Fila += Alto;
      }
    }
  }

/*--------------------------------------------------------------------
 * FUNCION:  DiaSemana()
 * OBJETIVO: Decir el da de la semana de una fecha
 * ENTRADAS: El ao, el mes y el da
 * SALIDAS:  Un entero que indica el da de la semana, con este convenio:
 *           0 -> Domingo, 1 -> Lunes, ..., 6 -> Sbado
 * EJEMPLO:  DiaSemana (1994,10,31)
 *------------------------------------------------------------------*/
entero DiaSemana (entero Ano, entero Mes, entero Dia)
  {
  entero Sem, Factor;

  Factor = 365 * Ano + Dia + 31*(Mes-1);
  if ( Mes < 3 ) { Ano--; }
  Factor += (entero)(Ano/4.0) - (entero)(.75*((entero)(Ano/100.0)+1));
  if ( Mes >= 3 ) { Factor -= (entero)(.4*Mes + 2.3); }
  Sem = Factor - 7*(entero)(Factor/7) - 1;
  if ( Sem == -1 ) { Sem = 6; }
  return ( Sem );
  }

/*--------------------------------------------------------------------
 * FUNCION:  EsBisiesto()
 * OBJETIVO: Decir si un ao es bisiesto
 * ENTRADAS: El ao
 * SALIDAS:  Lgica
 *------------------------------------------------------------------*/
BOOL EsBisiesto (entero Ano)
  {
  BOOL Respuesta = FALSE;

  if ( Ano % 4 == 0 )
    {
    Respuesta = TRUE;
    if ( Ano % 100 == 0 )
      {
      Respuesta = FALSE;
      if ( Ano/100 % 4 == 0 )
        { Respuesta = TRUE; }
      }
    }

  return ( Respuesta );
  }

/*--------------------------------------------------------------------
 * FUNCION:  MesHoy()
 * OBJETIVO: Decir el mes correspondiente al da de hoy
 * ENTRADAS: Ninguna
 * SALIDAS:  Un entero de 1 a 12
 *------------------------------------------------------------------*/
entero MesHoy (void)
  {
  struct date d;
  getdate(&d);
  return ( d.da_mon );
  }

/*--------------------------------------------------------------------
 * FUNCION:  AnoHoy()
 * OBJETIVO: Decir el ao correspondiente al da de hoy
 * ENTRADAS: Ninguna
 * SALIDAS:  Un entero
 *------------------------------------------------------------------*/
entero AnoHoy (void)
  {
  struct date d;
  getdate(&d);
  return ( d.da_year );
  }