/*--------------------------------------------------------------------
 * FICHERO:  CntCnx.c
 * OBJETIVO: Mdulo principal de "CntCnx"
 * AUTOR:    Pedro Reina
 * FECHA:    S.17.7.1999
 *------------------------------------------------------------------*/

/*--------------------------------------------------------------------
 * Ficheros de cabecera
 *------------------------------------------------------------------*/

#include <stdio.h>   // sprintf()  fopen()...
#include <dos.h>     // struct date  getdate()  struct time  gettime()
#include "CntCnx.h"

/*--------------------------------------------------------------------
 * Definicin de tipos
 *------------------------------------------------------------------*/

typedef long int entero;

/*--------------------------------------------------------------------
 * Definicin de macros constantes
 *------------------------------------------------------------------*/

#define ANCHO 53
#define ALTO  19

#define CARACTERES_IZQUIERDA  6
#define CARACTERES_ARRIBA     6

#define TAMPANTALLA  7
#define TAMNOMBRE    256

/*--------------------------------------------------------------------
 * Definicin de macros funciones
 *------------------------------------------------------------------*/

/*--------------------------------------------------------------------
 * MACRO:    AnchoPantalla()
 * OBJETIVO: Calcular el ancho total de la pantalla
 *------------------------------------------------------------------*/
#define AnchoPantalla()  GetSystemMetrics(SM_CXSCREEN)

/*--------------------------------------------------------------------
 * MACRO:    AltoPantalla()
 * OBJETIVO: Calcular el alto total de la pantalla
 *------------------------------------------------------------------*/
#define AltoPantalla()  GetSystemMetrics(SM_CYSCREEN)

/*--------------------------------------------------------------------
 * Declaracin de funciones
 *------------------------------------------------------------------*/

BOOL IniciaAplicacion (HANDLE,int);
LONG FAR PASCAL ProcedimientoPrincipal (HWND,UINT,WPARAM,LPARAM);
void AnotaComienzo (void);
int  DibujaVentana (void);
void DibujaCaracteres (HDC,HDC);
void EscribeCadena (char *);
entero DiaSemana (entero, entero, entero);

/*--------------------------------------------------------------------
 * Definicin de variables globales
 *------------------------------------------------------------------*/

HBITMAP Panel, Caracteres;
HWND    VentanaAplicacion;

char MapaCaracteres[] = ":0123456789";
int  PosicionCaracter[256];
char Desplazamiento[TAMPANTALLA];

int  HoraInicio, MinutoInicio, SegundoInicio;
char NombreFicheroLog[TAMNOMBRE], NombreFicheroTrumpet[TAMNOMBRE];
BOOL HayQueEscribir, HayQueInformar;

/*--------------------------------------------------------------------
 * Programa principal
 *------------------------------------------------------------------*/
#pragma argsused
int PASCAL
WinMain
  (
  HANDLE Instancia,    // Manejador de instancia de aplicacin
  HANDLE Anterior,     // Manejador de instancia anterior
  LPSTR  Parametros,   // Cadena con la lnea de parmetros
  int    ModoMostrar   // Aplicacin como ventana o como icono
  )
  {
  MSG Mensaje;

  if ( !IniciaAplicacion (Instancia, ModoMostrar) )
    { return FALSE; }

  while ( GetMessage (&Mensaje, NULL, 0, 0) )
    {
    TranslateMessage (&Mensaje);
    DispatchMessage (&Mensaje);
    }

  return ( Mensaje.wParam );
  }

/*--------------------------------------------------------------------
 * Definicin de funciones
 *------------------------------------------------------------------*/

/*--------------------------------------------------------------------
 * FUNCION:  IniciaAplicacion()
 * OBJETIVO: Arrancar la aplicacin, registrar la clase de ventana,
 *           leer datos de win.ini y crear la ventana principal
 *------------------------------------------------------------------*/
static BOOL
IniciaAplicacion
  (
  HINSTANCE Instancia,
  int       ModoMostrar
  )
  {
  int      i, Izquierda, Arriba;
  WNDCLASS Clase;
  HWND     VentanaPrincipal;
  char     NombrePorDefecto[1];

  // Registramos la clase de ventana
  Clase.style	      = 0;
  Clase.lpfnWndProc   = ProcedimientoPrincipal;
  Clase.cbClsExtra    = 0;
  Clase.cbWndExtra    = 0;
  Clase.hInstance     = Instancia;
  Clase.hIcon	      = LoadIcon (Instancia, "CntCnx");
  Clase.hCursor	      = LoadCursor (NULL, IDC_ARROW);
  Clase.hbrBackground = (HBRUSH)(0);
  Clase.lpszMenuName  = NULL;
  Clase.lpszClassName = "CntCnx";

  if ( !RegisterClass (&Clase) )
    { return ( FALSE ); }

  // Leemos la posicin de la ventana de la seccin
  // [Control de conexin] del Win.ini
  Izquierda = GetProfileInt ("Control de conexin", "Izquierda", 0);
  Arriba    = GetProfileInt ("Control de conexin", "Arriba", 0);

  // Cuidamos que los valores sean correctos
  if ( Izquierda > AnchoPantalla() || Izquierda < 0 )
    { Izquierda = 0; }
  if ( Arriba > AltoPantalla() || Arriba < 0 )
    { Arriba = 0; }

  // Leemos el nombre del fichero log
  NombrePorDefecto[0] = '\0';
  if ( GetProfileString ("Control de conexin", "Archivo", NombrePorDefecto,
                         NombreFicheroLog, TAMNOMBRE) )
    { HayQueEscribir = TRUE; }
  else
    { HayQueEscribir = FALSE; }

  // Leemos el nombre del fichero de configuracin de Trumpet
  if ( GetProfileString ("Control de conexin", "Trumpet", NombrePorDefecto,
                         NombreFicheroTrumpet, TAMNOMBRE) )
    { HayQueInformar = TRUE; }
  else
    { HayQueInformar = FALSE; }

  // Creamos la ventana principal
  VentanaPrincipal = CreateWindowEx (WS_EX_TOPMOST,
    "CntCnx", "Crono",
    WS_POPUP | WS_BORDER | WS_CAPTION,
    Izquierda, Arriba,
    ANCHO+GetSystemMetrics(SM_CXBORDER),
    ALTO+GetSystemMetrics(SM_CYCAPTION),
    NULL, NULL, Instancia, NULL);

  if ( !VentanaPrincipal )
    { return ( FALSE ); }

  // Cargamos los bitmaps
  Panel  = LoadBitmap (Instancia, MAKEINTRESOURCE(IDB_CNTCNX));
  Caracteres = LoadBitmap (Instancia, MAKEINTRESOURCE(IDB_DIGITOS));

  // Damos valores iniciales
  for ( i=0 ; i<256 ; i++ )
    { PosicionCaracter[i] = 0; }
  for ( i=0 ; MapaCaracteres[i] ; i++ )
    { PosicionCaracter[MapaCaracteres[i]] = i*6; }
  EscribeCadena ("0:00:00");

  // Mostramos la ventana
  ShowWindow (VentanaPrincipal, ModoMostrar);

  return ( TRUE );
  }

/*--------------------------------------------------------------------
 * FUNCION:  ProcedimientoPrincipal()
 * OBJETIVO: Recibir los mensajes de Windows para la clase
 *           de ventanas principal de esta aplicacin
 *------------------------------------------------------------------*/
LONG FAR PASCAL
ProcedimientoPrincipal
  (
  HWND   Ventana,        // Ventana a la que se enva el mensaje
  UINT   Mensaje,        // El mensaje
  WPARAM ParametroCorto, // Informacin adicional
  LPARAM ParametroLargo  // Informacin adicional
  )
  {
  static UINT Cronometro;
  RECT PosicionVentana;
  static int Hora, Minuto, Segundo;
  struct time t;
  char Aux[TAMPANTALLA+1];
  FILE  *Fichero;

  VentanaAplicacion = Ventana;

  switch ( Mensaje )
    {
    case WM_CREATE:
      AnotaComienzo();
      Hora = HoraInicio;
      Minuto = MinutoInicio;
      Segundo = SegundoInicio;
      Cronometro = SetTimer (Ventana, ID_CRONO, 1000, NULL);
      break;

    case WM_TIMER:
      // Vemos qu hora es
      gettime (&t);
      Hora = t.ti_hour;
      Minuto = t.ti_min;
      Segundo = t.ti_sec;

      // Cambiamos los valores para que se pueda hacer la diferencia
      if ( Segundo < SegundoInicio )
        {
        Segundo += 60;
        Minuto--;
        }
      if ( Minuto < MinutoInicio )
        {
        Minuto += 60;
        Hora--;
        }
      if ( Hora < HoraInicio )
        { Hora += 24; }
      while ( Hora - HoraInicio > 9 )
        { Hora -= 10; }

      // Escribimos en la pantalla
      sprintf (Aux, "%d:%02d:%02d", Hora - HoraInicio,
               Minuto - MinutoInicio, Segundo - SegundoInicio);
      EscribeCadena (Aux);
      InvalidateRect (VentanaAplicacion, NULL, FALSE);

      break;

    case WM_PAINT: return DibujaVentana();

    case WM_DESTROY:
      // Anotamos la posicin de la ventana
      GetWindowRect (Ventana, &PosicionVentana);
      sprintf (Aux, "%d", PosicionVentana.left);
      WriteProfileString ("Control de conexin", "Izquierda", Aux);
      sprintf (Aux, "%d", PosicionVentana.top);
      WriteProfileString ("Control de conexin", "Arriba", Aux);

      // Calculamos el tiempo total de conexin
      sprintf (Aux, "%d:%02d:%02d", Hora - HoraInicio,
               Minuto - MinutoInicio, Segundo - SegundoInicio);

      // Informamos del tiempo final
      if ( HayQueInformar )
        {
        WritePrivateProfileString ("Control de conexin", "$tiempo",
                                   Aux, NombreFicheroTrumpet);
        }
        
      // Escribimos en el fichero log el tiempo de conexin
      if ( HayQueEscribir )
        {
        if ( Fichero = fopen (NombreFicheroLog, "a") )
          {
          fprintf (Fichero, ". Duracin: %s", Aux);
          fclose (Fichero);
          }
        }

      if ( Cronometro )  { KillTimer (Ventana, ID_CRONO); }

      PostQuitMessage(0);
      break;
    }

  return ( DefWindowProc (Ventana, Mensaje,
                          ParametroCorto, ParametroLargo) );
  }

/*--------------------------------------------------------------------
 * FUNCION:  AnotaComienzo()
 * OBJETIVO: Calcular y anotar en un fichero el momento del
 *           comienzo del programa
 *------------------------------------------------------------------*/
void AnotaComienzo (void)
  {
  struct time t;
  struct date d;
  FILE  *Fichero;
  char   Aux[40];
  char  *Nombre = "DLMXJVS";

  // Vemos qu hora es
  gettime (&t);
  HoraInicio = t.ti_hour;
  MinutoInicio = t.ti_min;
  SegundoInicio = t.ti_sec;

  // Escribimos en el fichero log el da y la hora de conexin
  if ( HayQueEscribir )
    {
    if ( Fichero = fopen (NombreFicheroLog, "a") )
      {
      getdate(&d);
      fprintf (Fichero, "\nFecha: %c.%02d.%02d.%4d. Hora: %02d:%02d:%02d",
               Nombre [DiaSemana (d.da_year, d.da_mon, d.da_day)],
               d.da_day, d.da_mon, d.da_year,
               HoraInicio, MinutoInicio, SegundoInicio);
      fclose (Fichero);
      }
    }
  }

/*--------------------------------------------------------------------
 * FUNCION:  DibujaVentana()
 * OBJETIVO: Dibujar el contenido de la ventana
 *------------------------------------------------------------------*/
int
DibujaVentana (void)
  {
  PAINTSTRUCT Pintura;
  HDC Contexto = BeginPaint (VentanaAplicacion, &Pintura);
  HDC Auxiliar = CreateCompatibleDC (Contexto);

  // Dibujamos el cronmetro
  SelectObject (Auxiliar, Panel);
  BitBlt (Contexto, 0, 0, ANCHO, ALTO, Auxiliar, 0, 0, SRCCOPY);

  // Dibujamos los nmeros
  DibujaCaracteres (Contexto, Auxiliar);

  DeleteDC (Auxiliar);
  EndPaint (VentanaAplicacion, &Pintura);

  return ( 0 );
  }

/*--------------------------------------------------------------------
 * FUNCION:  DibujaCaracteres()
 * OBJETIVO: Dibujar los nmeros del cronmetro
 *------------------------------------------------------------------*/
void
DibujaCaracteres
  (
  HDC Contexto,
  HDC Auxiliar
  )
  {
  int i;

  SelectObject (Auxiliar, Caracteres);
  for ( i=0 ; i<TAMPANTALLA ; i++)
    {
    BitBlt (Contexto, CARACTERES_IZQUIERDA+6*i, CARACTERES_ARRIBA, 5, 7,
	    Auxiliar, Desplazamiento[i], 0, SRCCOPY);
    }
  }

/*--------------------------------------------------------------------
 * FUNCION:  EscribeCadena()
 * OBJETIVO: Escribir en la pantalla del crono una cadena
 *------------------------------------------------------------------*/
void
EscribeCadena
  (
  char *Cadena
  )
  {
  int i;

  for ( i=0 ; i<TAMPANTALLA && Cadena[i] ; i++ )
    { Desplazamiento[i] = PosicionCaracter[Cadena[i]]; }
  }

/*--------------------------------------------------------------------
 * FUNCION:  DiaSemana()
 * OBJETIVO: Decir el da de la semana de una fecha
 * ENTRADAS: El ao, el mes y el da
 * SALIDAS:  Un entero que indica el da de la semana, con este convenio:
 *           0 -> Domingo, 1 -> Lunes, ..., 6 -> Sbado
 * EJEMPLO:  DiaSemana (1994,10,31)
 *------------------------------------------------------------------*/
entero DiaSemana (entero Ano, entero Mes, entero Dia)
  {
  entero Sem, Factor;

  Factor = 365 * Ano + Dia + 31*(Mes-1);
  if ( Mes < 3 ) { Ano--; }
  Factor += (entero)(Ano/4.0) - (entero)(.75*((entero)(Ano/100.0)+1));
  if ( Mes >= 3 ) { Factor -= (entero)(.4*Mes + 2.3); }
  Sem = Factor - 7*(entero)(Factor/7) - 1;
  if ( Sem == -1 ) { Sem = 6; }
  return ( Sem );
  }