/*--------------------------------------------------------------------
 * FICHERO:  ComprExp.c
 * OBJETIVO: Definiciones comunes de ComprExp
 * AUTOR:    Pedro Reina
 * FECHA:    M.21.7.1998
 *------------------------------------------------------------------*/

/*--------------------------------------------------------------------
 * Ficheros de cabecera
 *------------------------------------------------------------------*/

#include "ComprExp.h"

/*--------------------------------------------------------------------
 * Definicin de mensajes al usuario
 *------------------------------------------------------------------*/

#ifdef PR_CASTELLANO
#define MensajeFinal  "\nPulsa una tecla para terminar: "
#define MensajeError  "\nError fatal. %s\n"
#endif

#ifdef PR_INGLES
#define MensajeFinal  "\nPress any key to continue: "
#define MensajeError  "\nFatal error. %s\n"
#endif

/*--------------------------------------------------------------------
 * Mensaje de salida en el QL
 *------------------------------------------------------------------*/

#ifdef PR_QDOS
char *_endmsg = MensajeFinal;
#endif

/*--------------------------------------------------------------------
 * Definicin de macros constantes
 *------------------------------------------------------------------*/

 /* Ninguno */

/*--------------------------------------------------------------------
 * Definicin de variables globales
 *------------------------------------------------------------------*/

/* Los ficheros de donde se lee y se escribe */
FILE *Entrada, *Salida;

/* Datos necesarios para las estadsticas de un fichero */
unsigned long ContadorParcial, Paso, Punto,
              TamanoOriginal, TamanoComprimido;

/* Compresin LZSS */
unsigned char Texto[VENTANA+VER-1];

/* Codificacin Huffman */
unsigned short Frecuencia[TABLA+1];   /* Tabla de frecuencias               */
int short Hijo[TABLA];      /* Punteros a los nodos hijo: Hijo[] e Hijo[]+1 */
int short Padre[TABLA+NUMCAR];        /* Punteros a los nodos padre         */
unsigned short AuxLZW;
unsigned char LongLZW;

/*--------------------------------------------------------------------
 * Declaracin de funciones
 *------------------------------------------------------------------*/

 /* Ninguna */

/*--------------------------------------------------------------------
 * Definicin de macros funciones
 *------------------------------------------------------------------*/

 /* Ninguno */

/*--------------------------------------------------------------------
 * Definicin de funciones
 *------------------------------------------------------------------*/

/*--------------------------------------------------------------------
 * FUNCION:  ErrorFatal()
 * OBJETIVO: Dar al usuario un mensaje y abortar el programa
 * ENTRADAS: El mensaje
 * SALIDAS:  Ninguna. El programa aborta.
 * EJEMPLO:  ErrorFatal ("Problema irrecuperable")
 *------------------------------------------------------------------*/
void ErrorFatal (char *Mensaje)
  {
  printf (MensajeError, Mensaje);
  exit (1);
  }

/*--------------------------------------------------------------------
 * FUNCION:  ArreglaSeparador()
 * OBJETIVO: Conseguir que el separador de un nombre de fichero sea
 *           el correcto para el sistema operativo objetivo
 * ENTRADAS: El nombre del fichero
 * SALIDAS:  El nombre puede quedar modificado
 *------------------------------------------------------------------*/
void ArreglaSeparador (char *Nombre)
  {
  char  c, Origen, Destino;
  short i;

  #ifdef PR_LINUX_MSDOS
    Origen = '_';
    Destino = '.';
  #endif
  #ifdef PR_QDOS
    Origen = '.';
    Destino = '_';
  #endif

  for ( i=0 ; c=Nombre[i] ; i++ )
    {
    if ( c==Origen )  { Nombre[i] = Destino; }
    }
  }

/*--------------------------------------------------------------------
 * FUNCION:  IniciaHuffman()
 * OBJETIVO: Dar valores iniciales al sistema de codificacin Huffman
 * ENTRADAS: Ninguna
 * SALIDAS:  Ninguna
 *------------------------------------------------------------------*/
void IniciaHuffman (void)
  {
  int short i, j;

  for ( i=0; i<NUMCAR ; i++ )
    {
    Frecuencia[i] = 1;
    Hijo[i] = i+TABLA;
    Padre[i+TABLA] = i;
    }

  i=0;
  j=NUMCAR;
  while ( j<=RAIZ )
    {
    Frecuencia[j] = Frecuencia[i] + Frecuencia[i+1];
    Hijo[j] = i;
    Padre[i] = Padre[i+1] = j;
    i += 2;
    j++;
    }

  Frecuencia[TABLA] = 0xFFFF;
  Padre[RAIZ] = 0;

  AuxLZW = 0;
  LongLZW = 0;
  }

/*--------------------------------------------------------------------
 * FUNCION:  Actualiza()
 * OBJETIVO: Incrementar la frecuencia de smbolos y actualizar
 *           el rbol de Huffman
 * ENTRADAS: El smbolo
 * SALIDAS:  Ninguna
 *------------------------------------------------------------------*/
void Actualiza (int short c)
  {
  int short i, j, k, l;

  if ( Frecuencia[RAIZ] == MAX_FREC )
    { Reconstruye(); }
  c = Padre[c+TABLA];
  do
    {
    k = ++Frecuencia[c];

    /* Si el orden de los nodos ha quedado incorrecto,
       intercambiamos nodos */
    if ( k > Frecuencia[l=c+1] )
      {
      while (k > Frecuencia[++l])
        ;
      l--;
      Frecuencia[c] = Frecuencia[l];
      Frecuencia[l] = k;

      i = Hijo[c];
      Padre[i] = l;
      if ( i<TABLA )
        { Padre[i+1] = l; }

      j = Hijo[l];
      Hijo[l] = i;

      Padre[j] = c;
      if ( j<TABLA )
        { Padre[j+1] = c; }
      Hijo[c] = j;

      c = l;
      }
    } while ( c = Padre[c] );    /* Repetimos hasta la raz */
  }

/*--------------------------------------------------------------------
 * FUNCION:  Reconstruye()
 * OBJETIVO: Reconstruir el rbol de Huffman
 * ENTRADAS: Ninguna
 * SALIDAS:  Ninguna
 *------------------------------------------------------------------*/
void Reconstruye (void)
  {
  int short i, j, k;
  unsigned short f, l;

  /* Recogemos los nodos hojas en la primera mitad de la tabla
     y reemplazamos sus frecuencias por la mitad de uno ms
     de la frecuencia primitiva */
  j = 0;
  for ( i=0 ; i<TABLA ; i++ )
    {
    if ( Hijo[i] >= TABLA )
      {
      Frecuencia[j] = (Frecuencia[i] + 1) / 2;
      Hijo[j] = Hijo[i];
      j++;
      }
    }

  /* Comenzamos la construccin del rbol conectando los hijos */
  for ( i=0 , j=NUMCAR ; j<TABLA ; i+=2 , j++ )
    {
    k = i+1;
    f = Frecuencia[j] = Frecuencia[i] + Frecuencia[k];
    for ( k=j-1 ; f<Frecuencia[k] ; k-- )
      ;
    k++;
    l = (j-k) * 2;
    memmove (&Frecuencia[k+1], &Frecuencia[k], l);
    Frecuencia[k] = f;
    memmove (&Hijo[k+1], &Hijo[k], l);
    Hijo[k] = i;
    }

  /* Conectamos los padres */
  for ( i=0 ; i<TABLA ; i++ )
    {
    if ( (k=Hijo[i]) >= TABLA )
      { Padre[k] = i; }
    else
      { Padre[k] = Padre[k+1] = i; }
    }
  }