/*--------------------------------------------------------------------
 * FICHERO:  Expande.c
 * OBJETIVO: Expandir un fichero creando los que contiene
 * AUTOR:    Pedro Reina
 * FECHA:    M.21.7.1998
 *------------------------------------------------------------------*/

/*--------------------------------------------------------------------
 * Ficheros de cabecera
 *------------------------------------------------------------------*/

#include "ComprExp.h"

/*--------------------------------------------------------------------
 * Definicin de mensajes al usuario
 *------------------------------------------------------------------*/

#ifdef PR_CASTELLANO
#define FichDatosComprimidos "\nFichero de datos comprimidos: %s\n"
#define ExpandePedroReina    "Expande, v 2.1, Pedro Reina, Julio 1998"
#define Uso "\nPara invocar el programa:"                             \
            "\nExpande NombreFichero"                                 \
            "\n  donde NombreFichero es el nombre de un fichero que"  \
            "\n  tiene extensin cmp y contiene los datos comprimidos\n"
#endif

#ifdef PR_INGLES
#define FichDatosComprimidos "\nFile of compressed data: %s\n"
#define ExpandePedroReina "Expande, v 2.1 English, Pedro Reina, July 1998"
#define Uso "\nTo call this programme:"                               \
            "\nExpande FileName"                                      \
            "\n  where FileName is the name of a file with extension" \
            "\n  'cmp' that holds the compressed data\n"
#endif

/*--------------------------------------------------------------------
 * Definicin de macros constantes
 *------------------------------------------------------------------*/

 /* Ninguno */

/*--------------------------------------------------------------------
 * Definicin de variables globales
 *------------------------------------------------------------------*/

/* Nombre, tipo y mtodo de compresin de un fichero */
char Nombre[LONG_NOMBRE+1], Tipo, Metodo;

/* Datos necesarios para las estadsticas de un fichero */
unsigned long ContadorLectura;

/* Variables que dirigen la traduccin de caracteres */
char HayQueTraducir, CuidaCR;

/* Tabla de traducciones de caracteres */

#ifdef PR_LINUX_MSDOS
unsigned char Tra[256] = {

/* Tabla de conversin de QL-MGE a PC-8 */

/*          0   1   2   3   4   5   6   7   8   9  10  11  12  13  14  15 */

/*   0 */   0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15,
/*  16 */  16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
/*  32 */  32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
/*  48 */  48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
/*  64 */  64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
/*  80 */  80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
/*  96 */ 156, 97, 98, 99,100,101,102,103,104,105,106,107,108,109,110,111,
/* 112 */ 112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,
/* 128 */ 132, 97,134,130,148,111,134,129,135,164,145,139,160,133,131,137,
/* 144 */ 138,136,139,161,141,140,162,149,147,163,151,150,225,155,157, 96,
/* 160 */ 142, 65,143,144,153, 79,166,154,128,165,146,171,224,235,174,175,
/* 176 */ 230,227,237,173,168,181, 21,183,174,175,186,246,188,189,190,191,
/* 192 */ 192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,
/* 208 */ 208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,
/* 224 */ 224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,
/* 240 */ 240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255 };
#endif

#ifdef PR_QDOS
unsigned char Tra[256] = {

/* Tabla de conversin de PC-8 a QL-MGE */

/*          0   1   2   3   4   5   6   7   8   9  10  11  12  13  14  15 */

/*   0 */   0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15,
/*  16 */  16, 17, 18, 19, 20,182, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
/*  32 */  32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
/*  48 */  48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
/*  64 */  64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
/*  80 */  80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
/*  96 */ 159, 97, 98, 99,100,101,102,103,104,105,106,107,108,109,110,111,
/* 112 */ 112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,
/* 128 */ 168,135,131,142,128,141,134,136,145,143,144,146,149,148,160,162,
/* 144 */ 163,138,170,152,132,151,155,154,152,164,167,157, 96,158,158,159,
/* 160 */ 140,147,150,153,137,169,166,167,180,169,170,171,172,179,184,185,
/* 176 */ 176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,
/* 192 */ 192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,
/* 208 */ 208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,
/* 224 */ 172,156,226,177,228,229,176,231,232,233,234,173,236,178,238,239,
/* 240 */ 240,241,242,243,244,245,187,247,248,249,250,251,252,253,254,255 };
#endif

/*--------------------------------------------------------------------
 * Declaracin de funciones
 *------------------------------------------------------------------*/

/* Las funciones que presentan el programa */
void Presenta (void);
void MuestraUso (void);

/* Direccin general de la expansin */
char LeeCabecera (void);
void Expande (void);
void PreparaTraduccion (void);
unsigned char LeeOctetoComprimido (void);
void EscribeOctetoPlano (unsigned char);
void EscribeTraduciendo (unsigned char);

/* Expansin plana */
void ExpandePlano (void);

/* Expansin LZW */
void ExpandeLZW (void);
int DecodificaOcteto (void);
int DecodificaPosicion (void);
int TraeBit (void);
int TraeOcteto (void);

/*--------------------------------------------------------------------
 * Definicin de tablas de consulta para decodificar los 6 bits
 *   superiores de los smbolos
 *------------------------------------------------------------------*/

unsigned char ValorCodigo[256] =
  {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
  0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
  0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
  0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
  0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
  0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
  0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
  0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
  0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
  0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09,
  0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A,
  0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B,
  0x0C, 0x0C, 0x0C, 0x0C, 0x0D, 0x0D, 0x0D, 0x0D,
  0x0E, 0x0E, 0x0E, 0x0E, 0x0F, 0x0F, 0x0F, 0x0F,
  0x10, 0x10, 0x10, 0x10, 0x11, 0x11, 0x11, 0x11,
  0x12, 0x12, 0x12, 0x12, 0x13, 0x13, 0x13, 0x13,
  0x14, 0x14, 0x14, 0x14, 0x15, 0x15, 0x15, 0x15,
  0x16, 0x16, 0x16, 0x16, 0x17, 0x17, 0x17, 0x17,
  0x18, 0x18, 0x19, 0x19, 0x1A, 0x1A, 0x1B, 0x1B,
  0x1C, 0x1C, 0x1D, 0x1D, 0x1E, 0x1E, 0x1F, 0x1F,
  0x20, 0x20, 0x21, 0x21, 0x22, 0x22, 0x23, 0x23,
  0x24, 0x24, 0x25, 0x25, 0x26, 0x26, 0x27, 0x27,
  0x28, 0x28, 0x29, 0x29, 0x2A, 0x2A, 0x2B, 0x2B,
  0x2C, 0x2C, 0x2D, 0x2D, 0x2E, 0x2E, 0x2F, 0x2F,
  0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,
  0x38, 0x39, 0x3A, 0x3B, 0x3C, 0x3D, 0x3E, 0x3F,
  };

unsigned char ValorLong[256] =
  {
  0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
  0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
  0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
  0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
  0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
  0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
  0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
  0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
  0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
  0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
  0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
  0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
  0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
  0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
  0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
  0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
  0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
  0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
  0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
  0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
  0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
  0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
  0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
  0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
  0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
  0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
  0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
  0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
  0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
  0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
  0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
  0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
  };

/*--------------------------------------------------------------------
 * Definicin de macros funciones
 *------------------------------------------------------------------*/

 /* Ninguno */

/*--------------------------------------------------------------------
 * Definicin de funciones
 *------------------------------------------------------------------*/

/*--------------------------------------------------------------------
 * FUNCION:  main()
 * OBJETIVO: Ensamblar las distintas partes del programa
 * ENTRADAS: El nmero de parmetros y los parmetros. El parmetro 1
 *           debe ser el nombre sin extensin del fichero que contiene
 *           los datos comprimidos
 * SALIDAS:  Si todo va bien, se crean los ficheros con el resultado
 *           de la expansin
 * EJEMPLO:  El programa se invoca as: Expande Trabajo
 *------------------------------------------------------------------*/
void main (int Narg, char *Arg[])
  {
  char NombreDato[LONG_NOMBRE+1];
  char Mensaje[LONG_MENSAJE];

  /* Preparacin */
  setbuf (stdout, NULL);
  Presenta();
  if ( Narg != 2 )
    { MuestraUso(); }

  /* Averiguamos el nombre del fichero con los datos */
  if ( strlen (Arg[1]) > LONG_NOMBRE-4 )
    {
    sprintf (Mensaje, NombreDemasiadoLargo, Arg[1]);
    ErrorFatal (Mensaje);
    }
  strcpy (NombreDato, Arg[1]);
  strcat (NombreDato, ".cmp");
  ArreglaSeparador (NombreDato);
  printf (FichDatosComprimidos, NombreDato);

  /* Abrimos el fichero donde estn los datos comprimidos */
  Entrada = fopen (NombreDato,"rb");
  if ( !Entrada )
    {
    sprintf (Mensaje, ElFicheroNoSeAbre, NombreDato);
    ErrorFatal (Mensaje);
    }

  /* Realizamos la expansin de cada fichero */
  while ( LeeCabecera() )
    { Expande(); }

  /* Hemos acabado */
  fclose (Entrada);
  printf (Terminado);
  }

/*--------------------------------------------------------------------
 * FUNCION:  Presenta()
 * OBJETIVO: Presentar el programa
 * ENTRADAS: Ninguna
 * SALIDAS:  Ninguna
 *------------------------------------------------------------------*/
void Presenta (void)
  {
  short i;

  #ifdef PR_LINUX_MSDOS
    printf ("\n");
  #endif
  printf (ExpandePedroReina);
  putchar ('\n');
  for ( i=0 ; i<strlen(ExpandePedroReina) ; i++ )
    { putchar ('='); }
  putchar ('\n');
  }

/*--------------------------------------------------------------------
 * FUNCION:  MuestraUso()
 * OBJETIVO: Decir cmo se invoca correctamente el programa
 * ENTRADAS: Ninguna
 * SALIDAS:  Ninguna. El programa aborta
 *------------------------------------------------------------------*/
void MuestraUso (void)
  {
  printf (Uso);
  exit (0);
  }

/*--------------------------------------------------------------------
 * FUNCION:  LeeCabecera()
 * OBJETIVO: Leer del fichero de datos comprimidos la cabecera con
 *           los datos de un fichero
 * ENTRADAS: Ninguna
 * SALIDAS:  Lgica, que indica si se ha podido leer una cabecera vlida
 *           Se cambian varias variables globales
 *------------------------------------------------------------------*/
char LeeCabecera (void)
  {
  char Respuesta=1;
  unsigned char Aux[CABECERA];
  short int i;

  if ( fread (Aux, 1, CABECERA, Entrada) != CABECERA )
    { Respuesta = 0; }

  else if ( !Aux[0] )
    { Respuesta = 0; }

  else
    {
    for ( i=0 ; i<LONG_NOMBRE ; i++ )
      { Nombre[i] = Aux[i]; }
    Nombre[i] = NULL;

    i = LONG_NOMBRE;

    Tipo = Aux[i++];
    Metodo = Aux[i++];

    TamanoOriginal = 256L * 256L * 256L * Aux[i++];
    TamanoOriginal += 256L * 256L * Aux[i++];
    TamanoOriginal += 256L * Aux[i++];
    TamanoOriginal += Aux[i++];

    TamanoComprimido = 256L * 256L * 256L * Aux[i++];
    TamanoComprimido += 256L * 256L * Aux[i++];
    TamanoComprimido += 256L * Aux[i++];
    TamanoComprimido += Aux[i++];
    }

  return ( Respuesta );
  }

/*--------------------------------------------------------------------
 * FUNCION:  Expande()
 * OBJETIVO: Dirigir la expansin de un fichero
 * ENTRADAS: Ninguna, se usan variables globales
 * SALIDAS:  Ninguna, pero el programa puede abortar
 *------------------------------------------------------------------*/
void Expande (void)
  {
  short int i;
  char Mensaje[LONG_MENSAJE];

  /* Creamos el fichero de salida */
  ArreglaSeparador (Nombre);
  Salida = fopen (Nombre, "wb");
  if ( !Salida )
    {
    sprintf (Mensaje, ElFicheroNoSeCrea, Nombre);
    ErrorFatal (Mensaje);
    }

  /* Informamos al usuario */
  printf ("\n%-14s", Nombre);
  for ( i=0 ; i<PUNTOINDICA ; i++)
    { putchar ('.');  }
  for ( i=0 ; i<PUNTOINDICA ; i++)
    { CursorAtras(); }

  /* Preparamos las estadsticas */
  Paso = TamanoOriginal / PUNTOINDICA;
  ContadorParcial = 0;
  ContadorLectura = 0;
  Punto = 0;

  /* Preparamos el modo de traducir caracteres */
  PreparaTraduccion();

  /* Expandimos segn el mtodo usado */
  switch ( Metodo )
    {
    case CMP_PLANO: ExpandePlano(); break;
    case CMP_LZH:   ExpandeLZW();   break;
    }

  /* Hemos terminado */
  fclose ( Salida );
  for ( i=Punto ; i<PUNTOINDICA ; i++)
    { putchar ('o');  }
  printf ("  %lu", TamanoOriginal);
  }

/*--------------------------------------------------------------------
 * FUNCION:  PreparaTraduccion()
 * OBJETIVO: Calcular las variables globales que dirigen la traduccin
 *           de caracteres
 * ENTRADAS: Ninguna, se usan variables globales
 * SALIDAS:  Ninguna, se modifican variables globales
 *------------------------------------------------------------------*/
void PreparaTraduccion (void)
  {
  if ( Tipo == BINARIO )
    {
    HayQueTraducir = 0;
    CuidaCR = 0;
    }

  else
    {
    switch ( Tipo )
      {
      #ifdef PR_LINUX
        case TEXTO_LINUX:
          HayQueTraducir = 0;
          CuidaCR = 0;
          break;
        case TEXTO_MSDOS:
          HayQueTraducir = 0;
          CuidaCR = 1;
          break;
        case TEXTO_QDOS:
          HayQueTraducir = 1;
          CuidaCR = 0;
          break;
      #endif

      #ifdef PR_MSDOS
        case TEXTO_LINUX:
          HayQueTraducir = 0;
          CuidaCR = 1;
          break;
        case TEXTO_MSDOS:
          HayQueTraducir = 0;
          CuidaCR = 0;
          break;
        case TEXTO_QDOS:
          HayQueTraducir = 1;
          CuidaCR = 1;
          break;
      #endif

      #ifdef PR_QDOS
        case TEXTO_LINUX:
          HayQueTraducir = 1;
          CuidaCR = 0;
          break;
        case TEXTO_MSDOS:
          HayQueTraducir = 1;
          CuidaCR = 1;
          break;
        case TEXTO_QDOS:
          HayQueTraducir = 0;
          CuidaCR = 0;
          break;
      #endif
      }
    }
  }

/*--------------------------------------------------------------------
 * FUNCION:  LeeOctetoComprimido()
 * OBJETIVO: Leer un octeto del fichero de entrada
 * ENTRADAS: Ninguna
 * SALIDAS:  El octeto
 *------------------------------------------------------------------*/
unsigned char LeeOctetoComprimido (void)
  {
  int Lectura;
  unsigned char Respuesta;

  if ( ContadorLectura < TamanoComprimido )
    {
    ContadorLectura++;
    Lectura = getc (Entrada);
    Respuesta = Lectura;
    }
  else
    { Respuesta = 0; }

  return ( Respuesta );
  }

/*--------------------------------------------------------------------
 * FUNCION:  EscribeOctetoPlano()
 * OBJETIVO: Escribir un octeto en el fichero de salida
 * ENTRADAS: El octeto
 * SALIDAS:  Ninguna
 *------------------------------------------------------------------*/
void EscribeOctetoPlano (unsigned char Dato)
  {
  EscribeTraduciendo (Dato);
  ContadorParcial++;
  if ( ContadorParcial > Paso )
    {
    putchar ('o');
    ContadorParcial = 0;
    Punto++;
    }
  }

/*--------------------------------------------------------------------
 * FUNCION:  EscribeTraduciendo()
 * OBJETIVO: Escribir un octeto en el fichero de salida,
 *           traducindolo si es necesario
 * ENTRADAS: El octeto
 * SALIDAS:  Ninguna
 *------------------------------------------------------------------*/
void EscribeTraduciendo (unsigned char Dato)
  {
  if ( HayQueTraducir )  { Dato = Tra[Dato]; }

  if ( CuidaCR )
    {
    #ifdef PR_LINUX_QDOS  /* Hay que eliminar el carcter 13 */
    if ( Dato == 13 )  { return; }
    #endif

    #ifdef PR_MSDOS  /* Hay que aadir el carcter 13 antes del 10 */
    if ( Dato == 10 )  { putc (13, Salida); }
    #endif
    }

  putc (Dato, Salida);
  }

/*--------------------------------------------------------------------
 * FUNCION:  ExpandePlano()
 * OBJETIVO: Expandir un fichero sin compresin (es decir, copiarlo)
 * ENTRADAS: Ninguna, se usan variables auxiliares
 * SALIDAS:  Ninguna
 *------------------------------------------------------------------*/
void ExpandePlano (void)
  {
  unsigned char Dato;
  unsigned long i;

  for ( i=0 ; i<TamanoComprimido ; i++ )
    {
    Dato = LeeOctetoComprimido();
    EscribeOctetoPlano (Dato);
    }
  }

/*--------------------------------------------------------------------
 * FUNCION:  ExpandeLZW()
 * OBJETIVO: Expandir un fichero segn el algoritmo Lempel-Ziv usando
 *           codificacin Huffman
 * ENTRADAS: Ninguna, se usan variables auxiliares
 * SALIDAS:  Ninguna
 *------------------------------------------------------------------*/
void ExpandeLZW (void)
  {
  int short i, j, k, r, c;
  unsigned long int count;

  if ( !TamanoOriginal )
    { return; }

  IniciaHuffman();
  for ( i=0 ; i<VENTANA-VER ; i++ )
    { Texto[i] = ' '; }
  r = VENTANA - VER;

  for ( count=0 ; count<TamanoOriginal ; )
    {
    c = DecodificaOcteto();
    if ( c<256 )
      {
      EscribeOctetoPlano (c);
      Texto[r++] = c;
      r &= (VENTANA-1);
      count++;
      }
    else
      {
      i = (r-DecodificaPosicion()-1) & (VENTANA-1);
      j = c - 255 + UMBRAL;
      for ( k=0 ; k<j ; k++ )
        {
        c = Texto[(i+k) & (VENTANA-1)];
        EscribeOctetoPlano (c);
        Texto[r++] = c;
        r &= (VENTANA-1);
        count++;
        }
      }
    }
  }

/*--------------------------------------------------------------------
 * FUNCION:  DecodificaOcteto()
 * OBJETIVO: Leer un octeto decodificndolo
 * ENTRADAS: Ninguna
 * SALIDAS:  El smbolo obtenido al decodificar
 *------------------------------------------------------------------*/
int DecodificaOcteto (void)
  {
  unsigned short c;

  c = Hijo[RAIZ];

  /* Vamos desde la raz a la hoja eligiendo el nodo hijo menor si
     el bit que leemos es 0 o el mayor si leemos 1 */
  while ( c<TABLA )
    {
    c += TraeBit();
    c = Hijo[c];
    }
  c -= TABLA;
  Actualiza (c);

  return c;
  }

/*--------------------------------------------------------------------
 * FUNCION:  DecodificaPosicion()
 * OBJETIVO: Decodificar de los datos comprimidos una posicin en
 *           la ventana de datos ya descomprimidos
 * ENTRADAS: Ninguna
 * SALIDAS:  La posicin obtenida al decodificar
 *------------------------------------------------------------------*/
int DecodificaPosicion (void)
  {
  unsigned short i, j, c;

  /* Los 6 bits superiores los obtenemos de la tabla */
  i = TraeOcteto();
  c = (unsigned) ValorCodigo[i] << 6;
  j = ValorLong[i];

  /* Leemos los 6 bits inferiores tal cual */
  j -= 2;
  while (j--)
    { i = (i<<1) + TraeBit(); }

  return ( c | (i & 0x3F) );
  }

/*--------------------------------------------------------------------
 * FUNCION:  TraeBit()
 * OBJETIVO: Obtener un bit de los datos comprimidos
 * ENTRADAS: Ninguna
 * SALIDAS:  El bit
 *------------------------------------------------------------------*/
int TraeBit (void)
  {
  int short i;

  while ( LongLZW <= 8 )
    {
    i = LeeOctetoComprimido();
    AuxLZW |= i << (8-LongLZW);
    LongLZW += 8;
    }
  i = AuxLZW;
  AuxLZW <<= 1;
  LongLZW--;

  return ( i<0 );
  }

/*--------------------------------------------------------------------
 * FUNCION:  TraeOcteto()
 * OBJETIVO: Obtener un octeto de los datos comprimidos
 * ENTRADAS: Ninguna
 * SALIDAS:  El octeto
 *------------------------------------------------------------------*/
int TraeOcteto (void)
  {
  unsigned short i;

  while ( LongLZW <= 8 )
    {
    i = LeeOctetoComprimido();
    AuxLZW |= i << (8-LongLZW);
    LongLZW += 8;
    }
  i = AuxLZW;
  AuxLZW <<= 8;
  LongLZW -= 8;

  return ( i>>8 );
  }