/*--------------------------------------------------------------------
 * FICHERO:  ComprExp.h
 * OBJETIVO: Declaraciones comunes de ComprExp
 * AUTOR:    Pedro Reina
 * FECHA:    M.21.7.1998
 *------------------------------------------------------------------*/

/*--------------------------------------------------------------------
 * Sistema operativo en que se compila el programa
 *   Puede ser, por orden alfabtico:
 *     PR_LINUX -> Linux 1.3.20 con gcc 2.7.0
 *     PR_MSDOS -> MS-DOS 6.0 con Turbo C++ 1.0
 *     PR_QDOS  -> SMSQ 2.47 con c68 4.03
 *------------------------------------------------------------------*/

#define PR_MSDOS

/*--------------------------------------------------------------------
 * Lenguaje que se va a usar para los mensajes al usuario
 *   Puede ser, por orden alfabtico:
 *     PR_CASTELLANO -> Castellano o espaol, la lengua de Cervantes
 *     PR_INGLES     -> Ingls, la lengua de Shakespeare
 *------------------------------------------------------------------*/

#define PR_CASTELLANO

/*====================================================================
 * Hasta aqu la configuracin general de los programas, el resto
 * ya no es configurable
 *==================================================================*/

/*--------------------------------------------------------------------
 * Definimos parejas de sistemas operativos
 *   PR_LINUX_MSDOS: Linux o MS-DOS
 *   PR_LINUX_QDOS: Linux o QDOS
 *   PR_MSDOS_QDOS: MS-DOS o QDOS
 *------------------------------------------------------------------*/

#ifdef PR_LINUX
#define PR_LINUX_MSDOS
#define PR_LINUX_QDOS
#endif

#ifdef PR_MSDOS
#define PR_LINUX_MSDOS
#define PR_MSDOS_QDOS
#endif

#ifdef PR_QDOS
#define PR_LINUX_QDOS
#define PR_MSDOS_QDOS
#endif

/*--------------------------------------------------------------------
 * Ficheros de cabecera
 *------------------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/*--------------------------------------------------------------------
 * Definicin de mensajes al usuario
 *------------------------------------------------------------------*/

#ifdef PR_CASTELLANO
#define NombreDemasiadoLargo  "Nombre demasiado largo: %s"
#define ElFicheroNoSeAbre     "El fichero '%s' no se puede abrir"
#define ElFicheroNoSeCrea     "El fichero '%s' no se puede crear"
#define Terminado             "\n\nTerminado\n"
#endif

#ifdef PR_INGLES
#define NombreDemasiadoLargo  "Name too long: %s"
#define ElFicheroNoSeAbre     "Can't open file '%s'"
#define ElFicheroNoSeCrea     "Can't create file '%s'"
#define Terminado             "\n\nDone\n"
#endif

/*--------------------------------------------------------------------
 * Definicin de macros constantes
 *------------------------------------------------------------------*/

#define LONG_NOMBRE     12    /* Slo admitimos nombres 8.3 */
#define LONG_MENSAJE    81    /* No mayor que la anchura de una pantalla PC */
#define MAX_FICHERO    300    /* Se puede ampliar */
#define PUNTOINDICA     20    /* Nmero de puntos para mostrar el avance */
#define CABECERA        22    /* Tamao de cada cabecera de fichero */

/* Tipos de fichero */
#define BINARIO      0
#define TEXTO_LINUX  1
#define TEXTO_MSDOS  2
#define TEXTO_QDOS   3

/* Modos de compresin */
#define CMP_PLANO        0
#define CMP_LZH          1

/* Parmetros de la compresin LZSS */
#define VENTANA   4096         /* Ventana de texto          */
#define VER       60           /* Zona donde se mira        */
#define UMBRAL    2
#define HOJA      VENTANA      /* Indica una hoja del rbol */

/* Parmetros de la codificacin Huffman */

#define NUMCAR    (256-UMBRAL+VER)  /* Cdigos de carcter 0..NUMCAR-1 */
#define TABLA     (NUMCAR*2-1)      /* Tamao de la tabla              */
#define RAIZ      (TABLA-1)         /* Posicin de la raz             */
#define MAX_FREC  0x8000            /* Mxima frecuencia admitida      */

/*--------------------------------------------------------------------
 * Declaracin de variables globales
 *------------------------------------------------------------------*/

/* Los ficheros de donde se lee y se escribe */
extern FILE *Entrada, *Salida;

/* Datos necesarios para las estadsticas de un fichero */
extern unsigned long ContadorParcial, Paso, Punto,
                     TamanoOriginal, TamanoComprimido;

/* Compresin LZSS */
extern unsigned char Texto[VENTANA+VER-1];

/* Codificacin Huffman */
extern unsigned short Frecuencia[TABLA+1];   /* Tabla de frecuencias         */
extern int short Hijo[TABLA];/* Punteros a los nodos hijo: Hijo[] e Hijo[]+1 */
extern int short Padre[TABLA+NUMCAR];        /* Punteros a los nodos padre   */
extern unsigned short AuxLZW;
extern unsigned char LongLZW;

/*--------------------------------------------------------------------
 * Declaracin de funciones
 *------------------------------------------------------------------*/

/* Funciones generales */
void ErrorFatal (char *);
void ArreglaSeparador (char *);

/* Codificacin Huffman */
void IniciaHuffman (void);
void Actualiza (int short);
void Reconstruye (void);

/*--------------------------------------------------------------------
 * Definicin de macros funciones
 *------------------------------------------------------------------*/

/*--------------------------------------------------------------------
 * MACRO:    CursorAtras()
 * OBJETIVO: Mover el cursor en pantalla una posicin hacia atrs
 * ENTRADAS: Ninguna
 * SALIDAS:  Ninguna que interese
 *------------------------------------------------------------------*/
#define CursorAtras()  printf("%c",8)
