/*--------------------------------------------------------------------
 * FICHERO:  CopiFech.c
 * OBJETIVO: Escrbir en el portapapeles la fecha
 * AUTOR:    Pedro Reina
 * FECHA:    S.3.7.1999
 *------------------------------------------------------------------*/

/*--------------------------------------------------------------------
 * Ficheros de cabecera
 *------------------------------------------------------------------*/

#include <Windows.h>
#include <dos.h>     // struct date  getdate()
#include <stdio.h>   // sprintf()
#include <string.h>  // strlen()

/*--------------------------------------------------------------------
 * Definicin de tipos
 *------------------------------------------------------------------*/

typedef long int entero;

/*--------------------------------------------------------------------
 * Definicin de macros constantes
 *------------------------------------------------------------------*/

// Ninguno

/*--------------------------------------------------------------------
 * Definicin de macros funciones
 *------------------------------------------------------------------*/

// Ninguno

/*--------------------------------------------------------------------
 * Declaracin de funciones
 *------------------------------------------------------------------*/

void   EscribeFecha (char *);
entero DiaSemana (entero, entero, entero);
void   CopiaAlPortapapeles (HWND, char *);

/*--------------------------------------------------------------------
 * Definicin de variables globales
 *------------------------------------------------------------------*/

// Ninguna

/*--------------------------------------------------------------------
 * Programa principal
 *------------------------------------------------------------------*/
int main (void)
  {
  char Fecha[13];   // S.DD.MM.AAAA

  EscribeFecha (Fecha);
  CopiaAlPortapapeles (0, Fecha);

  return ( 0 );
  }

/*--------------------------------------------------------------------
 * FUNCION:  EscribeFecha()
 * OBJETIVO: Escribir la fecha en una cadena
 * ENTRADAS: La cadena donde escribir
 * SALIDAS:  Ninguna
 *------------------------------------------------------------------*/
void EscribeFecha
  (
  char * Cadena
  )
  {
  char * Nombre = "DLMXJVS";
  struct date d;

  getdate(&d);
  sprintf (Cadena, "%c.%d.%d.%d",
           Nombre [DiaSemana (d.da_year, d.da_mon, d.da_day)],
           d.da_day, d.da_mon, d.da_year);
  }

/*--------------------------------------------------------------------
 * FUNCION:  CopiaAlPortapapeles()
 * OBJETIVO: Copiar un texto en el portapapeles
 * ENTRADAS: La ventana que manda el texto y el texto
 * SALIDAS:  Ninguna
 *------------------------------------------------------------------*/
void
CopiaAlPortapapeles (HWND Ventana, char *Texto)
  {
  HGLOBAL   MemoriaGlobal;
  void FAR *Memoria;

  MemoriaGlobal = GlobalAlloc (GHND, strlen(Texto)+1);
  if ( MemoriaGlobal )
    {
    Memoria = GlobalLock (MemoriaGlobal);
    lstrcpy (Memoria, Texto);
    GlobalUnlock (MemoriaGlobal);

    OpenClipboard (Ventana);
    EmptyClipboard();
    SetClipboardData (CF_TEXT, MemoriaGlobal);
    CloseClipboard();
    }
  }

/*--------------------------------------------------------------------
 * FUNCION:  DiaSemana()
 * OBJETIVO: Decir el da de la semana de una fecha
 * ENTRADAS: El ao, el mes y el da
 * SALIDAS:  Un entero que indica el da de la semana, con este convenio:
 *           0 -> Domingo, 1 -> Lunes, ..., 6 -> Sbado
 * EJEMPLO:  DiaSemana (1994,10,31)
 *------------------------------------------------------------------*/
entero DiaSemana (entero Ano, entero Mes, entero Dia)
  {
  entero Sem, Factor;

  Factor = 365 * Ano + Dia + 31*(Mes-1);
  if ( Mes < 3 ) { Ano--; }
  Factor += (entero)(Ano/4.0) - (entero)(.75*((entero)(Ano/100.0)+1));
  if ( Mes >= 3 ) { Factor -= (entero)(.4*Mes + 2.3); }
  Sem = Factor - 7*(entero)(Factor/7) - 1;
  if ( Sem == -1 ) { Sem = 6; }
  return ( Sem );
  }