/*--------------------------------------------------------------------
 * FICHERO:  Convdb.c
 * OBJETIVO: Convertir ficheros dBase de distintos tipos
 * AUTOR:    Pedro Reina
 * FECHA:    J.12.2.1998
 *------------------------------------------------------------------*/

/*--------------------------------------------------------------------
 * Ficheros de cabecera
 *------------------------------------------------------------------*/

#include "Convdb.h"
#include <string.h>   /*  strtok()  */

/*--------------------------------------------------------------------
 * Declaracin de funciones
 *------------------------------------------------------------------*/

void LeeConfig();

void Explica();
void ExplicaObjetivo();
void ExplicaManejo();
void ExplicaAutor();
void ExplicaTeclas();

void   Fichero();
void   Convierte();
cadena NombreCompleto();
cadena EligeNombre();
int    ComparaCadena();
logico PideTipo();
cadena PideNombre();
cadena PideDirectorio();
cadena PideMascara();
cadena PideExtension();

void Opciones();

/*--------------------------------------------------------------------
 * Definicin de macros constantes
 *------------------------------------------------------------------*/

#define LONG_DIRECTORIO  24
#define LONG_EXTENSION    3
#define LONG_NOMBRE      14
#define LONG_MASCARA      8

/*--------------------------------------------------------------------
 * Variables globales
 *------------------------------------------------------------------*/

logico HayQueOrdenar = NO;

octeto Tipo = CONV_EXP_PC;

cadena DescripTipo[] = { "exp Archive  dBase PC",
                         "exp Archive  dBase QL",
                         "dBase PC  dBase QL   ",
                         "dBase QL  dBase PC   ",
                         NIL };

/*--------------------------------------------------------------------
 * Definicin de macros funciones
 *------------------------------------------------------------------*/

#define LimpiaZonaTrabajo()  Pan_Borra(NEGRO,4,0,21,79)
#define LimpiaZonaFichero()  Pan_Borra(NEGRO,11,0,21,79)

/*--------------------------------------------------------------------
 * Programa principal
 *------------------------------------------------------------------*/
void main (Narg, Arg)
int   Narg;
char *Arg[];
  {
  enum { SALIDA_ESC, SALIDA, EXPLICA, FICHERO, OPCIONES };

  static cadena Principal[] = {">Salida", "E>xplica", ">Fichero",
                               ">Opciones", NIL };
  cadena Nombre;
  entero Opcion=FICHERO;
  logico Sigue=SI;

  Pan_Define (PAN_TEXTO);
  Prg_Presenta ( "Conversor dBase", "1.1", "Pedro Reina", "Febrero 1998" );

  if ( Narg == 1 )
    {
    Nombre = Fch_Nombre ( "Convdb","cnf");
    if ( Fch_Existe (Nombre) )
      { LeeConfig (Nombre); }
    }
  else
    {
    Nombre = Cad_Duplica ( Arg[1] );
    LeeConfig (Nombre);
    }
  Cad_Destruye (Nombre);

  Cdr_Caja (CDR_SIMPLE,1,0,3,79,NEGRO,VERDE);

  while ( Sigue )
    {
    Opcion = Men_Horizontal (2,2,77,Principal,Opcion);
    switch ( Opcion )
      {
      case SALIDA_ESC:
      case SALIDA:
           if ( Usr_Consulta ("Quieres terminar el programa?") )
             { Sigue = NO; }
           Opcion = SALIDA;
           break;
      case EXPLICA:       Explica();       break;
      case FICHERO:       Fichero();       break;
      case OPCIONES:      Opciones();      break;
      }
    LimpiaZonaTrabajo();
    }

  Pan_Cierra();
  }

/*--------------------------------------------------------------------
 * Definicin de funciones
 *------------------------------------------------------------------*/

/*--------------------------------------------------------------------
 * FUNCION:  LeeConfig()
 * OBJETIVO: Leer el fichero de configuracion
 *------------------------------------------------------------------*/
void LeeConfig (Nombre)
cadena Nombre;
  {
  config    Config;
  cadena    Linea, Informe;
  contador  Tipo;
  char     *Etiqueta, *Aux, Error[80];

  Informe = "Leyendo configuracin";
  Usr_Informa (Informe);

  if ( Config = Cnf_Abre (Nombre) )
    {
    while ( Linea = Cnf_Lee (Config) )
      {
      if ( Etiqueta = strtok (Linea, " ") )
        {

        if ( Cad_Igual (Etiqueta,"Sonido") )
          {
          if ( Aux = strtok (NULL, " ") )
            {
            if ( toupper(Aux[0]) == 'S' ) { Son_Enciende(); }
            else                          { Son_Apaga(); }
            }
          }

        else if ( Cad_Igual (Etiqueta,"Ordenar") )
          {
          if ( Aux = strtok (NULL, " ") )
            { HayQueOrdenar = toupper(Aux[0]) == 'S'; }
          }

        else
          {
          sprintf (Error,
            "Opcin no reconocida en la lnea %d del fichero %s",
            Cnf_Linea (Config), Nombre);
          Usr_Avisa (Error);
          Usr_Informa (Informe);
          }

        } /* Fin if Etiqueta */
      Cad_Destruye (Linea);
      } /* Fin while Linea */
    } /* Fin if Cnf_Abre() */
  }

/*--------------------------------------------------------------------
 * FUNCION:  Explica()
 * OBJETIVO: Dirigir las explicaciones
 *------------------------------------------------------------------*/
void Explica()
  {
  enum { SALIDA_ESC, OBJETIVO, MANEJO, AUTOR, TECLAS };
  static octeto MaxOpcion = 4;

  static cadena MenuExplica[] = { ">Objetivo del programa",
                                  ">Manejo de las opciones",
                                  ">Contactar con el autor",
                                  ">Teclas PC y teclas QL",
                                  NIL };

  static cadena Presentacion[] = {
    "Puedes pedir explicacin sobre diferentes aspectos",
    "de este programa. Elige el que desees y pulsa ESC",
    "cuando hayas terminado.",
    NIL };

  logico Sigue = SI;
  entero Opcion = 1, i;

  while ( Sigue )
    {
    LimpiaZonaTrabajo();
    Pan_Color (NEGRO,BLANCO);
    for ( i=0 ; Presentacion[i] ; i++ )
      { Pan_PonTexto (6+i,15,Presentacion[i]); }

    Opcion = Men_Vertical (11,29,14,52,MenuExplica,Opcion);
    LimpiaZonaTrabajo();
    switch ( Opcion )
      {
      case SALIDA_ESC:  Sigue = NO;         break;
      case OBJETIVO:    ExplicaObjetivo();  break;
      case MANEJO:      ExplicaManejo();    break;
      case AUTOR:       ExplicaAutor();     break;
      case TECLAS:      ExplicaTeclas();    break;
      }
    if ( Opcion )  { Usr_PulsaUnaTecla(""); }
    Opcion++;
    if ( Opcion > MaxOpcion )  { Opcion = 1; }
    }
  }

/*--------------------------------------------------------------------
 * FUNCION:  ExplicaObjetivo()
 * OBJETIVO: Explicar el objetivo del programa
 *------------------------------------------------------------------*/
void ExplicaObjetivo()
  {
  static cadena Mensaje[] = {
      "Este programa permite convertir ficheros dBase entre varios tipos.",
      "",
      "Primeramente, se puede convertir un fichero exp obtenido exportando",
      "desde Archive con la opcin quill a un fichero dBase que use el juego",
      "de caracteres del QL o del PC.",
      "",
      "Por otro lado, puede convertir una base de datos dBase en otra que",
      "use un juego de caracteres distinto.",
      NIL };

  octeto i;

  Pan_Color (NEGRO,BLANCO);
  for ( i=0 ; Mensaje[i] ; i++ )
    { Pan_PonTexto (6+i,6,Mensaje[i]); }
  }

/*--------------------------------------------------------------------
 * FUNCION:  ExplicaManejo()
 * OBJETIVO: Explicar cmo se maneja el programa
 *------------------------------------------------------------------*/
void ExplicaManejo()
  {
  static cadena Mensaje[] = {
    "La opcin Fichero admite elegir el tipo de conversin que hay que",
    "realizar, as como el directorio donde leer y grabar los ficheros.",
    "Una vez determinados, se usa Convierte para elegir el fichero que",
    "hay que convertir",
    "",
    "En Opciones se pueden definir dos cosas: si el sonido est encendido",
    "o apagado y si se desea ver por orden alfabtico los ficheros en la",
    "opcion Convierte del men Fichero.",
    "",
    "Para obtener ms informacin sobre el uso del programa, lee el",
    "fichero TXT que lo acompaa.",
    "",
      NIL };

  octeto i;

  Pan_Color (NEGRO,BLANCO);
  for ( i=0 ; Mensaje[i] ; i++ )
    { Pan_PonTexto (5+i,4,Mensaje[i]); }
  }

/*--------------------------------------------------------------------
 * FUNCION:  ExplicaAutor()
 * OBJETIVO: Explicar quin es el autor y cmo contactar con l
 *------------------------------------------------------------------*/
void ExplicaAutor()
  {
  static cadena Mensaje[] = {
    "Este programa es de Dominio Pblico. Lo puedes usar, distribuir",
    "y modificar como desees.",
    "",
    "Ha sido escrito en C usando el sistema de programacin Olimpo;",
    "si no dispones de la versin 2.0 de Olimpo, puedes cargarla",
    "directamente desde mi sede web o pedrmela si no dispones de",
    "acceso a Internet.",
    "",
    "Si tienes cualquier duda o consulta, cuntamela e intentar ayudarte.",
    "",
    "Mis datos:",
    "",
    "Pedro Reina",
    "c/ Marquesa de Argeso, 4      Telfono: 91 565 17 59",
    "28019 Madrid                   Correo electrnico: pedro@anit.es",
    "Espaa                         Web: www.anit.es/pedro",
    NIL };

  octeto i;

  Pan_Color (NEGRO,BLANCO);
  for ( i=0 ; Mensaje[i] ; i++ )
    { Pan_PonTexto (5+i,5,Mensaje[i]); }
  }

/*--------------------------------------------------------------------
 * FUNCION:  ExplicaTeclas()
 * OBJETIVO: Explicar las teclas que son distintas en QL y en PC
 *------------------------------------------------------------------*/
void ExplicaTeclas()
  {
  static cadena Mensaje[] = {
      "El QL y el PC tienen distintos teclados y algunas teclas",
      "no tienen correspondiente directo.",
      "",
      "Este programa asigna a ciertas combinaciones de teclas del QL",
      "la funcin de algunas teclas del PC. sta es la relacin:",
      "",
      "         Tecla PC        Equivalente QL",
      "         --------        --------------",
      "",
      "         Inicio          Alt-Izquierda",
      "         Fin             Alt-Derecha",
      "         RePag           Alt-Arriba",
      "         AvPag           Alt-Abajo",
      "         Insert          Maysculas-Fijamaysculas",
      "         Supr            Ctrl-Derecha",
      "         Retroceso       Ctrl-Izquierda",
       NIL };

  octeto i;

  Pan_Color (NEGRO,BLANCO);
  for ( i=0 ; Mensaje[i] ; i++ )
    { Pan_PonTexto (5+i,9,Mensaje[i]); }
  }

/*--------------------------------------------------------------------
 * FUNCION:  Fichero()
 * OBJETIVO: Presentar y manejar las opciones de manejo de ficheros
 * ENTRADAS: Ninguna
 * SALIDAS:  Ninguna
 *------------------------------------------------------------------*/
void Fichero()
  {
  enum { SALIDA_ESC, TIPO, CONVERTIR, DIRECTORIO, MASCARA, EXTENSION };
  static cadena MenuFich[] = {">Tipo", ">Convierte", ">Directorio",
                              ">Mscara", ">Extensin", NIL };

  static char Directorio[LONG_DIRECTORIO+1] = "";
  static char Nombre[LONG_NOMBRE+1]         = "";
  static char Mascara[LONG_MASCARA+1]       = "*";
  static char Extension[LONG_EXTENSION+1]   = "exp";

  cadena Aux;
  region Region;
  entero Opcion = TIPO;
  logico Sigue = SI, Refresca = SI;

  if ( Region = Reg_Crea (4,20,10,61) )
    {
    Reg_Borde (Region,CDR_SIMPLE,NEGRO,VERDE);
    Reg_Color (Region,NEGRO,VERDE);
    while ( Sigue )
      {
      if ( Refresca )
        {
        Pan_Borra (NEGRO,Reg_FilSup(Region)+1, Reg_ColIzq(Region)+15,
                         Reg_FilInf(Region)-1, Reg_ColDer(Region)-1);
        Reg_PonTexto (Region,1,15,DescripTipo[Tipo]);
        Reg_PonTexto (Region,3,15,Directorio);
        Reg_PonTexto (Region,4,15,Mascara);
        Reg_PonTexto (Region,5,15,Extension);
        Refresca = NO;
        }

      Opcion = Men_Vertical (Reg_FilSup(Region)+1, Reg_ColIzq(Region)+1,
                             Reg_FilInf(Region)-1, Reg_ColIzq(Region)+14,
                             MenuFich, Opcion);
      switch ( Opcion )
        {
        case SALIDA_ESC:  Sigue = NO;      break;

        case TIPO:        if ( PideTipo() )
                            {
                            if ( Tipo == CONV_EXP_PC || Tipo == CONV_EXP_QL )
                              { Cad_Copia (Extension, "exp"); }
                            if ( Tipo == CONV_PC_QL || Tipo == CONV_QL_PC )
                              { Cad_Copia (Extension, "dbf"); }
                            Refresca = SI;
                            }
                          break;

        case CONVERTIR:   Aux = EligeNombre(Directorio,Mascara,Extension);
                          if ( Tec_Ultima() == TEC_ENTER )
                            {
                            if ( Cad_Longitud(Aux) > LONG_NOMBRE )
                              { Aux[LONG_NOMBRE] = NULO; }
                            Cad_Copia (Nombre,Aux);
                            Convierte (Directorio,Nombre,Extension);
                            Reg_Borde (Region,CDR_SIMPLE,NEGRO,VERDE);
                            Refresca = SI;
                            }
                          Cad_Destruye (Aux);
                          break;

        case DIRECTORIO:  Aux = PideDirectorio(Directorio);
                          if ( Tec_Ultima() != TEC_ESC )
                            {
                            Cad_Copia (Directorio,Aux);
                            Refresca = SI;
                            }
                          Cad_Destruye (Aux);
                          break;

        case MASCARA:     Aux = PideMascara(Mascara);
                          if ( Tec_Ultima() != TEC_ESC )
                            {
                            Cad_Copia (Mascara,Aux);
                            Refresca = SI;
                            }
                          Cad_Destruye (Aux);
                          break;

        case EXTENSION:   Aux = PideExtension(Extension);
                          if ( Tec_Ultima() != TEC_ESC )
                            {
                            Cad_Copia (Extension,Aux);
                            Refresca = SI;
                            }
                          Cad_Destruye (Aux);
                          break;
        }
      LimpiaZonaFichero();
      }
    }
  else  { Usr_Avisa ("Falta memoria"); }
  }

/*--------------------------------------------------------------------
 * FUNCION:  Convierte()
 * OBJETIVO: Dirigir la conversin de un fichero
 * ENTRADAS: Directorio, nombre y extensin del fichero
 * SALIDAS:  Ninguna
 *------------------------------------------------------------------*/
void Convierte (Dir,Nom,Ext)
cadena Dir,Nom,Ext;
  {
  region  Info;
  fichero Fichero;
  cadena  Aux, OrigenCompleto, OrigenMayus,
          Destino, DestinoPropuesto, DestinoCompleto, DestinoMayus;
  logico  NombreAdmitido, QuiereSeguir;

  if ( Info = Reg_Crea (4,0,21,40) )
    {
    LimpiaZonaTrabajo();

    Reg_Borde (Info, CDR_SIMPLE, NEGRO, VERDE);
    Reg_TextoCentrado (Info, "Informe de la conversin", 2);
    Reg_Tinta (Info, VERDE);

    Reg_PonTexto (Info, 4, 2, "Tipo: ");
    Pan_Tinta (BLANCO);
    Pan_Texto (DescripTipo[Tipo]);

    Reg_PonTexto (Info, 6, 2, "Directorio: ");
    Pan_Tinta (BLANCO);
    if ( Dir[0] )
      { Pan_Texto (Dir); }
    else
      { Pan_Texto ("[Actual]"); }

    Reg_PonTexto (Info, 8, 2, "Fichero origen: ");
    Pan_Tinta (BLANCO);
    Pan_Texto (Nom);
    if ( Ext[0] )
      {
      Pan_Caracter (Fch_Separador());
      Pan_Texto (Ext);
      }
    OrigenMayus = Cad_Mayus (Fch_Nombre(Nom,Ext));

    NombreAdmitido = NO;
    DestinoPropuesto = Fch_Nombre (Nom,"dbf");
    while ( !NombreAdmitido )
      {
      Aux = PideNombre (DestinoPropuesto);
      if ( Tec_Ultima() == TEC_ESC )
        {
        NombreAdmitido = SI;
        QuiereSeguir = NO;
        }
      else
        {
        DestinoMayus = Cad_Mayus (Aux);
        if ( Cad_Igual (OrigenMayus, DestinoMayus) )
          {
          Usr_Avisa (
            "Los fichero de origen y destino no pueden tener el mismo nombre"
                    );
          }
        else
          {
          NombreAdmitido = SI;
          QuiereSeguir = SI;
          DestinoCompleto = Cad_Une (Dir, Aux, CAD_FIN);
          Destino = Cad_Duplica (Aux);
          }
        }
      Cad_Destruye (Aux);
      }
    Cad_Destruye (DestinoPropuesto);

    if ( QuiereSeguir )
      {
      Reg_PonTexto (Info, 10, 2, "Fichero destino: ");
      Pan_Tinta (BLANCO);
      Pan_Texto (Destino);

      OrigenCompleto = NombreCompleto (Dir,Nom,Ext);
      if ( Tipo == CONV_PC_QL || Tipo == CONV_QL_PC )
        { ConvierteJuego (Info, OrigenCompleto, DestinoCompleto, Tipo); }
      else
        { ConvierteExpDb (Info, OrigenCompleto, DestinoCompleto, Tipo); }
      Cad_Destruye (OrigenCompleto);
      Cad_Destruye (DestinoCompleto);
      Cad_Destruye (Destino);
      }

    Cad_Destruye (OrigenMayus);
    Reg_Destruye (Info);
    LimpiaZonaTrabajo();
    }

  else
    { Usr_Avisa ("No hay memoria"); }
  }

/*--------------------------------------------------------------------
 * FUNCION:  NombreCompleto()
 * OBJETIVO: Devolver el nombre completo de un fichero
 * ENTRADAS: Directorio, nombre y extensin del fichero
 * SALIDAS:  Una cadena con el nombre completo
 * NOTA:     La cadena hay que destruirla cuando no sea necesaria
 *------------------------------------------------------------------*/
cadena NombreCompleto (Dir,Nom,Ext)
cadena Dir,Nom,Ext;
  {
  cadena Respuesta, Aux;

  Aux = Fch_Nombre (Nom,Ext);
  Respuesta = Cad_Une (Dir,Aux,CAD_FIN);
  Cad_Destruye (Aux);

  return ( Respuesta );
  }

/*--------------------------------------------------------------------
 * FUNCION:  EligeNombre()
 * OBJETIVO: Elegir un nombre de fichero de entre los posibles
 * ENTRADAS: Directorio, mscara y extensin del fichero
 * SALIDAS:  Un nombre, sin directorio ni extensin
 * NOTA:     El nombre hay que destruirlo cuando no sea necesario
 *------------------------------------------------------------------*/
cadena EligeNombre (Dir,Mas,Ext)
cadena Dir,Mas,Ext;
  {
  cadena   Respuesta, Completo, Mensaje;
  lista    Posible;
  entero   Elegido;
  region   Region;
  menu     Eleccion;
  caracter Aux[81];
  octeto   i;
  logico   Visto = NO;

  Region = Reg_Crea (11,30,21,50);
  Reg_Borde (Region, CDR_SIMPLE, NEGRO, VERDE);
  Completo = NombreCompleto(Dir,Mas,Ext);
  Usr_Informa ("Buscando ficheros");
  if ( Posible = Fch_ListaNombre (Completo) )
    {
    if ( HayQueOrdenar )
      { Posible = Lis_Ordena (Posible, ComparaCadena); }
    Eleccion = Men_Crea (MEN_VERTICAL,
                         Reg_FilSup(Region)+1, Reg_ColIzq(Region)+1,
                         Reg_FilInf(Region)-1, Reg_ColDer(Region)-1,
                         Lis_Total(Posible), MEN_LISTA, (memoria)Posible);
    if ( Elegido = Men_Ejecuta (Eleccion,(entero)1,
                   "Elige el fichero que quieres convertir") )
      {
      Men_Texto (Eleccion, Elegido, Aux);
      for ( i=Cad_Longitud(Aux)-1 ; i && !Visto ; i-- )
        {
        if ( Aux[i] == Fch_Separador() )
          {
          Aux[i] = NULO;
          Visto = SI;
          }
        }
      Respuesta = Cad_Duplica (Aux);
      }
    else  { Respuesta = Cad_Duplica (""); }

    Lis_Destruye (Posible);
    Men_Destruye (Eleccion);
    }

  else
    {
    Mensaje = Cad_Une ("No se encontrado ningn fichero ","\"",Completo,
                       "\"", CAD_FIN);
    Usr_Avisa (Mensaje);
    Cad_Destruye (Mensaje);
    Respuesta = Cad_Duplica ("");
    }

  Reg_Destruye (Region);
  Cad_Destruye (Completo);

  return ( Respuesta );
  }

/*--------------------------------------------------------------------
 * FUNCION:  ComparaCadena()
 * OBJETIVO: Comparar dos cadenas
 * ENTRADAS: Los punteros a las dos cadenas
 * SALIDAS:  Un int que indica qu cadena es menor
 *------------------------------------------------------------------*/
int ComparaCadena (Cad1,Cad2)
cadena *Cad1, *Cad2;
  {
  return ( Cad_Compara (*Cad1,*Cad2) );
  }

/*--------------------------------------------------------------------
 * FUNCION:  PideTipo()
 * OBJETIVO: Pedir al usuario el tipo de conversin
 * ENTRADAS: Ninguna, se usa la variable global Tipo
 * SALIDAS:  Lgica, que indica si el tipo ha cambiado
 *------------------------------------------------------------------*/
logico PideTipo()
  {
  entero Opcion;
  region Region;
  logico Respuesta=NO;

  if ( Region = Reg_Crea (12,27,19,54) )
    {
    Reg_Borde (Region,CDR_SIMPLE,NEGRO,VERDE);
    Reg_Color (Region, NEGRO, VERDE);
    Reg_TextoCentrado (Region,"Tipo de conversin:",1);
    Opcion = Men_Vertical (Reg_FilSup(Region)+3, Reg_ColIzq(Region)+2,
                           Reg_FilInf(Region)-1, Reg_ColDer(Region)-1,
                           DescripTipo, (entero)Tipo+1);
    if ( Opcion )
      {
      Opcion--;
      Respuesta = Opcion != Tipo;
      Tipo = Opcion;
      }

    Reg_Destruye (Region);
    }
  else  { Usr_Avisa ("Falta memoria"); }

  return ( Respuesta );
  }

/*--------------------------------------------------------------------
 * FUNCION:  PideNombre()
 * OBJETIVO: Pedir al usuario un nombre
 * ENTRADAS: El nombre propuesto
 * SALIDAS:  El nuevo nombre
 *------------------------------------------------------------------*/
cadena PideNombre (Nombre)
cadena Nombre;
  {
  region Region;
  cadena Respuesta;

  Region = Reg_Crea (8,49,15,76);
  Reg_Borde (Region,CDR_SIMPLE,NEGRO,VERDE);
  Pan_Color (NEGRO,VERDE);
  Reg_TextoCentrado (Region,"Escribe el nombre",2);
  Reg_TextoCentrado (Region,"del fichero destino:",3);
  Respuesta = Usr_Texto (Nombre, LONG_NOMBRE,
                         Reg_FilSup(Region)+5,Reg_ColIzq(Region)+7,
                         ROJO, BLANCO);

  Reg_Limpia (Region, NEGRO);
  Reg_Destruye (Region);
  return ( Respuesta );
  }

/*--------------------------------------------------------------------
 * FUNCION:  PideDirectorio()
 * OBJETIVO: Pedir al usuario un directorio
 * ENTRADAS: El directorio propuesto
 * SALIDAS:  El nuevo directorio
 *------------------------------------------------------------------*/
cadena PideDirectorio (Dir)
cadena Dir;
  {
  region Region;
  cadena Respuesta;

  Region = Reg_Crea (11,22,17,59);
  Reg_Borde (Region,CDR_SIMPLE,NEGRO,VERDE);
  Pan_Color (NEGRO,VERDE);
  Reg_TextoCentrado (Region,"Escribe el directorio:",2);
  Respuesta = Usr_Texto (Dir, LONG_DIRECTORIO,
                         Reg_FilSup(Region)+4,Reg_ColIzq(Region)+7,
                         ROJO, BLANCO);

  Reg_Destruye (Region);
  return ( Respuesta );
  }

/*--------------------------------------------------------------------
 * FUNCION:  PideMascara()
 * OBJETIVO: Pedir al usuario una mscara
 * ENTRADAS: La mscara propuesta
 * SALIDAS:  La nueva mscara
 *------------------------------------------------------------------*/
cadena PideMascara (Mascara)
cadena Mascara;
  {
  region Region;
  cadena Respuesta;

  Region = Reg_Crea (11,22,17,59);
  Reg_Borde (Region,CDR_SIMPLE,NEGRO,VERDE);
  Pan_Color (NEGRO,VERDE);
  Reg_TextoCentrado (Region,"Escribe la mscara:",2);
  Respuesta = Usr_Texto (Mascara, LONG_MASCARA,
                         Reg_FilSup(Region)+4,Reg_ColIzq(Region)+14,
                         ROJO, BLANCO);

  Reg_Destruye (Region);
  return ( Respuesta );
  }

/*--------------------------------------------------------------------
 * FUNCION:  PideExtension()
 * OBJETIVO: Pedir al usuario una extensin
 * ENTRADAS: La extensin propuesta
 * SALIDAS:  La nueva extensin
 *------------------------------------------------------------------*/
cadena PideExtension (Extension)
cadena Extension;
  {
  region Region;
  cadena Respuesta;

  Region = Reg_Crea (11,22,17,59);
  Reg_Borde (Region,CDR_SIMPLE,NEGRO,VERDE);
  Pan_Color (NEGRO,VERDE);
  Reg_TextoCentrado (Region,"Escribe la extensin:",2);
  Respuesta = Usr_Texto (Extension, LONG_EXTENSION,
                         Reg_FilSup(Region)+4,Reg_ColIzq(Region)+16,
                         ROJO, BLANCO);

  Reg_Destruye (Region);
  return ( Respuesta );
  }

/*--------------------------------------------------------------------
 * FUNCION:  Opciones()
 * OBJETIVO: Seleccionar las opciones del programa
 * ENTRADAS: Ninguna
 * SALIDAS:  Las variables globales pueden modificarse
 *------------------------------------------------------------------*/
void Opciones()
  {
  enum { SALIDA_ESC, SONIDO, ORDEN };
  static cadena MenuOpc[] = {">Sonido", ">Orden", NIL };
  entero Opcion = SONIDO;
  logico Sigue = SI;
  region Region;

  if ( Region = Reg_Crea (4,59,7,79) )
    {
    Reg_Borde (Region,CDR_SIMPLE,NEGRO,VERDE);
    while ( Sigue )
      {
      Pan_Color (NEGRO, VERDE);
      Reg_Cursor (Region,1,10);
      if ( Son_Estado() )  { Pan_Texto ("Encendido"); }
      else                 { Pan_Texto ("Apagado  "); }

      Reg_Cursor (Region,2,10);
      if ( HayQueOrdenar )  { Pan_Texto ("S"); }
      else                  { Pan_Texto ("No"); }

      Opcion = Men_Vertical (Reg_FilSup(Region)+1, Reg_ColIzq(Region)+1,
                             Reg_FilInf(Region)-1, Reg_ColIzq(Region)+9,
                             MenuOpc, Opcion);
      switch ( Opcion )
        {
        case SALIDA_ESC: Sigue = NO;                      break;
        case SONIDO:     Son_Cambia();                    break;
        case ORDEN:      HayQueOrdenar = !HayQueOrdenar;  break;
        }
      }
    Reg_Destruye (Region);
    }
  else  { Usr_Avisa ("Falta memoria"); }
  }