/*--------------------------------------------------------------------
 * FICHERO:  Convexdb.c
 * OBJETIVO: Definir la funcin ConvierteExpDb()
 * AUTOR:    Pedro Reina
 * FECHA:    J.11.4.1996
 *------------------------------------------------------------------*/

/*--------------------------------------------------------------------
 * Ficheros de cabecera
 *------------------------------------------------------------------*/

#include "Convdb.h"

/*--------------------------------------------------------------------
 * Declaracin de funciones
 *------------------------------------------------------------------*/

entero   CalculaLongRegistro();
entero   CalculaTotalRegistro();
contador ExaminaCabecera();
void     ExaminaCamposNumericos();
logico   HayAlgunCampoNumerico();
basedato CreaBase();
void     EscribeRegistros();
void     ExplicaEstructura();

/*--------------------------------------------------------------------
 * Definicin de macros constantes
 *------------------------------------------------------------------*/

#define MAX_CAMPO  255

/*--------------------------------------------------------------------
 * Variables globales
 *------------------------------------------------------------------*/

caracter NombreCampo [MAX_CAMPO][MAX_NOMBRE+1];
caracter TipoCampo [MAX_CAMPO];
contador LongCampo [MAX_CAMPO];
contador LongCampoExp [MAX_CAMPO];
contador LongEntera [MAX_CAMPO];
contador LongDecimal [MAX_CAMPO];
entero   Inicio [MAX_CAMPO];
entero   LongRegistro;
entero   TotalRegistro;
contador TotalCampo;

/*--------------------------------------------------------------------
 * Definicin de macros funciones
 *------------------------------------------------------------------*/

 /*  Ninguno  */

/*--------------------------------------------------------------------
 * Definicin de funciones
 *------------------------------------------------------------------*/

/*--------------------------------------------------------------------
 * FUNCION:  ConvierteExpDb()
 * OBJETIVO: Convertir un fichero exp, creado por Archive con la versin
 *           quill, en un fichero dBase
 * ENTRADAS: Una regin donde informar del desarrollo de proceso,
 *           el nombre del fichero origen y el destino y el tipo
 *           de conversin
 * SALIDAS:  Ninguna
 *------------------------------------------------------------------*/
void ConvierteExpDb (Info, Origen, Destino, Tipo)
region Info;
cadena Origen, Destino;
octeto Tipo;
  {
  fichero  FichOrigen;
  contador i;
  cadena   Aux;
  basedato Base;

  if ( FichOrigen = Fch_AbreLeer (Origen, FCH_BINARIO) )
    {
    Usr_Informa ("Examinando el fichero origen");
    if ( LongRegistro = CalculaLongRegistro (FichOrigen) )
      {
      Aux = Cad_Crea (LongRegistro);
      if ( TotalCampo = ExaminaCabecera (FichOrigen, Aux, Tipo) )
        {
        TotalRegistro = CalculaTotalRegistro (FichOrigen);
        Reg_PonTexto (Info, 12, 2, "Nmero de registros: ");
        Pan_Tinta (BLANCO);
        Pan_Entero (TotalRegistro,1);
        if ( HayAlgunCampoNumerico() )
          { ExaminaCamposNumericos (FichOrigen, Aux); }
        for ( i=0 ; i<TotalCampo ; i++ )
          {
          if ( TipoCampo[i] == 'N' )
            {
            LongCampo[i] = LongEntera[i] + LongDecimal[i] + (LongDecimal[i]>0);
            }
          else
            { LongCampo[i] = LongCampoExp[i]; }
          }
        ExplicaEstructura();
        if ( Base = CreaBase (Destino,Tipo) )
          {
          Usr_Informa ("Creando base de datos");
          EscribeRegistros (FichOrigen, Base, Tipo, Aux);
          Bdt_Cierra (Base);
          Usr_PulsaUnaTecla ("Base de datos creada");
          }
        }
      Cad_Destruye (Aux);
      }
    Fch_Cierra (FichOrigen);
    }
  }

/*--------------------------------------------------------------------
 * FUNCION:  CalculaLongRegistro()
 * OBJETIVO: Calcular cunto ocupa cada registro del fichero exp
 * ENTRADAS: El fichero
 * SALIDAS:  La longitud del registro, incluyendo el fin de lnea.
 *           Si hay algn error, se devuelve 0
 *------------------------------------------------------------------*/
entero CalculaLongRegistro (Fichero)
fichero Fichero;
  {
  entero Respuesta=0;
  octeto Aux;
  logico Sigue = SI;

  Fch_Coloca (Fichero, 0);
  while ( Fch_LeeOcteto (Fichero, &Aux, 1) && Sigue )
    {
    Respuesta++;
    if ( Aux == 10 )  { Sigue = NO; }
    }

  if ( Sigue )  { Respuesta = 0; }

  return ( Respuesta );
  }

/*--------------------------------------------------------------------
 * FUNCION:  ExaminaCabecera()
 * OBJETIVO: Leer la primera lnea y obtener los nombres de los campos,
 *           sus tipos y longitudes
 * ENTRADAS: El fichero, una cadena donde leer la cabecera y el tipo
 *           de conversin
 * SALIDAS:  El nmero total de campos.
 *           Si hay algn error, se devuelve 0
 *------------------------------------------------------------------*/
contador ExaminaCabecera (Fichero, Cabecera, Tipo)
fichero Fichero;
cadena  Cabecera;
octeto  Tipo;
  {
  contador Respuesta=0, j;
  entero   i;
  logico   LeyendoNombre = SI;
  cadena   NombreTemp, Aux;

  Fch_Coloca (Fichero, 0);
  Fch_LeeOcteto (Fichero, (memoria)Cabecera, LongRegistro);
  if ( Tipo == CONV_EXP_PC )
    {
    for ( j=0 ; j<LongRegistro ; j++ )
      { Cabecera[j] = Car_ConvierteQLaPC (Cabecera[j]); }
    }
  Cabecera = Cad_Mayus (Cabecera);
  NombreTemp = Cad_Crea (LongRegistro);

  Inicio[0] = j = 0;
  for ( i=0 ; i<=LongRegistro ; i++ )
    {
    if ( LeyendoNombre )
      {
      if ( Cabecera[i] == ' ' )
        {
        NombreTemp[j] = NULO;
        if ( Cad_CarPertenece (NombreTemp, '$') )
          {
          Cad_Cambia (NombreTemp, '$', NULO);
          TipoCampo [Respuesta] = 'C';
          }
        else
          { TipoCampo [Respuesta] = 'N'; }
        Aux = Cad_Trozo (NombreTemp, 1,
			 Min (Cad_Longitud(NombreTemp), MAX_NOMBRE));
        Cad_Copia (NombreCampo[Respuesta], Aux);
        Cad_Destruye (Aux);
        LeyendoNombre = NO;
        }
      else
        { NombreTemp[j++] = Cabecera[i]; }
      } /* Fin if LeyendoNombre */
    else
      {
      if ( Cabecera[i] != ' ' )
        {
	LongCampoExp[Respuesta] = i-Inicio[Respuesta]-1;
        j = 0;
        NombreTemp[j++] = Cabecera[i];
        Respuesta++;
        Inicio[Respuesta] = i;
        LeyendoNombre = SI;
        }
      } /* Fin if !LeyendoNombre */
    } /* Fin for i */

  Cad_Destruye (NombreTemp);
  return ( Respuesta );
  }

/*--------------------------------------------------------------------
 * FUNCION:  CalculaTotalRegistro()
 * OBJETIVO: Calcular cuntos registros hay en el fichero
 * ENTRADAS: El fichero
 * SALIDAS:  El nmero de registros
 *------------------------------------------------------------------*/
entero CalculaTotalRegistro (Fichero)
fichero Fichero;
  {
  entero Respuesta=0;

  Fch_ColocaFinal (Fichero);
  Respuesta = Fch_Posicion (Fichero);
  Respuesta /= LongRegistro;

  return ( Respuesta-1 );
  }

/*--------------------------------------------------------------------
 * FUNCION:  HayAlgunCampoNumerico()
 * OBJETIVO: Decir si hay algn campo numrico en el fichero exp
 * ENTRADAS: Ninguna, se usan variables globales
 * SALIDAS:  Lgica
 *------------------------------------------------------------------*/
logico HayAlgunCampoNumerico()
  {
  logico   Respuesta=NO;
  contador i;

  for ( i=0 ; i<=TotalCampo && !Respuesta ; i++ )
    {
    if ( TipoCampo[i] == 'N' )
      { Respuesta = SI; }
    }

  return ( Respuesta );
  }

/*--------------------------------------------------------------------
 * FUNCION:  ExaminaCamposNumericos()
 * OBJETIVO: Calcular la longitud de la parte entera y la parte decimal
 *           de cada campo numrico
 * ENTRADAS: El fichero y una cadena donde leer cada linea
 * SALIDAS:  Cambian las variables globales
 *------------------------------------------------------------------*/
void ExaminaCamposNumericos (Fichero, Linea)
fichero Fichero;
cadena  Linea;
  {
  entero   Registro, i;
  contador Campo, LongDec, LongEnt, j;
  logico   LeyendoEntera;

  Fch_Coloca (Fichero, LongRegistro);
  for ( Registro = 0 ; Registro < TotalRegistro ; Registro++ )
    {
    Fch_LeeOcteto (Fichero, Linea, LongRegistro);
    for ( Campo = 0 ; Campo < TotalCampo ; Campo++ )
      {
      if ( TipoCampo[Campo] == 'N' )
        {
        LeyendoEntera = SI;
        LongDec = LongEnt = 0;
        for ( i=Inicio[Campo] , j=0 ; j<LongCampoExp[Campo] ; i++ , j++ )
          {
          if ( Linea[i] == '.' )  { LeyendoEntera = NO; }
          else if ( Linea[i] != ' ' )
            {
            if ( LeyendoEntera )  { LongEnt++; }
            else                  { LongDec++; }
            }
          }
        LongEntera[Campo] = Max (LongEntera[Campo], LongEnt);
        LongDecimal[Campo] = Max (LongDecimal[Campo], LongDec);
        }  /* Fin if Campo es numrico */
      }  /* Fin for Campo */
    }  /* Fin for Registro */
  }

/*--------------------------------------------------------------------
 * FUNCION:  ExplicaEstructura()
 * OBJETIVO: Mostrar al usuario la estructura que se va a dar a la
 *           base de datos
 * ENTRADAS: Ninguna
 * SALIDAS:  Ninguna
 *------------------------------------------------------------------*/
void ExplicaEstructura()
  {
  contador i;
  region   Info;

  Info = Reg_Crea (4,41,21,79);
  Reg_Borde (Info, CDR_DOBLE, NEGRO, VERDE);
  Reg_Tinta (Info, VERDE);
  Reg_PonTexto (Info,1,2,"Campo");
  Reg_PonTexto (Info,1,14,"Tipo");
  Reg_PonTexto (Info,1,20,"Long");
  Reg_PonTexto (Info,1,26,"Decs");

  Reg_Tinta (Info, BLANCO);
  for ( i=0 ; i<TotalCampo && i<12 ; i++ )
    {
    Reg_PonTexto  (Info,3+i, 2,NombreCampo[i]);
    Reg_PonCar    (Info,3+i,16,TipoCampo[i]);
    Reg_PonEntero (Info,3+i,20,LongCampo[i],3);
    Reg_PonEntero (Info,3+i,28,LongDecimal[i],1);
    }

  if ( i<TotalCampo )
    {
    Reg_Color (Info, BLANCO, ROJO);
    Reg_PonTexto (Info, Reg_FilInf(Info)-1, 2, " Hay ms campos ");
    }

  Reg_Destruye (Info);
  }

/*--------------------------------------------------------------------
 * FUNCION:  CreaBase()
 * OBJETIVO: Crear la base de datos destino
 * ENTRADAS: El nombre de la base y el tipo de conversin
 * SALIDAS:  La base de datos
 *------------------------------------------------------------------*/
basedato CreaBase (Destino, Tipo)
cadena Destino;
octeto Tipo;
  {
  cadena   Nombres[MAX_CAMPO+1];
  contador i, j;

  for ( i=0 ; i<TotalCampo ; i++ )
    {
    if ( Tipo == CONV_EXP_PC )
      {
      for ( j=0 ; NombreCampo[i][j] ; j++ )
        { NombreCampo[i][j] = Car_ConvierteQLaPC (NombreCampo[i][j]); }
      }
    Nombres[i] = NombreCampo[i];
    }
  Nombres[i] = NIL;

  return ( Bdt_Crea (Destino, Nombres, TipoCampo, LongCampo, LongDecimal) );
  }

/*--------------------------------------------------------------------
 * FUNCION:  EscribeRegistros()
 * OBJETIVO: Ir leyendo los registros del fichero exp y escribindolos
 *           en la base de datos
 * ENTRADAS: El fichero, la base de datos, el tipo de conversin y
 *           una cadena auxiliar para leer los registros
 * SALIDAS:  Ninguna
 *------------------------------------------------------------------*/
void EscribeRegistros (Fichero, Base, Tipo, Linea)
fichero  Fichero;
basedato Base;
octeto   Tipo;
cadena   Linea;
  {
  entero   Registro, i, Numero;
  contador Campo, j;
  cadena   Aux;
  real     Valor;

  Aux = Cad_Crea (LongRegistro);
  Fch_Coloca (Fichero, LongRegistro);

  for ( Registro = 0 ; Registro < TotalRegistro ; Registro++ )
    {
    Fch_LeeOcteto (Fichero, Linea, LongRegistro);
    Bdt_LimpiaRegistro (Base);
    for ( Campo = 0 ; Campo < TotalCampo ; Campo++ )
      {
      if ( TipoCampo[Campo] == 'C' )
        {
        for ( i=Inicio[Campo] , j=0 ; j<LongCampoExp[Campo] ; i++ , j++ )
          { Aux[j] = Linea[i]; }
        Aux[j] = NULO;
        if ( Tipo == CONV_EXP_PC )  { Aux = Cad_ConvierteQLaPC (Aux); }
        }
      else
        {
        sscanf (Linea+Inicio[Campo], "%f", &Valor);
        sprintf (Aux, "%*.*f", LongCampo[Campo], LongDecimal[Campo], Valor);
        }
      Bdt_PonCampoNumero (Base, Campo, Aux);
      }  /* Fin for Campo */
    Bdt_AgregaRegistro (Base, &Numero);
    }  /* Fin for Registro */

  Cad_Destruye (Aux);
  }