/*--------------------------------------------------------------------
 * FICHERO:  Convjueg.c
 * OBJETIVO: Definir la funcin ConvierteJuego()
 * AUTOR:    Pedro Reina
 * FECHA:    L.8.4.1996
 *------------------------------------------------------------------*/

/*--------------------------------------------------------------------
 * Ficheros de cabecera
 *------------------------------------------------------------------*/

#include "Convdb.h"

/*--------------------------------------------------------------------
 * Declaracin de funciones
 *------------------------------------------------------------------*/

static void EscribeRegistros();

/*--------------------------------------------------------------------
 * Definicin de macros constantes
 *------------------------------------------------------------------*/

 /*  Ninguno  */

/*--------------------------------------------------------------------
 * Variables globales
 *------------------------------------------------------------------*/

 /*  Ninguna  */
                
/*--------------------------------------------------------------------
 * Definicin de macros funciones
 *------------------------------------------------------------------*/

 /*  Ninguno  */
            
/*--------------------------------------------------------------------
 * Definicin de funciones
 *------------------------------------------------------------------*/

/*--------------------------------------------------------------------
 * FUNCION:  ConvierteJuego()
 * OBJETIVO: Convertir una base de datos dBase en otra que use otro
 *           juego de caracteres
 * ENTRADAS: Una regin donde informar del desarrollo de proceso,
 *           el nombre de las bases origen y el destino y el tipo
 *           de conversin
 * SALIDAS:  Ninguna
 *------------------------------------------------------------------*/
void ConvierteJuego (Info, Origen, Destino, TipoConv)
region Info;
cadena Origen, Destino;
octeto TipoConv;
  {
  basedato  BaseOrigen, BaseDestino;
  contador  Campo, TotalCampo;
  cadena   *Nombre;
  caracter *Tipo;
  contador *Longitud, *Decimal;

  if ( BaseOrigen = Bdt_Abre (Origen, BDT_LECTURA) )
    {
    Usr_Informa ("Examinando la base de datos origen");
    Reg_PonTexto (Info, 12, 2, "Nmero de registros: ");
    Pan_Tinta (BLANCO);
    Pan_Entero (Bdt_TotalRegistro(BaseOrigen),1);
    TotalCampo = Bdt_TotalCampo(BaseOrigen);

    Nombre = (cadena *) Mem_Crea ((TotalCampo+1)*sizeof(cadena));
    Tipo = (caracter *) Mem_Crea (TotalCampo*sizeof(caracter));
    Longitud = (contador *) Mem_Crea (TotalCampo*sizeof(contador));
    Decimal = (contador *) Mem_Crea (TotalCampo*sizeof(contador));

    for ( Campo=0 ; Campo<TotalCampo ; Campo++ )
      {
      Nombre[Campo] = Cad_Crea (MAX_NOMBRE);
      Bdt_NombreDeCampo (BaseOrigen, Campo, Nombre[Campo]);
      Tipo[Campo] = Bdt_TipoDeCampo (BaseOrigen, Campo);
      Longitud[Campo] = Bdt_LongitudDeCampo (BaseOrigen, Campo);
      Decimal[Campo] = Bdt_DecimalDeCampo (BaseOrigen, Campo);
      }
    Nombre[TotalCampo] = NIL;

    if ( BaseDestino = Bdt_Crea (Destino,Nombre,Tipo,Longitud,Decimal) )
      {
      Usr_Informa ("Creando nueva base de datos");
      EscribeRegistros (BaseOrigen, BaseDestino, TipoConv);
      Bdt_Cierra (BaseDestino);
      Usr_PulsaUnaTecla ("Base de datos creada");
      }

    for ( Campo=0 ; Campo<TotalCampo ; Campo++ )
      { Cad_Destruye (Nombre[Campo]); }

    Mem_Destruye (Nombre);
    Mem_Destruye (Tipo);
    Mem_Destruye (Longitud);
    Mem_Destruye (Decimal);
    Bdt_Cierra (BaseOrigen);
    }
  }

/*--------------------------------------------------------------------
 * FUNCION:  EscribeRegistros()
 * OBJETIVO: Ir leyendo los registros de la base de datos origen y
 *           escribindolos en la base de datos destino
 * ENTRADAS: Las bases de datos y el tipo de conversin
 * SALIDAS:  Ninguna
 *------------------------------------------------------------------*/
static void EscribeRegistros (Origen, Destino, Tipo)
basedato Origen, Destino;
octeto   Tipo;
  {
  entero   TotalRegistro, MaxRegistro, Registro, i, Numero;
  contador TotalCampo, Campo, j;
  cadena   Aux;

  TotalCampo = Bdt_TotalCampo (Origen);
  TotalRegistro = Bdt_TotalRegistro (Origen);

  MaxRegistro = 0;
  for ( Campo = 0 ; Campo < TotalCampo ; Campo++ )
    { MaxRegistro = Max (MaxRegistro, Bdt_LongitudDeCampo (Origen, Campo)); }
  MaxRegistro;

  Aux = Cad_Crea (MaxRegistro);

  for ( Registro = 0 ; Registro < TotalRegistro ; Registro++ )
    {
    Bdt_LeeRegistro (Origen, Registro);
    Bdt_LimpiaRegistro (Destino);
    for ( Campo = 0 ; Campo < TotalCampo ; Campo++ )
      {
      Bdt_CampoNumero (Origen, Campo, Aux);
      if ( Bdt_TipoDeCampo(Origen, Campo) == 'C' )
        {
        if ( Tipo == CONV_QL_PC )  { Aux = Cad_ConvierteQLaPC (Aux); }
        else                       { Aux = Cad_ConviertePCaQL (Aux); }
        }
      Bdt_PonCampoNumero (Destino, Campo, Aux);
      }
    Bdt_AgregaRegistro (Destino, &Numero);
    }

  Cad_Destruye (Aux);
  }
