/*--------------------------------------------------------------------
 * FICHERO:       Calculad.h
 * OBJETIVO:      Definir el objeto "Calculadora"
 * IDENTIFICADOR: Cal
 * AUTOR:         Pedro Reina
 * FECHA:         D.29.3.1998
 *------------------------------------------------------------------*/

/*--------------------------------------------------------------------
 * Funciones pblicas
 *
 *   Cal_Aplica()            Calculad.c
 *   Cal_Crea()              Calculad.c
 *   Cal_Destruye()          Calculad.c
 *   Cal_Duplica()           Calculad.h
 *   Cal_Ejecuta()           Calculad.c
 *   Cal_Elemento()          Calculad.h
 *   Cal_Inserta()           Calculad.c
 *   Cal_Intercambia()       Calculad.c
 *   Cal_Opera()             Calculad.c
 *   Cal_Resultado()         Calculad.h
 *-----------------------------------------------------------------*/

/*--------------------------------------------------------------------
 * Funciones conocidas
 *
 *   Ninguna
 *------------------------------------------------------------------*/

/*--------------------------------------------------------------------
 * Funciones privadas
 *
 *   Cal_Pila()              Calculad.h
 *   Cal_PonElemento()       Calculad.h
 *   Cal_PonPila()           Calculad.h
 *   Cal_PonProfundidad()    Calculad.h
 *   Cal_Profundidad()       Calculad.h
 *------------------------------------------------------------------*/

#ifndef _CALCULADORA_
#define _CALCULADORA_

/*--------------------------------------------------------------------
 * Ficheros de cabecera
 *------------------------------------------------------------------*/

#include <Olimpo.h>  /* Versin 2.0 */

/*--------------------------------------------------------------------
 * Definicin de macros constantes
 *------------------------------------------------------------------*/

/* Cdigos de tipo de orden para los programas */

#define CAL_FIN_PROGRAMA (octeto)0
#define CAL_OPERACION    (octeto)1
#define CAL_FUNCION      (octeto)2
#define CAL_NUMERO_POS   (octeto)3
#define CAL_NUMERO_NEG   (octeto)4
#define CAL_INTERCAMBIA  (octeto)5
#define CAL_DUPLICA      (octeto)6

/* Cdigos de las operaciones */

#define CAL_SUMA        (octeto)1
#define CAL_DIFERENCIA  (octeto)2
#define CAL_PRODUCTO    (octeto)3
#define CAL_COCIENTE    (octeto)4
#define CAL_ALEATORIO   (octeto)5

/* Cdigos de las funciones */

#define CAL_CUADRADO    (octeto)1
#define CAL_CUBO        (octeto)2

/*--------------------------------------------------------------------
 * Definicin del tipo "calculad"
 *------------------------------------------------------------------*/
typedef struct {
               octeto  Profundidad;
               entero *Pila;
               } Cal_st, *calculad;

/*--------------------------------------------------------------------
 * Variables globales
 *------------------------------------------------------------------*/

   /* Ninguna */

/*--------------------------------------------------------------------
 * Declaracin de funciones
 *------------------------------------------------------------------*/

calculad Cal_Crea();
void     Cal_Destruye();
entero   Cal_Inserta();
entero   Cal_Opera();
entero   Cal_Aplica();
entero   Cal_Intercambia();
entero   Cal_Ejecuta();

/*--------------------------------------------------------------------
 * Definicin de macros funciones
 *------------------------------------------------------------------*/

/*--------------------------------------------------------------------
 * MACRO:    Cal_Profundidad()
 * OBJETIVO: Decir la profundidad de la pila de una calculad
 * ENTRADAS: La calculad
 * SALIDAS:  La profundidad de la pila
 * EJEMPLO:  Cal_Profundidad ( Calculadora )
 *------------------------------------------------------------------*/
#define Cal_Profundidad(c)  ((c)->Profundidad)

/*--------------------------------------------------------------------
 * MACRO:    Cal_PonProfundidad()
 * OBJETIVO: Poner la profundidad de la pila de una calculad
 * ENTRADAS: La calculad y la profundidad de la pila
 * SALIDAS:  La profundidad de la pila
 * EJEMPLO:  Cal_PonProfundidad ( Calculadora, 8 )
 *------------------------------------------------------------------*/
#define Cal_PonProfundidad(c,p)  ((c)->Profundidad=(p))

/*--------------------------------------------------------------------
 * MACRO:    Cal_Pila()
 * OBJETIVO: Decir la direccin de la pila de una calculad
 * ENTRADAS: La calculad
 * SALIDAS:  La direccin de la pila
 * EJEMPLO:  Cal_Pila ( Calculadora )
 *------------------------------------------------------------------*/
#define Cal_Pila(c)  ((c)->Pila)

/*--------------------------------------------------------------------
 * MACRO:    Cal_PonPila()
 * OBJETIVO: Poner la direccin de la pila de una calculad
 * ENTRADAS: La calculad y la direccin de la pila
 * SALIDAS:  La direccin de la pila
 * EJEMPLO:  Cal_PonPila ( Calculadora, Memoria )
 *------------------------------------------------------------------*/
#define Cal_PonPila(c,p)  ((c)->Pila=(p))

/*--------------------------------------------------------------------
 * MACRO:    Cal_Elemento()
 * OBJETIVO: Decir el valor de un elemento de la pila
 * ENTRADAS: La calculad y el orden del elemento
 * SALIDAS:  El valor del elemento
 * EJEMPLO:  Cal_Elemento ( Calculadora, 2 )
 * NOTA:     No se comprueba que el elemento exista
 *------------------------------------------------------------------*/
#define Cal_Elemento(c,e)  (((c)->Pila)[e])

/*--------------------------------------------------------------------
 * MACRO:    Cal_PonElemento()
 * OBJETIVO: Poner el valor de un elemento de la pila
 * ENTRADAS: La calculad, el orden del elemento y el valor
 * SALIDAS:  El valor del elemento
 * EJEMPLO:  Cal_PonElemento ( Calculadora, 2, -35 )
 * NOTA:     No se comprueba que el elemento exista
 *------------------------------------------------------------------*/
#define Cal_PonElemento(c,e,v)  (((c)->Pila)[e]=(v))

/*--------------------------------------------------------------------
 * MACRO:    Cal_Resultado()
 * OBJETIVO: Decir el resultado de las operaciones, es decir,
 *           el elemento 0 de la pila
 * ENTRADAS: La calculad
 * SALIDAS:  El valor del elemento 0
 * EJEMPLO:  Cal_Resultado ( Calculadora )
 *------------------------------------------------------------------*/
#define Cal_Resultado(c)  Cal_Elemento(c,0)

/*--------------------------------------------------------------------
 * MACRO:    Cal_Duplica()
 * OBJETIVO: Duplicar el elemento 0 de la pila en la posicin 1
 *           de una calculad
 * ENTRADAS: La calculad
 * SALIDAS:  El valor duplicado
 * EJEMPLO:  Cal_Duplica ( Calculadora )
 * NOTA:     Se pierde el valor ms alto de la pila
 *------------------------------------------------------------------*/
#define Cal_Duplica(c)  Cal_Inserta(c,Cal_Resultado(c))

#endif /* _CALCULADORA_ */
