/*--------------------------------------------------------------------
 * FICHERO:  Contador.c
 * OBJETIVO: Definir las funciones del objeto Contador
 * AUTOR:    Pedro Reina
 * FECHA:    D.8.3.1998
 *------------------------------------------------------------------*/

/*--------------------------------------------------------------------
 * Ficheros de cabecera
 *------------------------------------------------------------------*/

#include "Contador.h"

/*--------------------------------------------------------------------
 * Variables globales
 *------------------------------------------------------------------*/

contador Cnt_Fil=5;  /* Fila superior de la zona asignada     */
contador Cnt_Col=58; /* Columna izquierda de la zona aisgnada */

contador Cnt_Transcurrido; /* Tiempo que lleva la partida, en s */
real     Cnt_Referencia;   /* Ultimo momento en que se mir el reloj */

/*--------------------------------------------------------------------
 * Definicin de funciones
 *------------------------------------------------------------------*/

/*--------------------------------------------------------------------
 * FUNCION:  Cnt_DibujaMarco()
 * OBJETIVO: Dibujar las lneas y mensajes que expresa el contador
 * ENTRADAS: Ninguna
 * SALIDAS:  Ninguna
 *------------------------------------------------------------------*/
void Cnt_DibujaMarco()
  {
  Cdr_Caja (CDR_SIMPLE,Cnt_Fil,Cnt_Col,Cnt_Fil+4,Cnt_Col+19,NEGRO,ROJO);
  Pan_Color (NEGRO,VERDE);
  Pan_PonTexto (Cnt_Fil+1,Cnt_Col+7,"Tiempo");
  }

/*--------------------------------------------------------------------
 * FUNCION:  Cnt_Escribe()
 * OBJETIVO: Escribir en la pantalla el tiempo transcurrido
 * ENTRADAS: Ninguna
 * SALIDAS:  Ninguna
 *------------------------------------------------------------------*/
void Cnt_Escribe()
  {
  contador Minuto, Segundo;

  Pan_Color (NEGRO,BLANCO);
  Pan_CursorVisible (NO);

  Minuto  = (contador) Cnt_Transcurrido / 60;
  Segundo = (contador) Cnt_Transcurrido % 60;

  if ( Minuto >= CNT_MAX )
    {
    Pan_PonTexto (Cnt_Fil+3, Cnt_Col+1, "Ms de ");
    Pan_Entero (CNT_MAX,3);
    Pan_Texto (" minutos");
    }
  else
    {
    Pan_PonEntero (Cnt_Fil+3, Cnt_Col+6, Minuto, 2);
    Pan_Texto (" : ");
    Pan_Entero (Segundo,2);
    }
  }

/*--------------------------------------------------------------------
 * FUNCION:  Cnt_Aumenta()
 * OBJETIVO: Aumentar el contador de tiempo,si es necesario
 * ENTRADAS: Ninguna
 * SALIDAS:  Las variables globales pueden quedar modificadas
 *------------------------------------------------------------------*/
void Cnt_Aumenta()
  {
  contador Diferencia;

  Diferencia = (contador) ( Tim_Crono() - Cnt_Referencia );

  /* Por la definicin de Tim_Crono(), podra ocurrir el siguiente problema:
     Cnt_Referencia se toma justo antes de medianoche y Tim_Crono, justo
     despus. Entonces Diferencia sera negativo y grande, cuando el valor
     real sera muy pequeo. Esto lo arreglo aadiendo el nmero de segundos
     que tiene un da */
  if ( Diferencia < 0 ) { Diferencia = (entero)Diferencia + 86400; }

  if ( Diferencia )
    {
    Cnt_Transcurrido += Diferencia;
    Cnt_Escribe();
    Cnt_Enciende();
    }
  }