/*--------------------------------------------------------------------
 * FICHERO:  Contador.h
 * OBJETIVO: Definir el objeto "Contador" del programa Solitario
 * FECHA:    D.8.3.1998
 * AUTOR:    Pedro Reina
 * IDENTIFICADOR: Cnt
 * FUNCIONES DISPONIBLES:
 *    Cnt_Aumenta()
 *    Cnt_DibujaMarco()
 *    Cnt_Enciende()
 *    Cnt_Escribe()
 *    Cnt_Inicia()
 *------------------------------------------------------------------*/

#ifndef _CONTADOR_
#define _CONTADOR_

/*--------------------------------------------------------------------
 * Ficheros de cabecera
 *------------------------------------------------------------------*/

#include <Olimpo.h>

/*--------------------------------------------------------------------
 * Declaracin de funciones
 *------------------------------------------------------------------*/

void Cnt_Inicia();
void Cnt_DibujaMarco();
void Cnt_Escribe();
void Cnt_Aumenta();

/*--------------------------------------------------------------------
 * Definicin de constantes
 *------------------------------------------------------------------*/

#define CNT_MAX 100  /* Mximo nmero de minutos que se presentan */

/*--------------------------------------------------------------------
 * Variables globales
 *------------------------------------------------------------------*/

extern contador Cnt_Transcurrido;
extern real     Cnt_Referencia;

/*--------------------------------------------------------------------
 * Funciones definidas mediante macros
 *------------------------------------------------------------------*/

/*--------------------------------------------------------------------
 * MACRO:    Cnt_Inicia()
 * OBJETIVO: Poner a cero el contador de tiempo
 * ENTRADAS: Ninguna
 * SALIDAS:  La variable global Cnt_Transcurrido queda modificada
 *------------------------------------------------------------------*/
#define Cnt_Inicia()  (Cnt_Transcurrido=0)

/*--------------------------------------------------------------------
 * MACRO:    Cnt_Enciende()
 * OBJETIVO: Poner en marcha el contador de tiempo
 * ENTRADAS: Ninguna
 * SALIDAS:  La variable global Cnt_Referencia queda modificada
 *------------------------------------------------------------------*/
#define Cnt_Enciende()  (Cnt_Referencia=Tim_Crono())

#endif /* _CONTADOR_ */