/*--------------------------------------------------------------------
 * FICHERO:  Informac.c
 * OBJETIVO: Definir las funciones del objeto Informacin
 * AUTOR:    Pedro Reina
 * FECHA:    D.8.3.1998
 *------------------------------------------------------------------*/

/*--------------------------------------------------------------------
 * Ficheros de cabecera
 *------------------------------------------------------------------*/

#include "Informac.h"

/*--------------------------------------------------------------------
 * Variables globales
 *------------------------------------------------------------------*/

contador Inf_Fil=10;  /* Fila superior de la zona asignada     */
contador Inf_Col=58;  /* Columna izquierda de la zona aisgnada */

contador Inf_Retiradas; /* Piezas ya retiradas             */
contador Inf_Mejor;     /* Mejor puntuacin hasta ahora    */

/*--------------------------------------------------------------------
 * Definicin de funciones
 *------------------------------------------------------------------*/

/*--------------------------------------------------------------------
 * FUNCION:  Inf_DibujaMarco()
 * OBJETIVO: Dibujar las lneas y mensajes que expresan la informacin
 * ENTRADAS: Ninguna
 * SALIDAS:  Ninguna
 *------------------------------------------------------------------*/
void Inf_DibujaMarco()
  {
  Cdr_Caja (CDR_SIMPLE,Inf_Fil,Inf_Col,Inf_Fil+10,Inf_Col+19,NEGRO,ROJO);
  Cdr_Linea (CDR_SIMPLE,Inf_Fil+7,Inf_Col+1,Inf_Fil+7,Inf_Col+18,NEGRO,ROJO);
  Pan_Color (NEGRO,VERDE);
  Pan_PonTexto (Inf_Fil+1,Inf_Col+7,"FICHAS");
  Pan_PonTexto (Inf_Fil+3,Inf_Col+3,"Retiradas:");
  Pan_PonTexto (Inf_Fil+5,Inf_Col+3,"Quedan:");
  Pan_PonTexto (Inf_Fil+9,Inf_Col+3,"Mejor hoy:");
  }

/*--------------------------------------------------------------------
 * FUNCION:  Inf_ActualizaPantalla()
 * OBJETIVO: Escribir en pantalla los valores actuales de la informacin
 * ENTRADAS: Ninguna
 * SALIDAS:  Ninguna
 *------------------------------------------------------------------*/
void Inf_ActualizaPantalla()
  {
  Pan_Color (NEGRO,BLANCO);

  Pan_PonEntero (Inf_Fil+3,Inf_Col+15,Inf_Retiradas,2);
  Pan_PonEntero (Inf_Fil+5,Inf_Col+15,INF_PIEZAS-Inf_Retiradas,2);
  Pan_PonEntero (Inf_Fil+9,Inf_Col+15,Inf_Mejor,2);
  }

/*--------------------------------------------------------------------
 * FUNCION:  Inf_Incrementa()
 * OBJETIVO: Incrementar el nmero de piezas retiradas y poner al da
 *           Inf_Mejor y la pantalla
 * ENTRADAS: Ninguna
 * SALIDAS:  Las variables globales quedan modificadas
 *------------------------------------------------------------------*/
void Inf_Incrementa()
  {
  Inf_Retiradas++;
  Inf_Mejor = Max (Inf_Mejor,Inf_Retiradas);
  Inf_ActualizaPantalla();
  }

/*--------------------------------------------------------------------
 * FUNCION:  Inf_Decrementa()
 * OBJETIVO: Decrementar el nmero de piezas retiradas y poner al da
 *           la pantalla
 * ENTRADAS: Ninguna
 * SALIDAS:  Las variables globales quedan modificadas
 *------------------------------------------------------------------*/
void Inf_Decrementa()
  {
  Inf_Retiradas--;
  Inf_ActualizaPantalla();
  }