/*--------------------------------------------------------------------
 * FICHERO:  Movimien.h
 * OBJETIVO: Definir el objeto "Movimiento" del programa Solitario
 * AUTOR:    Pedro Reina
 * FECHA:    D.8.3.1998
 * IDENTIFICADOR: Mov
 * FUNCIONES DISPONIBLES:
 *    Mov_ActualizaPantalla()
 *    Mov_Almacena()
 *    Mov_Anterior()
 *    Mov_Compacta()
 *    Mov_DibujaMarco()
 *    Mov_EscribeCasilla()
 *    Mov_EscribeMovimiento()
 *    Mov_GrabaPartida()
 *    Mov_IncrementaActual()
 *    Mov_Inicia()
 *    Mov_LeePartida()
 *    Mov_SacaCol()
 *    Mov_SacaFil()
 *    Mov_Siguiente()
 *------------------------------------------------------------------*/

#ifndef _MOVIMIENTO_
#define _MOVIMIENTO_

/*--------------------------------------------------------------------
 * Ficheros de cabecera
 *------------------------------------------------------------------*/

#include <Olimpo.h>

/*--------------------------------------------------------------------
 * Declaracin de funciones
 *------------------------------------------------------------------*/

void Mov_Inicia();
void Mov_DibujaMarco();
void Mov_ActualizaPantalla();
void Mov_Almacena();
void Mov_EscribeMovimiento();
void Mov_EscribeCasilla();
contador Mov_LeePartida();
void Mov_GrabaPartida();
logico Mov_Anterior();
logico Mov_Siguiente();
unsigned char Mov_Compacta();

/*--------------------------------------------------------------------
 * Definicin de constantes
 *------------------------------------------------------------------*/

#define MOV_MAX     32
#define MOV_NINGUNO -1
#define MOV_ERROR   -1

/*--------------------------------------------------------------------
 * Variables globales
 *------------------------------------------------------------------*/

extern contador Mov_Actual;
extern contador Mov_Ultimo;

/*--------------------------------------------------------------------
 * Funciones definidas mediante macros
 *------------------------------------------------------------------*/

/*--------------------------------------------------------------------
 * MACRO:    Mov_IncrementaActual()
 * OBJETIVO: Incrementar el valor de Mov_Actual, arrastrando Mov_Ultimo
 * ENTRADAS: Ninguna
 * SALIDAS:  Las variables quedan modificadas
 *------------------------------------------------------------------*/
#define Mov_IncrementaActual()  (Mov_Ultimo=++Mov_Actual,\
                                 Mov_ActualizaPantalla() )

/*--------------------------------------------------------------------
 * MACRO:    Mov_SacaFil()
 * OBJETIVO: Obtener la fila compactada en un octeto
 * ENTRADAS: El octeto
 * SALIDAS:  La fila
 *------------------------------------------------------------------*/
#define Mov_SacaFil(n)  ((n)>>3)

/*--------------------------------------------------------------------
 * MACRO:    Mov_SacaCol()
 * OBJETIVO: Obtener la columna compactada en un octeto
 * ENTRADAS: El octeto
 * SALIDAS:  La columna
 *------------------------------------------------------------------*/
#define Mov_SacaCol(n)  ((n)&7)

#endif /* _MOVIMIENTO_ */