/*--------------------------------------------------------------------
 * FICHERO:  Tablero.c
 * OBJETIVO: Definir las funciones del objeto Tablero
 * AUTOR:    Pedro Reina
 * FECHA:    D.8.3.1998
 *------------------------------------------------------------------*/

/*--------------------------------------------------------------------
 * Ficheros de cabecera
 *------------------------------------------------------------------*/

#include "Tablero.h"

/*--------------------------------------------------------------------
 * Variables globales
 *------------------------------------------------------------------*/

contador Tab_Fil=5;   /* Fila superior de la zona asignada     */
contador Tab_Col=23;  /* Columna izquierda de la zona aisgnada */
logico   Tab_Cuadro[TAB_DIM][TAB_DIM]; /* Las casillas del tablero */

/*--------------------------------------------------------------------
 * Definicin de funciones
 *------------------------------------------------------------------*/

/*--------------------------------------------------------------------
 * FUNCION:  Tab_Inicia()
 * OBJETIVO: Poner todas las celdas llenas
 * ENTRADAS: Ninguna
 * SALIDAS:  El tablero queda modificado
 *------------------------------------------------------------------*/
void Tab_Inicia()
  {
  contador i,j;

  for ( i=0 ; i<TAB_DIM ; i++ ) {
  for ( j=0 ; j<TAB_DIM ; j++ ) {
  if ( Tab_PosVale (i,j) ) {
    Tab_PonCelda (i,j,TAB_PIEZA);
    }}}
  }

/*--------------------------------------------------------------------
 * FUNCION:  Tab_DibujaMarco()
 * OBJETIVO: Dibujar las lneas y mensajes del tablero
 * ENTRADAS: Ninguna
 * SALIDAS:  Ninguna
 *------------------------------------------------------------------*/
void Tab_DibujaMarco()
  {
  contador i;

  Pan_Color (NEGRO,VERDE);
  Pan_PonTexto (Tab_Fil,Tab_Col+4,"1   2   3   4   5   6   7");
  for ( i=0 ; i<TAB_DIM ; i++ ) { Pan_PonCar (Tab_Fil+2+2*i,Tab_Col,'A'+i); }

  Cdr_Dibuja (CDR_SIMPLE,CDR_SIMPLE,7,1,3,3,Tab_Fil+1,Tab_Col+10,NEGRO,VERDE);
  Cdr_Dibuja (CDR_SIMPLE,CDR_SIMPLE,3,1,7,3,Tab_Fil+5,Tab_Col+2,NEGRO,VERDE);

  #ifdef OLIMPO_PC
  /* Retoque necesario en PC */
  for ( i=0 ; i<4 ; i++ )
    {
    Pan_PonCar (Tab_Fil+5,Tab_Col+10+4*i,197);
    Pan_PonCar (Tab_Fil+11,Tab_Col+10+4*i,197);
    }
  #endif
  }

/*--------------------------------------------------------------------
 * FUNCION:  Tab_DibujaPiezas()
 * OBJETIVO: Dibujar las piezas que haya en ese momento
 * ENTRADAS: Ninguna
 * SALIDAS:  Ninguna
 *------------------------------------------------------------------*/
void Tab_DibujaPiezas()
  {
  contador i,j;

  for ( i=0 ; i<TAB_DIM ; i++ ) {
  for ( j=0 ; j<TAB_DIM ; j++ ) {
  if ( Tab_PosVale (i,j) ) {
    Tab_Dibuja (i,j);
    }}}
  }

/*--------------------------------------------------------------------
 * FUNCION:  Tab_Dibuja()
 * OBJETIVO: Representar el contenido de una celda
 * ENTRADAS: La fila y la columna
 * SALIDAS:  Ninguna
 *------------------------------------------------------------------*/
void Tab_Dibuja (Fil,Col)
contador Fil,Col;
  {
  contador Color;

  if ( Tab_Celda(Fil,Col) == TAB_HUECO ) { Color = NEGRO; }
  else                                   { Color = BLANCO; }

  Tab_Colorea (Fil, Col, Color);
  }

/*--------------------------------------------------------------------
 * FUNCION:  Tab_Colorea()
 * OBJETIVO: Rellenar una celda de un color determinado
 * ENTRADAS: La fila y la columna de la celda y el color
 * SALIDAS:  Ninguna
 *------------------------------------------------------------------*/
void Tab_Colorea (Fil,Col,Color)
contador Fil,Col,Color;
  {
  contador FilReal,ColReal;

  FilReal = Tab_Fil+2+2*Fil;
  ColReal = Tab_Col+3+4*Col;
  Pan_Borra (Color,FilReal,ColReal,FilReal,ColReal+2);
  }

/*--------------------------------------------------------------------
 * FUNCION:  Tab_Marca()
 * OBJETIVO: Poner en una celda el cursor
 * ENTRADAS: La fila y la columna
 * SALIDAS:  Ninguna
 *------------------------------------------------------------------*/
void Tab_Marca (Fil,Col)
contador Fil,Col;
  {
  contador FilReal,ColReal;

  if ( Tab_Celda(Fil,Col) == TAB_HUECO ) { Pan_Color (NEGRO,BLANCO); }
  else                                   { Pan_Color (BLANCO,NEGRO); }

  FilReal = Tab_Fil+2+2*Fil;
  ColReal = Tab_Col+4+4*Col;
  Pan_PonCar (FilReal,ColReal,TAB_CURSOR);
  }

/*--------------------------------------------------------------------
 * FUNCION:  Tab_Mueve()
 * OBJETIVO: Realizar un movimiento en el tablero
 * ENTRADAS: Un vector indicando el movimiento: fila y columna de las
 *           casillas origen y destino
 * SALIDAS:  El tablero queda modificado
 *------------------------------------------------------------------*/
void Tab_Mueve (Movimiento)
contador Movimiento[4];
  {
  contador F1,C1,F2,C2;

  F1 = Movimiento[0];
  C1 = Movimiento[1];
  F2 = Movimiento[2];
  C2 = Movimiento[3];

  Tab_PonCelda (F1,C1,TAB_HUECO);
  Tab_Dibuja (F1,C1);

  if ( F2!=0 || C2!=0 )
    {
    Tab_PonCelda (F2,C2,TAB_PIEZA);
    Tab_PonCelda (Med(F1,F2),Med(C1,C2),TAB_HUECO);

    Tab_Dibuja (F2,C2);
    Tab_Dibuja (Med(F1,F2),Med(C1,C2));
    }
  }

/*--------------------------------------------------------------------
 * FUNCION:  Tab_MueveAtras()
 * OBJETIVO: Anular un movimiento en el tablero
 * ENTRADAS: Un vector indicando el movimiento: fila y columna de las
 *           casillas origen y destino; en este caso el movimiento es
 *           en sentido inverso. El movimiento se deshace.
 * SALIDAS:  El tablero queda modificado
 *------------------------------------------------------------------*/
void Tab_MueveAtras (Movimiento)
contador Movimiento[4];
  {
  contador F1,C1,F2,C2;

  F1 = Movimiento[0];
  C1 = Movimiento[1];
  F2 = Movimiento[2];
  C2 = Movimiento[3];

  Tab_PonCelda (F1,C1,TAB_PIEZA);
  Tab_Dibuja (F1,C1);

  if ( F2!=0 || C2!=0 )
    {
    Tab_PonCelda (F2,C2,TAB_HUECO);
    Tab_PonCelda (Med(F1,F2),Med(C1,C2),TAB_PIEZA);

    Tab_Dibuja (F2,C2);
    Tab_Dibuja (Med(F1,F2),Med(C1,C2));
    }
  }

/*--------------------------------------------------------------------
 * FUNCION:  Tab_HayPosibilidad()
 * OBJETIVO: Decir si es posible realizar algn movimiento ms
 * ENTRADAS: Ninguna
 * SALIDAS:  Lgica
 *------------------------------------------------------------------*/
logico Tab_HayPosibilidad()
  {
  contador i,j;
  logico   VeoUno = NO;

  for ( i=0 ; i<TAB_DIM && !VeoUno ; i++ ) {
  for ( j=0 ; j<TAB_DIM && !VeoUno ; j++ ) {
  if ( Tab_PosVale (i,j) && Tab_Celda(i,j)==TAB_PIEZA ) {
    if ( Tab_AlgunaCaptura (i,j) ) { VeoUno = SI; }
    }}}

  return ( VeoUno );
  }

/*--------------------------------------------------------------------
 * MACRO:    Tab_PuedeCapturar()
 * OBJETIVO: Decir si una pieza puede capturar otra
 * ENTRADAS: La fila y columna de la pieza y del hueco al que ira a
 *           parar si realizara la captura
 * SALIDAS:  Lgica
 * NOTA:     Se asume que existe realmente la pieza
 *------------------------------------------------------------------*/
logico Tab_PuedeCapturar(F1,C1,F2,C2)
contador F1,C1,F2,C2;
  {
  contador Fm, Cm;

  Fm = Med (F1,F2);
  Cm = Med (C1,C2);

  return ( Tab_PosVale (Fm,Cm) && Tab_Celda(Fm,Cm)==TAB_PIEZA &&
           Tab_PosVale (F2,C2) && Tab_Celda(F2,C2)==TAB_HUECO );
  }

/*--------------------------------------------------------------------
 * FUNCION:  Tab_AlgunaCaptura()
 * OBJETIVO: Decir si una pieza puede realizar alguna captura
 * ENTRADAS: La fila y columna de la pieza
 * SALIDAS:  Lgica
 *------------------------------------------------------------------*/
logico Tab_AlgunaCaptura (Fil,Col)
contador Fil, Col;
  {
  contador i,j;
  logico   VeoUno = NO;

  for ( i=-1 ; i<=1 && !VeoUno ; i++ ) {
  for ( j=-1 ; j<=1 && !VeoUno ; j++ ) {
    if ( Tab_PuedeCapturar (Fil,Col,Fil+2*i,Col+2*j) ) { VeoUno = SI; }
    }}

  return ( VeoUno );
  }

/*--------------------------------------------------------------------
 * FUNCION:  Tab_Disimula()
 * OBJETIVO: Dibujar cuadros en las casillas de modo que no se sepa qu
 *           contienen
 * ENTRADAS: Ninguna
 * SALIDAS:  Ninguna
 *------------------------------------------------------------------*/
void Tab_Disimula ()
  {
  contador Color,i,j;

  for ( i=0 ; i<TAB_DIM ; i++ ) {
  for ( j=0 ; j<TAB_DIM ; j++ ) {
  if ( Tab_PosVale (i,j) ) {
    switch ( Azr_Entero(1,4) )
      {
      case 1: Color = BLANCO; break;
      case 2: Color = NEGRO ; break;
      case 3: Color = VERDE ; break;
      case 4: Color = ROJO  ; break;
      }
    Tab_Colorea (i,j,Color);
    }}}
  }