//--------------------------------------------------------------
// Fichero:  banderas.js
// Objetivo: Rutinas JavaScript de Banderas
// Fecha:    S.25.7.2015
// Autor:    Pedro Reina <pedro@pedroreina.net>
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//--------------------------------------------------------------

//---------------------------------
// Constantes
//---------------------------------

// El tamaño de cada celda
var AnchuraCelda = 128;
var AlturaCelda = 101;

//---------------------------------
// Variables globales
//---------------------------------

// Los elementos HTML
var BotonRueda;
var BotonNueva;
var BotonParar;
var BotonEstudiar;
var BotonVolver;
var BotonPrimero;
var BotonAnterior10;
var BotonAnterior;
var BotonSiguiente;
var BotonSiguiente10;
var BotonUltimo;
var CanvasDibujo;
var CanvasIndicador;
var ContextoDibujo;
var ContextoIndicador;
var BarraProgreso;
var BotonInfo;
var BotonHistorial;
var BotonBorrar;
var BotonCreditos;
var BotonLicencia;
var BotonDescarga;
var BotonTecnicas;
var BotonCerrar1;
var BotonCerrar2;
var BotonCerrar3;
var BotonCerrar4;
var BotonCerrar5;
var BotonCerrar6;
var DivInfo;
var DivReloj;
var DivHistorial;
var DivListaHistorial;
var DivCreditos;
var DivLicencia;
var DivDescarga;
var DivTecnicas;
var ImagenInterrogacion;
var ImagenVacia;
var ImagenBien;
var ImagenMal;

// Dimensiones del área de dibujo
var Anchura, Altura;

// Cuántas banderas tenemos en total
var TotalBandera = 198;

// Cuántas banderas forman un problema
var TotalProblema = 40;

// Las banderas
var ImagenBandera = [];

// Lo que ocupan todas las imágenes que precargamos
var TotalTamano;

// La suma de los tamaños de imágenes cargadas hasta el momento
var CargadoActual;

// Cuántas filas y columnas caben en la zona de dibujo
MaxFil = 4;
MaxCol = 5;

// Cuántas celdas tenemos en total
var TotalCeldas = 20;

// Origen de la zona de dibujo
var OrigenX = 5;
var OrigenY = 5;

// Si la partida está en juego o no
var EnJuego;

// El array que contiene la secuencia de símbolos que hay que resolver
var Problema = [];

// Mostraremos al usuario dos tandas de símbolos, la Vista[0] y la Vista[1]
var Vista = [];

// Simpre sabremos a qué tanda corresponde cada símbolo en pantalla
var Tanda = [];

// El índice del símbolo que hay que encontrar en cada momento
var IndiceActual;

// El tiempo que queda para terminar la partida
var TiempoRestante;

// La lista de celdas que han sido incorrectamente pulsadas
var CeldaError = [];

// Temporizadores de los cambios de símbolo y de errores
var TemporizadorCambio = [];
var TemporizadorError = [];

// El manejador del temporizador principal
var Temporizador;

// Para controlar el tiempo
var Antes;
var Ahora;

// El país que estamos mostrando en el estudio
var Pais;

// Los nombres de los países
var NombrePais = [
"Zimbabue", "Afganistán", "Albania", "Argelia", "Samoa Americana",
"Andorra", "Angola", "Antigua y Barbuda", "Argentina",
"Armenia", "Australia", "Austria", "Azerbaiyán", "Las Bahamas",
"Baréin", "Bangladés", "Barbados", "Bielorrusia", "Bélgica",
"Belice", "Benín", "Bután", "Bolivia", "Bosnia Herzegovina", "Botsuana",
"Brasil", "Brunei", "Bulgaria", "Burkina Faso", "Burundi",
"Camboya", "Camerún", "Canadá", "Cabo Verde", "República Centroafricana",
"Chad", "Chile", "China", "Colombia", "Comoras", "Congo", "Congo-Kinshasa",
"Costa Rica", "Croacia", "Cuba", "Chipre", "República Checa", "Dinamarca",
"Yibuti", "República Dominicana", "Timor Oriental", "Ecuador", "Egipto",
"El Salvador", "Guinea Ecuatorial", "Eritrea", "Estonia", "Etiopía",
"Fiyi", "Finlandia", "Francia", "Gabón", "Gambia", "Georgia", "Alemania",
"Ghana", "Grecia", "Granada", "Guatemala", "Guinea-Bissáu", "Guinea-Conakri",
"Guyana", "Haití", "Honduras", "Hong Kong", "Hungría", "Islandia", "India",
"Indonesia", "Irán", "Iraq", "Irlanda", "Israel", "Italia", "Costa de Marfil",
"Jamaica", "Japón", "Jordania", "Kazajistán", "Kenia", "Kiribati",
"Corea del Sur", "Kuwait", "Kirguistán", "Laos", "Letonia", "Líbano",
"Lesoto", "Liberia", "Libia", "Liechtenstein", "Lituania",
"Luxemburgo", "Macao", "Macedonia", "Madagascar", "Malaui",
"Malasia", "Maldivas", "Mali", "Malta", "Islas Marshall",
"Mauritania", "Mauricio", "México", "Moldavia", "Mónaco",
"Mongolia", "Montenegro", "Marruecos", "Mozambique", "Myanmar",
"Namibia", "Nauru", "Nepal", "Países Bajos", "Nueva Zelanda",
"Nicaragua", "Niger", "Nigeria", "Niue", "Corea del Norte",
"Noruega", "Omán", "Pakistán", "Palau", "Palestina",
"Panamá", "Papúa Nueva Guinea", "Paraguay", "Perú", "Filipinas",
"Polonia", "Portugal", "Puerto Rico", "Catar", "Rumanía", "Rusia",
"Ruanda", "San Cristóbal y Nieves", "Santa Lucía",
"San Vicente y las Granadinas", "Samoa", "San Marino",
"Santo Tomé y Príncipe", "Arabia Saudí", "Senegal",
"Serbia", "Seychelles", "Sierra Leona", "Singapur", "Eslovaquia",
"Eslovenia", "Islas Salomón", "Somalia", "Sudáfrica", "España",
"Sri Lanka", "Sudán", "Surinam", "Suazilandia", "Suecia",
"Suiza", "Siria", "Taiwan", "Tayikistán", "Tanzania",
"Tailandia", "Togo", "Tonga", "Trinidad y Tobago",
"Túnez", "Turquía", "Turkmenistán", "Tuvalu", "Uganda",
"Ucrania", "Emiratos Árabes", "Reino Unido", "Estados Unidos",
"Uruguay", "Uzbekistán", "Vanuatu", "Ciudad del Vaticano",
"Venezuela", "Vietnam", "Yemen", "Zambia"
    ];

// La lista de países que ordenaremos alfabéticamente
var ListaOrdenada = [];

//---------------------------------
// Funciones
//---------------------------------

//--------------------------------------------------------------
// Inicio del sistema
function Inicio()
  {
  // Obtenemos el contexto de la zona para dibujar
  ContextoDibujo = CanvasDibujo.getContext("2d");

  // Dimensiones de la zona para dibujar
  Anchura = ContextoDibujo.canvas.clientWidth;
  Altura = ContextoDibujo.canvas.clientHeight;

  // Borramos de gris la zona para dibujar
  ContextoDibujo.fillStyle = "#CCC";
  ContextoDibujo.fillRect (0, 0, Anchura, Altura);

  // Preparamos la zona del reloj
  EscribeReloj ("");

  // Preparamos la zona del indicador
  ContextoIndicador = CanvasIndicador.getContext("2d");
  ContextoIndicador.fillStyle = "#CCC";
  ContextoIndicador.fillRect (0, 0, 650, 50);
  ContextoIndicador.font = "bold 40px texto";
  ContextoIndicador.textAlign = "center";

  // Ordenamos los países
  OrdenaPaises();
  }

//--------------------------------------------------------------
// Prepara la pantalla tras cargar todas las imágenes
function Prepara()
  {
  // Preparamos la barra de progreso
  BarraProgreso.value = 0;
  BarraProgreso.max = TotalProblema;

  // Borramos de blanco la zona para dibujar y el indicador
  ContextoDibujo.fillStyle = "#FFF";
  ContextoDibujo.fillRect (0, 0, Anchura, Altura);
  ContextoIndicador.fillStyle = "#FFF";
  ContextoIndicador.fillRect (0, 0, 650, 50);

  // Ponemos el símbolo vacío
  Rellena (ImagenVacia);
  MuestraIndicador ("Estamos preparados");

  // Cambiamos el estado de los botones
  BotonNueva.style.display = "inline";
  BotonEstudiar.style.display = "inline";
  BotonRueda.style.display = "none";
  }

//--------------------------------------------------------------
// Nueva partida
function Nueva()
  {
  // Cambiamos el estado de los botones
  BotonNueva.style.display = "none";
  BotonEstudiar.style.display = "none";
  BotonParar.style.display = "inline";

  // El array para preparar la secuencia de símbolos
  Problema = [];
  for ( i=0 ; i<TotalBandera ; i++ )
    { Problema.push (i); }

  // Revolvemos aleatoriamente
  Revuelve (Problema);

  // Preparamos las dos tandas de símbolos, que se revuelven independientemente
  Vista[0] = Problema.slice (0, TotalProblema/2);
  Vista[1] = Problema.slice (TotalProblema/2, TotalProblema);
  Revuelve (Vista[0]);
  Revuelve (Vista[1]);

  // Para saber a qué tanda corresponde cada símbolo en pantalla
  Tanda = [];

  // Mostramos la primera vista del problema
  var i=0;
  for ( var Fil=0 ; Fil<MaxFil ; Fil++ )
    {
    for ( var Col=0 ; Col<MaxCol ; Col++, i++ )
      {
      Pinta (Fil, Col, ImagenBandera[Vista[0][i]]);
      Tanda[i] = 0;
      }
    }

  // Nos colocamos en la primera bandera
  IndiceActual = 0;
  MuestraIndicador (NombrePais[Problema[0]]);

  // Damos tres minutos de tiempo
  DivReloj.style.color = '#00C';
  EscribeReloj ("300");
  TiempoRestante = 301;

  // No hay errores cuando comenzamos
  CeldaError = [];

  // Iniciamos las listas de temporizadores
  TemporizadorCambio = [];
  TemporizadorError = [];

  // Empieza la partida
  EnJuego = true;

  // Preparamos los tiempos
  Antes = 0;
  Ahora = Reloj();

  // Preparamos la barra de progreso
  BarraProgreso.value = 0;

  // Activamos el temporizador principal cada 0.2 s
  Temporizador = setInterval (CambiaReloj, 200);
  }

//--------------------------------------------------------------
// Para la partida actual
function Parar()
  {
  // Terminó la partida
  EnJuego = false;

  // Eliminamos los temporizadores
  window.clearInterval (Temporizador);
  for ( var i=0 ; i<TemporizadorCambio.length ; i++ )
    { window.clearInterval (TemporizadorCambio[i]); }
  for ( var i=0 ; i<TemporizadorError.length ; i++ )
    { window.clearInterval (TemporizadorError[i]); }

  // Limpiamos los indicadores
  Rellena (ImagenVacia);
  MuestraIndicador ("Estamos preparados");
  EscribeReloj ("");

  // Cambiamos el estado de los botones
  BotonNueva.style.display = "inline";
  BotonEstudiar.style.display = "inline";
  BotonParar.style.display = "none";
  }

//--------------------------------------------------------------
// Pasa al modo Estudiar
function Estudiar()
  {
  // Cambiamos el estado de los botones
  BotonNueva.style.display = "none";
  BotonEstudiar.style.display = "none";
  BotonPrimero.style.display = "inline";
  BotonAnterior10.style.display = "inline";
  BotonAnterior.style.display = "inline";
  BotonVolver.style.display = "inline";
  BotonSiguiente.style.display = "inline";
  BotonSiguiente10.style.display = "inline";
  BotonUltimo.style.display = "inline";

  // Borramos el reloj
  EscribeReloj ("");

  // Ajustamos la barra de progreso
  BarraProgreso.max = TotalBandera;

  // Elegimos un país al azar para empezar
  Pais = Aleatorio (TotalBandera);

  // Mostramos el pais
  EstudiaPais();
  }

//--------------------------------------------------------------
// Vuelve al modo inicial
function Volver()
  {
  // Cambiamos el estado de los botones
  BotonNueva.style.display = "inline";
  BotonEstudiar.style.display = "inline";
  BotonPrimero.style.display = "none";
  BotonAnterior10.style.display = "none";
  BotonAnterior.style.display = "none";
  BotonVolver.style.display = "none";
  BotonSiguiente.style.display = "none";
  BotonSiguiente10.style.display = "none";
  BotonUltimo.style.display = "none";

  // Ajustamos la barra de progreso
  BarraProgreso.max = TotalProblema;
  BarraProgreso.value = 0;

  // Cambiamos el mensaje al usuario
  MuestraIndicador ("Estamos preparados");

  // Bandera vacía
  ContextoDibujo.fillStyle = "#FFF";
  ContextoDibujo.fillRect (0, 0, Anchura, Altura);
  Rellena (ImagenVacia);
  }

//--------------------------------------------------------------
// Pasa al primer país
function Primero()
  {
  Pais = 0;
  EstudiaPais();
  }

//--------------------------------------------------------------
// Pasa al último país
function Ultimo()
  {
  Pais = TotalBandera-1;
  EstudiaPais();
  }

//--------------------------------------------------------------
// Pasa al país anterior
function Anterior()
  {
  Pais--;
  if ( Pais < 0 )
    { Pais = 0; }
  EstudiaPais();
  }

//--------------------------------------------------------------
// Pasa al país siguiente
function Siguiente()
  {
  Pais++;
  if ( Pais == TotalBandera )
    { Pais = TotalBandera-1; }
  EstudiaPais();
  }

//--------------------------------------------------------------
// Pasa al país 10 posiciones anterior
function Anterior10()
  {
  Pais -= 10;
  if ( Pais < 0 )
    { Pais = 0; }
  EstudiaPais();
  }

//--------------------------------------------------------------
// Pasa al país 10 posiciones siguiente
function Siguiente10()
  {
  Pais += 10;
  if ( Pais >= TotalBandera )
    { Pais = TotalBandera-1; }
  EstudiaPais();
  }

//--------------------------------------------------------------
// Muestra un país para estudiar su bandera
function EstudiaPais()
  {
  // Ajustamos la barra de progreso
  BarraProgreso.value = Pais+1;

  // Mostramos el nombre
  MuestraIndicador (ListaOrdenada[Pais][0]);

  // Mostramos la bandera
  Imagen = ImagenBandera[ListaOrdenada[Pais][1]];
  ContextoDibujo.fillStyle = "#FFF";
  ContextoDibujo.fillRect (0, 0, Anchura, Altura);
  ContextoDibujo.beginPath();
  ContextoDibujo.lineWidth = "6";
  ContextoDibujo.strokeStyle = "green";
  ContextoDibujo.rect (0, 0, Anchura, Altura);
  ContextoDibujo.stroke();
  ContextoDibujo.drawImage (Imagen, 
    (Anchura-AnchuraCelda)/2, (Altura-1.5*AlturaCelda)/2);
  }

//--------------------------------------------------------------
// Indica éxito o fracaso en el reloj
function RelojEstado (Modo)
  {
  // El color del texto con el que vamos a escribir
  var Color = Modo ? '#0D0' : '#D00';
  DivReloj.style.color = Color;

  // Escribimos el tiempo restante
  var Texto = ("00" + TiempoRestante).slice(-3);
  EscribeReloj (Texto);
  }

//--------------------------------------------------------------
// Escribe un texto en el reloj
function EscribeReloj (Texto)
  { DivReloj.innerHTML = Texto; }

//--------------------------------------------------------------
// Pone un texto en el indicador
function MuestraIndicador (Texto)
  {
  ContextoIndicador.fillStyle = "#FFF";
  ContextoIndicador.fillRect (0, 0, 650, 50);
  ContextoIndicador.fillStyle = "#000";
  ContextoIndicador.fillText (Texto, 325, 40);
  }

//--------------------------------------------------------------
// Rellena toda la rejilla con una imagen
function Rellena (Imagen)
  {
  ContextoDibujo.fillStyle = "#FFF";
  ContextoDibujo.fillRect (0, 0, Anchura, Altura);
  for ( var Fil=0 ; Fil<MaxFil ; Fil++ )
    {
    for ( var Col=0 ; Col<MaxCol ; Col++ )
      { Pinta (Fil, Col, Imagen); }
    }
  }

//--------------------------------------------------------------
// Pinta una celda con una imagen
function Pinta (Fil, Col, Imagen)
  {
  ContextoDibujo.fillRect (OrigenX+AnchuraCelda*Col, OrigenY+AlturaCelda*Fil,
                     AnchuraCelda, AlturaCelda);
  ContextoDibujo.drawImage (Imagen, 0, 15, 128, 101,
    OrigenX+AnchuraCelda*Col, OrigenY+AlturaCelda*Fil, 128, 101);
  }

//--------------------------------------------------------------
// Reacciona a una pulsación del ratón en el dibujo
// http://stackoverflow.com/questions/6430249/getting-mouseclick-events-on-a-canvas
function Pulsacion (Evento)
  {
  // Solo atendemos la pulsación del ratón durante una partida
  if ( EnJuego )
    {
    var Elemento = CanvasDibujo;
    var offsetX = 0, offsetY = 0

    // Si el elemento tiene padre
    if ( Elemento.offsetParent )
      {
      // Sumamos su desplazamiento
      do
        {
        offsetX += Elemento.offsetLeft;
        offsetY += Elemento.offsetTop;
        }
      // Y el de sus ancestros
      while ( Elemento = Elemento.offsetParent );
      }

    // Calculamos las coordenadas del punto de contacto
    var x = Evento.pageX - offsetX;
    var y = Evento.pageY - offsetY;

    // Las convertimos a fila y columna
    var Fil = Math.floor ((y-OrigenY)/AlturaCelda);
    var Col = Math.floor ((x-OrigenX)/AnchuraCelda);

    // Procesamos en el juego la pulsación
    if ( Fil>=0 && Fil<MaxFil && Col>=0 && Col<MaxCol )
      { PulsacionCelda (Fil, Col); }
    }
  }

//--------------------------------------------------------------
// Gestiona la pulsación con el ratón en una celda
function PulsacionCelda (Fil, Col)
  {
  // La celda en la que nos han pulsado
  Celda = Fil * MaxCol + Col;

  // Si han acertado
  if ( Problema[IndiceActual] == Vista[Tanda[Celda]][Celda] )
    {
    // Avanzamos al siguiente símbolo
    IndiceActual++;

    // Actualizamos la barra de progreso
    BarraProgreso.value = IndiceActual;

    // Quizá hemos terminado la partida
    if ( IndiceActual == TotalProblema )
      { CierraPartida (true); }

    // Lo normal es tener que seguir adelante
    else
      {
      // Liberamos todos los errores
      for ( var i=0 ; i<TemporizadorError.length ; i++ )
        { window.clearInterval (TemporizadorError[i]); }
      var CeldaTmp, FilTmp, ColTmp, Lugar;
      for ( var i=0 ; i<CeldaError.length ; i++ )
        {
        CeldaTmp = CeldaError[i];
        Lugar = Posicion (CeldaTmp);
        FilTmp = Lugar[0];
        ColTmp = Lugar[1];
        Pinta (FilTmp, ColTmp, ImagenBandera[Vista[Tanda[CeldaTmp]][CeldaTmp]]);
        }
      CeldaError = [];

      // Mostramos el nombre del siguiente país
      MuestraIndicador (NombrePais[Problema[IndiceActual]]);

      // Cambiamos la imagen de la celda
      Pinta (Fil, Col, ImagenBien);

      // Cambiamos la tanda de esa celda
      Tanda[Celda] = 1 - Tanda[Celda];

      // Dentro de un segundo ponemos el nuevo símbolo
      TemporizadorCambio.push (setTimeout (Pinta, 1000, Fil, Col,
        ImagenBandera[Vista[Tanda[Celda]][Celda]]));
      }
    }

  // Si no han acertado
  else
    {
    // Cambiamos la imagen de la celda
    Pinta (Fil, Col, ImagenMal);

    // Anotamos el error
    CeldaError.push (Celda);

    // Penalizamos con tiempo
    Antes -= 1000;

    // Dentro de un segundo ponemos una interrogación
    TemporizadorError.push (
      setTimeout (Pinta, 1000, Fil, Col, ImagenInterrogacion));
    }
  }

//--------------------------------------------------------------
// Cambiar el valor del reloj
function CambiaReloj()
  {
  // Tomamos nota del tiempo actual
  Ahora = Reloj();

  // Vemos cuánto tiempo ha pasado
  var TiempoEntreLlamadas = Ahora - Antes;

  // Si ha pasado un segundo
  if ( TiempoEntreLlamadas > 1000 )
    {
    // Guardamos el tiempo anterior
    Antes = Ahora;

    // Disminuimos el tiempo disponible
    TiempoRestante--;

    // Puede que se nos haya acabado el tiempo
    if ( TiempoRestante == 0 )
      { CierraPartida (false); }

    // Si no, podemos seguir con la partida
    else
      {
      var Texto = ("00" + TiempoRestante).slice(-3);
      EscribeReloj (Texto);
      }
    }
  }

//--------------------------------------------------------------
// Cierra una partida
function CierraPartida (Exito)
  {
  // Eliminamos el temporizador principal
  window.clearInterval (Temporizador);

  // Eliminamos los temporizadores de cambios y errores
  for ( var i=0 ; i<TemporizadorCambio.length ; i++ )
    { window.clearInterval (TemporizadorCambio[i]); }
  for ( var i=0 ; i<TemporizadorError.length ; i++ )
    { window.clearInterval (TemporizadorError[i]); }

  // Acabamos la partida
  EnJuego = false;

  // Los iconos de los símbolos
  var Imagen = Exito ? ImagenBien : ImagenMal;
  Rellena (Imagen);

  // El reloj
  RelojEstado (Exito);

  // El indicador
  var Texto = Exito ? "¡Bien: has ganado!" : "Lo siento, has perdido";
  MuestraIndicador (Texto);

  // Cambiamos el estado de los botones
  BotonNueva.style.display = "inline";
  BotonEstudiar.style.display = "inline";
  BotonParar.style.display = "none";

  // Guardamos la partida en el historial
  GuardaPartida();
  }

//--------------------------------------------------------------
// Guarda los datos de la partida en el ordenador cliente
function GuardaPartida()
  {
  // Solo podremos guardar la partida si el navegador admite Storage
  if ( typeof(Storage) !== "undefined" )
    {
    // Vemos si ya hemos grabado alguna partida
    if ( localStorage.Banderas_Total )
      {
      // Aumentamos el número de partidas almacenadas
      localStorage.Banderas_Total = Number(localStorage.Banderas_Total) + 1;
      }
    else
      {
      // Ponemos a 1 el número de partidas almacenadas
      localStorage.Banderas_Total = 1;
      }

    // Averiguamos la fecha y la hora
    var Momento = new Date();
    var Dia = PonCero (Momento.getDate());
    var Mes = PonCero (Momento.getMonth()+1);
    var Ano = Momento.getFullYear();
    var Hora = PonCero (Momento.getHours());
    var Minuto = PonCero (Momento.getMinutes());
    var Segundo = PonCero (Momento.getSeconds());

    // Añadimos un nuevo registro
    var Clave = 'Banderas_' + localStorage.Banderas_Total;
    var Valor = Ano + '-' + Mes + '-' + Dia + ',' +
                Hora + ':' + Minuto + ':' + Segundo + ',' + TiempoRestante;
    localStorage.setItem (Clave, Valor);
    }
  }

//--------------------------------------------------------------
// Devuelve un array con la fila y la columna que corresponden
// a una celda
function Posicion (Celda)
  {
  var Respuesta = [];
  Fil = Math.floor (Celda/MaxCol);
  Col = Celda % MaxCol;
  Respuesta[0] = Fil;
  Respuesta[1] = Col;
  return (Respuesta);
  }

//--------------------------------------------------------------
// Añade un cero por delante a un número de un solo dígito
function PonCero (Numero)
  {
  if ( Numero < 10 )
    { Numero = '0'+Numero;}
  return Numero;
  }

//--------------------------------------------------------------
// Devuelve un número entero aleatorio entre
// 0 (incluido) y el dado (excluido)
function Aleatorio (Max)
  { return Math.floor(Math.random()*Max); }

//--------------------------------------------------------------
// Revuelve los elementos de un array
// http://bost.ocks.org/mike/shuffle/
function Revuelve (array)
  {
  var m = array.length, t, i;

  // Mientras queden elementos que revolver…
  while (m)
    {
    // Elegimos un elemento de los que quedan…
    i = Math.floor(Math.random() * m--);

    // Y lo intercambiamos con el elemento actual
    t = array[m];
    array[m] = array[i];
    array[i] = t;
    }

  return array;
  }

//--------------------------------------------------------------
// Activa la visión del DIV de Historial
function Historial()
  {
  Cierra();
  DivHistorial.style.display = "block";

  // Preparamos el texto que vamos a mostrar
  var Texto, Clave, Valor, RistraDatos, Fecha, Hora, Puntos;
  if ( localStorage.Banderas_Total )
    {
    // Mostramos los registros en una tabla
    Texto = "<TABLE>\n"
    Texto += "<TR>\n"
    Texto += "<TD>Fecha</TD>\n"
    Texto += "<TD>Hora</TD>\n"
    Texto += "<TD>Puntos</TD>\n"
    Texto += "</TR>\n"
    // Cada registro va en una línea
    for ( var i=Number(localStorage.Banderas_Total) ; i>0 ; i-- )
      {
      Clave = 'Banderas_' + i;
      Valor = localStorage.getItem (Clave);
      RistraDatos = Valor.split (',');
      Fecha = RistraDatos[0];
      Hora = RistraDatos[1];
      Puntos = RistraDatos[2];
      Texto += "<TR>\n";
      Texto += "<TD>" + Fecha + "</TD>\n";
      Texto += "<TD>" + Hora + "</TD>\n";
      Texto += "<TD CLASS=\"centro\">" + Puntos + "</TD>\n";
      Texto += "</TR>\n"
      }
    Texto += "</TABLE>\n"
    }
  else
    { Texto = "No hay ninguna partida en el historial\n"; }

  // Anotamos el texto
  DivListaHistorial.innerHTML = Texto;
  }

//--------------------------------------------------------------
// Borra el historial
function BorraHistorial()
  {
  var Texto;
  Cierra();

  // Si tenemos alguna partida registrada
  if ( localStorage.Banderas_Total )
    {
    // Eliminamos todas las claves de los registros
    for ( var i=Number(localStorage.Banderas_Total) ; i>0 ; i-- )
      {
      Clave = 'Banderas_' + i;
      localStorage.removeItem (Clave);
      }
    // Eliminamos el total de registros
    localStorage.removeItem ("Banderas_Total");

    // Aviso al usuario
    Texto = "Se ha borrado el historial";
    }

  else
    { Texto = "No hay nada que borrar"; }

  // Lanzamos el aviso
  alert (Texto);
  }

//--------------------------------------------------------------
// Activa la visión del DIV de Info
function Info()
  {
  Cierra();
  DivInfo.style.display = "block";
  }

//--------------------------------------------------------------
// Activa la visión del DIV de Créditos
function Creditos()
  {
  Cierra();
  DivCreditos.style.display = "block";
  }

//--------------------------------------------------------------
// Activa la visión del DIV de Licencia
function Licencia()
  {
  Cierra();
  DivLicencia.style.display = "block";
  }

//--------------------------------------------------------------
// Activa la visión del DIV de Descarga
function Descarga()
  {
  Cierra();
  DivDescarga.style.display = "block";
  }

//--------------------------------------------------------------
// Activa la visión del DIV de Técnicas
function Tecnicas()
  {
  Cierra();
  DivTecnicas.style.display = "block";
  }

//--------------------------------------------------------------
// Cierra todos los DIV de explicaciones
function Cierra()
  {
  DivInfo.style.display = "none";
  DivHistorial.style.display = "none";
  DivCreditos.style.display = "none";
  DivLicencia.style.display = "none";
  DivDescarga.style.display = "none";
  DivTecnicas.style.display = "none";
  }

//--------------------------------------------------------------
// Devuelve el número de milisegundos desde 1970-01-01
function Reloj()
  { return (new Date()).getTime(); }

//--------------------------------------------------------------
// Precarga una imagen y devuelve su manejador
function PrecargaImagen (Nombre, Tamano)
  {
  // Un nuevo objeto imagen
  var Imagen = new Image();

  // Cuando se cargue lanzamos una notificación
  Imagen.onload = function() { ManejadorCarga (Tamano); };

  // Apuntamos a la URL de la imagen
  Imagen.src = Nombre;

  // Devolvemos el manejador
  return (Imagen);
  }

//--------------------------------------------------------------
// Indica al usuario el transcurso de la carga de imágenes
function ManejadorCarga (Tamano)
  {
  // Añadimos el nuevo tamaño a la cantidad cargada hasta el momento
  CargadoActual += Tamano;

  // Calculamos el porcentaje
  var Porcentaje = Math.floor (100*(CargadoActual/TotalTamano));

  // Lo mostramos en la barra de progreso
  BarraProgreso.value = Porcentaje;

  // Si hemos cargado todas las imágenes
  if ( CargadoActual == TotalTamano )
    // Preparamos la pantalla
    { Prepara(); }
  }

//--------------------------------------------------------------
// Ordena los países alfabéticamente
function OrdenaPaises()
  {
  // Preparamos una lista de pares con los nombres y los índices de los países
  var Par = [];
  for ( var i=0 ; i<TotalBandera ; i++ )
    {
    Par = [];
    Par.push (NombrePais[i]);
    Par.push (i);
    ListaOrdenada.push (Par);
    }

  // La ordenamos
  ListaOrdenada.sort (function(a,b) {return a[0].localeCompare(b[0]);});
  }

//--------------------------------------------------------------
// Función portable que añade un evento
function AgregaEvento (elemento, evType, funcion, useCapture)
  {
  // Manejador de eventos compatible con navegadores IE5+, NS6 y Mozilla
  // Autor: Scott Andrew
  if ( elemento.addEventListener )
    {
    elemento.addEventListener (evType, funcion, useCapture);
    return true;
    }
  else if ( elemento.attachEvent )
    {
    var r = elemento.attachEvent ('on' + evType, funcion);
    return r;
    }
  else
    { elemento ['on' + evType] = funcion; }
  }

//--------------------------------------------------------------
// La función que inicia todo el sistema
function IniciaTodo()
  {
  // Averiguamos los ID de los elementos
  BotonRueda = document.getElementById ('rueda');
  BotonNueva = document.getElementById ('nueva');
  BotonParar = document.getElementById ('parar');
  BotonEstudiar = document.getElementById ('estudiar');
  BotonVolver = document.getElementById ('volver');
  BotonPrimero = document.getElementById ('primero');
  BotonAnterior10 = document.getElementById ('anterior10');
  BotonAnterior = document.getElementById ('anterior');
  BotonSiguiente = document.getElementById ('siguiente');
  BotonSiguiente10 = document.getElementById ('siguiente10');
  BotonUltimo = document.getElementById ('ultimo');
  BotonInfo = document.getElementById ('info');
  BotonHistorial = document.getElementById ('historial');
  BotonBorrar = document.getElementById ('borrar');
  BotonCreditos = document.getElementById ('creditos');
  BotonLicencia = document.getElementById ('licencia');
  BotonDescarga = document.getElementById ('descarga');
  BotonTecnicas = document.getElementById ('tecnicas');
  BotonCerrar1 = document.getElementById ('botoncerrar1');
  BotonCerrar2 = document.getElementById ('botoncerrar2');
  BotonCerrar3 = document.getElementById ('botoncerrar3');
  BotonCerrar4 = document.getElementById ('botoncerrar4');
  BotonCerrar5 = document.getElementById ('botoncerrar5');
  BotonCerrar6 = document.getElementById ('botoncerrar6');
  CanvasDibujo = document.getElementById ('dibujo');
  CanvasIndicador = document.getElementById ('indicador');
  BarraProgreso = document.getElementById ('barra');
  SelectTamano = document.getElementById ('tamano');
  DivReloj = document.getElementById ('divreloj');
  DivInfo = document.getElementById ('divinfo');
  DivHistorial = document.getElementById ('divhistorial');
  DivListaHistorial = document.getElementById ('divlistahistorial');
  DivCreditos = document.getElementById ('divcreditos');
  DivLicencia = document.getElementById ('divlicencia');
  DivDescarga = document.getElementById ('divdescarga');
  DivTecnicas = document.getElementById ('divtecnicas');

  // Vamos presentando algunos controles al usuario
  Inicio();

  // Calculamos cuánto ocupan las imágenes que vamos a precargar
  TotalTamano = TotalBandera + 4;

  // Precargamos las imágenes
  CargadoActual = 0;
  ImagenInterrogacion = PrecargaImagen ('imagen/interrogacion.png', 1);
  ImagenVacia = PrecargaImagen ('imagen/vacia.png', 1);
  ImagenBien = PrecargaImagen ('imagen/bien.png', 1);
  ImagenMal = PrecargaImagen ('imagen/mal.png', 1);
  var Texto;
  for ( var i=0 ; i<TotalBandera ; i++ )
    {
    Texto = ("00" + i).slice(-3);
    ImagenBandera.push (PrecargaImagen ('imagen/bandera'+Texto+'.png', 1));
    }

  // Añadimos todos los "listeners" necesarios
  AgregaEvento (BotonNueva, 'click', Nueva, false);
  AgregaEvento (BotonParar, 'click', Parar, false);
  AgregaEvento (BotonEstudiar, 'click', Estudiar, false);
  AgregaEvento (BotonVolver, 'click', Volver, false);
  AgregaEvento (BotonPrimero, 'click', Primero, false);
  AgregaEvento (BotonAnterior, 'click', Anterior, false);
  AgregaEvento (BotonSiguiente, 'click', Siguiente, false);
  AgregaEvento (BotonAnterior10, 'click', Anterior10, false);
  AgregaEvento (BotonSiguiente10, 'click', Siguiente10, false);
  AgregaEvento (BotonUltimo, 'click', Ultimo, false);
  AgregaEvento (BotonInfo, 'click', Info, false);
  AgregaEvento (BotonHistorial, 'click', Historial, false);
  AgregaEvento (BotonBorrar, 'click', BorraHistorial, false);
  AgregaEvento (CanvasDibujo, 'mousedown', Pulsacion, false);
  AgregaEvento (BotonCreditos, 'click', Creditos, false);
  AgregaEvento (BotonLicencia, 'click', Licencia, false);
  AgregaEvento (BotonDescarga, 'click', Descarga, false);
  AgregaEvento (BotonTecnicas, 'click', Tecnicas, false);
  AgregaEvento (BotonCerrar1, 'click', Cierra, false);
  AgregaEvento (BotonCerrar2, 'click', Cierra, false);
  AgregaEvento (BotonCerrar3, 'click', Cierra, false);
  AgregaEvento (BotonCerrar4, 'click', Cierra, false);
  AgregaEvento (BotonCerrar5, 'click', Cierra, false);
  AgregaEvento (BotonCerrar6, 'click', Cierra, false);
  }

//--------------------------------------------------------------
// La función que inicia el sistema cuando se carga la página
AgregaEvento (window, 'load', IniciaTodo, false);
