<!--
**********************************************************************
* Fichero:  buscapal.php (simplificado para mostrar sólo el código, no
*           he comprobado que funcione correctamente en un servidor real)
* Objetivo: Interfaz PHP del Buscador de palabras
* Autor:    Pedro Reina <pedro@pedroreina.net>
* Fecha:    L.25.1.2016
**********************************************************************
-->

<!--
**********************************************************************
 * Licencia
 *
 * (c) 2016 Pedro Reina
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation, version 2
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307 USA
**********************************************************************
-->

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN"
          "http://www.w3.org/TR/html4/strict.dtd">

<HTML>

<?php EmiteCabecera ('Buscador de palabras', 'UTF-8'); ?>

<!-- Presentación -->

<DIV CLASS="cuadro">

  <DIV CLASS="titulo1">Buscador de palabras, Pedro Reina</DIV>

</DIV>

<!-- Programa PHP -->

<?php

// Programa principal
if ( isset ($_POST['PrimeraVez']) )
  { MuestraRespuesta(); }
else
  { MuestraFormulario(); }
EscribeFinal();
// Fin del programa principal

// ----------------------------

// Rutina para mostrar el formulario
function MuestraFormulario()
  {
  global $PHP_SELF;

  $CodigoHTML=<<<HTML

  <DIV CLASS="cuadro">

    <DIV CLASS="titulo2">Introducción de datos</DIV>

    <DIV CLASS="contenido">

      <FORM ACTION="$PHP_SELF" METHOD="POST">
      <INPUT TYPE="HIDDEN" NAME="PrimeraVez" VALUE="No">
      <TR><TD>
      <TABLE WIDTH="100%" ALIGN="CENTER" CELLPADDING="5">
        <TR ALIGN="CENTER"><TD>
          Letras de partida: <INPUT NAME="Problema" SIZE="9">
          (exactamente 9 letras)
        </TD></TR>
        <TR ALIGN="CENTER"><TD>
          <TABLE ALIGN="CENTER" CELLPADDING="5">
          <TR ALIGN="LEFT">
          <TD VALIGN="CENTER">Palabras<BR>deseadas</TD>
          <TD>
          <LABEL><INPUT TYPE="CHECKBOX" NAME="P9" CHECKED>
          Palabras de 9 letras</LABEL>
          <BR><LABEL><INPUT TYPE="CHECKBOX" NAME="P8" CHECKED>
          Palabras de 8 letras</LABEL>
          <BR><LABEL><INPUT TYPE="CHECKBOX" NAME="P7" CHECKED>
          Palabras de 7 letras</LABEL>
          <BR><LABEL><INPUT TYPE="CHECKBOX" NAME="P6">
          Palabras de 6 letras</LABEL>
          <BR><LABEL><INPUT TYPE="CHECKBOX" NAME="P5">
          Palabras de 5 letras</LABEL>
          </TD></TR></TABLE>
        </TD></TR>
        <TR ALIGN="CENTER"><TD>
          <INPUT TYPE="submit" VALUE=" Buscar ">
          <INPUT TYPE="reset" VALUE=" Borrar ">
        </TD></TR>
      </TD></TR>
      </TABLE>
      </FORM>

    </DIV>

  </DIV>

HTML;
  print $CodigoHTML;
  }

// ----------------------------

// Rutina para mostrar la respuesta
function MuestraRespuesta()
  {
  $Problema = $_POST['Problema'];

  if ( mb_strlen ($Problema, 'UTF-8') != 9 )
    { $Mensaje = 'Error: el número de letras no es 9'; }

  elseif ( !isset($_POST['P9']) AND !isset($_POST['P8']) AND
           !isset($_POST['P7']) AND !isset($_POST['P6']) AND
           !isset($_POST['P5']) )
    { $Mensaje = 'Aviso: no has pedido palabras de ninguna longitud'; }

  else
    {
    $ProblemaOriginal = mb_strtolower ($Problema, 'UTF-8');
    $Problema = mb_ereg_replace ('ñ', '@', $ProblemaOriginal);
    $Respuesta = "";

    if ( isset ($_POST['P9']) )  { $Respuesta .= Busca ($Problema, 9); }
    if ( isset ($_POST['P8']) )  { $Respuesta .= Busca ($Problema, 8); }
    if ( isset ($_POST['P7']) )  { $Respuesta .= Busca ($Problema, 7); }
    if ( isset ($_POST['P6']) )  { $Respuesta .= Busca ($Problema, 6); }
    if ( isset ($_POST['P5']) )  { $Respuesta .= Busca ($Problema, 5); }
    $Mensaje=<<<HTML
    <P>Letras de partida: <B>$ProblemaOriginal</B>
    <P>Palabras obtenidas: $Respuesta
HTML;
    }

  $CodigoHTML=<<<HTML

  <DIV CLASS="cuadro">
    <DIV CLASS="titulo2">Resultado de la búsqueda</DIV>
    <DIV CLASS="contenido">$Mensaje</DIV>
  </DIV>

HTML;
  print $CodigoHTML;
  }

// ----------------------------

// Rutina para buscar palabras en la base de datos
function Busca ($Problema, $Longitud)
  {
  $Respuesta = "<P><B>Palabras de $Longitud letras</B>: ";
  $Orden = "./subconjuntos $Problema $Longitud | sort -u";
  $Clave = explode ("\n", rtrim(`$Orden`));
  $Total = count ($Clave);

  $Condicion = "clave='$Clave[0]'";
  for ( $i=1 ; $i<$Total ; $i++ )
    { $Condicion .= " OR clave='$Clave[$i]'"; }

  $Tabla = "palabra" . $Longitud;
  $Consulta = "SELECT palabra FROM $Tabla WHERE $Condicion";
  $Resultado = ConsultaPalabras($Consulta);

  if ( strlen ($Resultado) == 0 )
    { $Respuesta .= "(no se ha encontrado ninguna de esta longitud)"; }
  else
    { $Respuesta .= $Resultado; }

  return $Respuesta;
  }

// ----------------------------

// Rutina para mostrar vínculos a otras páginas
function EscribeFinal()
  {
  $YoMismo = $_SERVER['PHP_SELF'];

  $OpcionCifLet = array ('Volver a Cifras y Letras', '.');
  $OpcionAndroid = array ('Buscapal para Android', '/desarrollos/buscapal/');

  if ( isset ($_POST['PrimeraVez']) )
    {
    $OpcionOtro = array ('Analizar otro problema', $YoMismo);
    Tedecea_Seguir ($OpcionOtro, $OpcionCifLet, $OpcionAndroid);
    }
  else
    { Tedecea_Seguir ($OpcionCifLet, $OpcionAndroid); }
  }

?>

<!-- Fin de página web -->

</BODY>

</HTML>

<?php

//--------------------------------------------------------------
// Emite la cabecera de la página
function EmiteCabecera ($Titulo, $Codificacion)
  {
  $Icono = "/imagen/prnet.png";
  $Hoja = "/tedecea.css";

  print "<HEAD>\n";
  print "<TITLE>$Titulo</TITLE>\n";
  print "<META HTTP-EQUIV=\"Content-Type\" " .
        "CONTENT=\"text/html; charset=$Codificacion\">\n";
  print "<LINK REL=\"icon\" HREF=\"$Icono\" TYPE=\"image/png\">\n";
  print "<LINK REL=\"StyleSheet\" HREF=\"$Hoja\" TYPE=\"text/css\">\n";
  print "</HEAD>\n";
  }

//-------------------------------------
// Rutina para dar palabras que cumplan una condición
function ConsultaPalabras ($Consulta)
  {
  // El archivo con la base de datos
  $Archivo = 'palabra.db';

  // Consultamos el dato
  $Lista = ConsultaListaTexto ($Archivo, $Consulta);

  // Ordenamos las respuestas por orden alfabético
  setlocale (LC_COLLATE, 'es_ES.UTF-8');
  sort ($Lista, SORT_LOCALE_STRING);

  // Construimos una cadena con las respuestas
  $Respuesta = '';
  foreach ( $Lista as $Palabra )
    { $Respuesta .= " $Palabra"; }

  return ( $Respuesta );
  }

//--------------------------------------------------------------
// Devuelve una lista de cadenas de texto como resultado de una consulta
function ConsultaListaTexto ($Archivo, $Consulta)
  {
  // La lista que responderemos
  $Lista = array();

  // Abrimos una conexión a la base de datos
  $Conexion = Conexion($Archivo);

  // Vamos leyendo cada registro y añadiéndolo a la lista
  foreach ( $Conexion->query ($Consulta) as $Registro )
    { array_push ($Lista, $Registro[0]); }

  // Cerramos la conexión
  $Conexion = null;

  // Devolvemos el resultado
  return $Lista;
  }

//--------------------------------------------------------------
// Devuelve un manejador PDO para conectar con la base de datos
function Conexion($FicheroBaseDato)
  {
  // Abrimos una conexión a la base de datos
  $Conexion = new PDO ("sqlite:$FicheroBaseDato");

  // Devolvemos el manejador
  return $Conexion;
  }

?>
