#!/usr/bin/python
# coding: utf-8

#--------------------------------------------------------------------
# Fichero:  rellenaBD.py
# Objetivo: Rellenar la base de datos de palabras
# Autor:    Pedro Reina <pedro@pedroreina.net>
# Fecha:    D.24.1.2016
#--------------------------------------------------------------------

#--------------------------------------------------------------------
# Licencia
#
# (c) 2016 Pedro Reina y EQ Sistemas Inteligentes
#
# This program is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation, version 2
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with this program; if not, write to the
# Free Software Foundation, Inc.,
# 59 Temple Place, Suite 330,
# Boston, MA 02111-1307 USA
#--------------------------------------------------------------------

#------------------------------------------------
# Constantes
#------------------------------------------------

# Mínimo y máximo número de letras que admitimos en una palabra
Nmin = 5
Nmax = 9

#------------------------------------------------
# Variables
#------------------------------------------------

# El archivo con las palabras, con codificación UTF-8
Archivo = "palabra.txt"

# El archivo con la base de datos
# (es preferible que esté en un disco RAM)
BaseDato = "palabra.db"

#------------------------------------------------
# Módulos necesarios
#------------------------------------------------

# Para leer archivos en UTF-8
import codecs

# Another Python SQLite Wrapper
import apsw

#------------------------------------------------
# Variables globales
#------------------------------------------------

# El diccionario con las listas de palabras con longitudes válidas
ListaPalabra = {}

#------------------------------------------------
# Funciones
#------------------------------------------------

# Lee los datos del archivo de palabras y almacena en
# listas las que tengan longitudes que nos interesan
def LeeDatos():
    Entrada = codecs.open (Archivo, encoding='utf-8', mode='r')
    for Linea in Entrada:
        Palabra = Linea.strip()
        Longitud = len(Palabra)
        if Longitud >= Nmin and Longitud <= Nmax:
            Clave = ConviertePalabra (Palabra)
            Clave = ''.join(sorted(Clave))
            ListaPalabra[Longitud].append((Palabra, Clave))

#------------------------------------------------
# Convierte una palabra UTF8 en ASCII
# según nuestros convenios
def ConviertePalabra (Cadena):
    Resultado = ''
    for Caracter in Cadena:
        if   Caracter == u'á': Resultado += 'a'
        elif Caracter == u'Á': Resultado += 'a'
        elif Caracter == u'é': Resultado += 'e'
        elif Caracter == u'É': Resultado += 'e'
        elif Caracter == u'í': Resultado += 'i'
        elif Caracter == u'Í': Resultado += 'i'
        elif Caracter == u'ó': Resultado += 'o'
        elif Caracter == u'Ó': Resultado += 'o'
        elif Caracter == u'ú': Resultado += 'u'
        elif Caracter == u'Ú': Resultado += 'u'
        elif Caracter == u'ü': Resultado += 'u'
        elif Caracter == u'Ü': Resultado += 'u'
        elif Caracter == u'ñ': Resultado += '@'
        elif Caracter == u'Ñ': Resultado += '@'
        else:                  Resultado += Caracter.lower()
    return Resultado

#------------------------------------------------
# Ordena las listas de palabras según su clave
def OrdenaListas():
    for Longitud in range(Nmin,Nmax+1):
        ListaPalabra[Longitud] = sorted (ListaPalabra[Longitud],
                                          key=lambda Item: Item[1])

#------------------------------------------------
# Rellena las tablas de la base de datos
def Rellena(Conexion):
    Cursor = Conexion.cursor()
    for Longitud in range(Nmin,Nmax+1):
        Tabla = 'palabra' + str(Longitud)
        Consulta = "INSERT INTO " + Tabla + " VALUES (:Clave, :Palabra)"
        for (Palabra, Clave) in ListaPalabra[Longitud]:
            Cursor.execute (Consulta, locals())

#------------------------------------------------
# El programa
#------------------------------------------------

# Informamos al usuario
print 'Archivo de palabras: ' + Archivo
print 'Base de datos: ' + BaseDato
print 'Rellenando...'

# Creamos las listas de palabras de longitudes válidas
for Longitud in range(Nmin,Nmax+1):
    ListaPalabra[Longitud] = []

# Leemos los datos
LeeDatos()

# Ordenamos las listas de palabras según sus claves
OrdenaListas()

# Abrimos conexión a la base de datos
Conexion = apsw.Connection (BaseDato)

# Pasamos los datos a la base de datos
Rellena(Conexion)

# Cerramos la conexión
Conexion.close (True)

# Informamos al usuario
print 'Terminado.'
