;*-------------------------------------------------------------------
;* Fichero:  blancogris.scm
;* Objetivo: Convertir el blanco al gris que forma el plano
;* Autor:    Pedro Reina <pedro@pedroreina.net>
;* Fecha:    X.21.7.2004
;*-------------------------------------------------------------------

;*-------------------------------------------------------------------
;* Definicin de la funcin principal de la funcin
;*-------------------------------------------------------------------

(
  define
    (
    script-fu-blangris ; nombre de la funcin
    Imagen             ; Imagen con la que trabajamos
    Capa               ; La capa de trabajo
    )

    ; Seleccionamos el color 255, hallando la interseccin con
    ; la seleccin que ya est hecha
    (gimp-by-color-select Capa '(255 255 255) 1 3 FALSE 0 0.0 0)

    ; Ponemos "gris plano" como color de fondo
    (gimp-palette-set-background '(191 191 191))

    ; Borramos la zona seleccionada
    (gimp-edit-clear Capa)

    ; Anulamos la seleccin
    (gimp-selection-none Imagen)

    ; Actualizamos la representacin de pantalla
    (gimp-displays-flush)
)

;*-------------------------------------------------------------------
;* Registro de la funcin
;*-------------------------------------------------------------------

(script-fu-register
  "script-fu-blangris"
  "<Image>/Script-Fu/Curso/BlancoGris"
  "Cambia blanco a gris plano"
  "Pedro Reina <pedro@pedroreina.net>"
  "Pedro Reina"
  "X.21.7.2004"
  "RGB* GRAY*"
  SF-IMAGE "Imagen" 0
  SF-DRAWABLE "Capa" 0
)
