;*-------------------------------------------------------------------
;* Fichero:  marcagris.scm
;* Objetivo: Marcar el color que indica descativado
;* Autor:    Pedro Reina <pedro@pedroreina.net>
;* Fecha:    S.14.8.2004
;*-------------------------------------------------------------------

;*-------------------------------------------------------------------
;* Definicin de la funcin principal de la funcin
;*-------------------------------------------------------------------

(
  define
    (
    script-fu-marcagris ; nombre de la funcin
    Imagen              ; Imagen con la que trabajamos
    Capa                ; La capa de trabajo
    )

    ; Seleccionamos el color 130, hallando la interseccin con
    ; la seleccin que ya est hecha
    (gimp-by-color-select Capa '(130 130 130) 1 3 FALSE 0 0.0 0)

    ; Ponemos "negro" como color de fondo
    (gimp-palette-set-background '(0 0 0))

    ; Borramos la zona seleccionada
    (gimp-edit-clear Capa)

    ; Anulamos la seleccin
    (gimp-selection-none Imagen)

    ; Actualizamos la representacin de pantalla
    (gimp-displays-flush)
)

;*-------------------------------------------------------------------
;* Registro de la funcin
;*-------------------------------------------------------------------

(script-fu-register
  "script-fu-marcagris"
  "<Image>/Script-Fu/Curso/MarcaGris"
  "Marca el color de inactivo"
  "Pedro Reina <pedro@pedroreina.net>"
  "Pedro Reina"
  "S.14.8.2004"
  "RGB* GRAY*"
  SF-IMAGE "Imagen" 0
  SF-DRAWABLE "Capa" 0
)
