;*-------------------------------------------------------------------
;* Fichero:  Quita3D.scm
;* Objetivo: Convertir a blanco los colores del efecto 3D
;* Autor:    Pedro Reina <pedro@pedroreina.net>
;* Fecha:    D.16.7.2000
;*-------------------------------------------------------------------

;*-------------------------------------------------------------------
;* Definicin de la funcin principal de la funcin
;*-------------------------------------------------------------------

(
  define
    (
    script-fu-quita3d ; nombre de la funcin
    Imagen            ; Imagen con la que trabajamos
    Capa              ; La capa de trabajo
    )

    ; Guardamos la seleccin
    (set! Canal (car (gimp-selection-save Imagen)))
    ; Debera borrar el canal al terminar, pero no consigo que funcione
    ; As que hay que hacerlo manualmente

    ; Seleccionamos el color 127, hallando la interseccin con
    ; la seleccin que ya est hecha
    (gimp-by-color-select Capa '(127 127 127) 1 3 FALSE 0 0.0 0)

    ; Ponemos "blanco" como color de fondo
    (gimp-palette-set-background '(255 255 255))

    ; Borramos la zona seleccionada
    (gimp-edit-clear Capa)

    ; Recuperamos la seleccin original
    (gimp-selection-load Canal)

    ; Seleccionamos el color 223, hallando la interseccin con
    ; la seleccin que acabamos de recuperar
    (gimp-by-color-select Capa '(223 223 223) 1 3 FALSE 0 0.0 0)

    ; Borramos la zona seleccionada
    (gimp-edit-clear Capa)

    ; Anulamos la seleccin
    (gimp-selection-none Imagen)

    ; Eliminamos el canal creado
    (gimp-channel-delete Canal)
    ; Esto es lo que no funciona, el canal sigue en la lista

    ; Actualizamos la representacin de pantalla
    (gimp-displays-flush)
)

;*-------------------------------------------------------------------
;* Registro de la funcin
;*-------------------------------------------------------------------

(script-fu-register
  "script-fu-quita3d"
  "<Image>/Script-Fu/Curso/Quita3D"
  "Elimina los efectos 3D"
  "Pedro Reina <pedro@pedroreina.net>"
  "Pedro Reina"
  "X.21.7.2004"
  "RGB* GRAY*"
  SF-IMAGE "Imagen" 0
  SF-DRAWABLE "Capa" 0
)
