;*-------------------------------------------------------------------
;* Fichero:  quitafoco.scm
;* Objetivo: Quitar el color que indica foco
;* Autor:    Pedro Reina <pedro@pedroreina.net>
;* Fecha:    V.6.8.2004
;*-------------------------------------------------------------------

;*-------------------------------------------------------------------
;* Definicin de la funcin principal de la funcin
;*-------------------------------------------------------------------

(
  define
    (
    script-fu-quitafoco ; nombre de la funcin
    Imagen              ; Imagen con la que trabajamos
    Capa                ; La capa de trabajo
    )

    ; Seleccionamos el color 58, hallando la interseccin con
    ; la seleccin que ya est hecha
    (gimp-by-color-select Capa '(58 58 58) 1 3 FALSE 0 0.0 0)

    ; Ponemos "gris plano" como color de fondo
    (gimp-palette-set-background '(196 196 196))

    ; Borramos la zona seleccionada
    (gimp-edit-clear Capa)

    ; Anulamos la seleccin
    (gimp-selection-none Imagen)

    ; Actualizamos la representacin de pantalla
    (gimp-displays-flush)
)

;*-------------------------------------------------------------------
;* Registro de la funcin
;*-------------------------------------------------------------------

(script-fu-register
  "script-fu-quitafoco"
  "<Image>/Script-Fu/Curso/QuitaFoco"
  "Elimina el color de foco"
  "Pedro Reina <pedro@pedroreina.net>"
  "Pedro Reina"
  "X.21.7.2004"
  "RGB* GRAY*"
  SF-IMAGE "Imagen" 0
  SF-DRAWABLE "Capa" 0
)
