;*-------------------------------------------------------------------
;* Fichero:  recgris.scm
;* Objetivo: Recortar a la seleccin y convertirla a grises
;* Autor:    Pedro Reina <pedro@pedroreina.net>
;* Fecha:    X.21.7.2004
;*-------------------------------------------------------------------

;*-------------------------------------------------------------------
;* Definicin de la funcin principal de la funcin
;*-------------------------------------------------------------------

(
  define
    (
    script-fu-recgris ; nombre de la funcin
    Imagen            ; Imagen con la que trabajamos
    Capa              ; Es obligatorio, aunque no lo uso
    )

    ; Comienzo de undo
    ;(gimp-undo-push-group-start Imagen) ; no s por qu, pero esto no funciona

    ; Calculamos la seleccin actual
    ; (Gracias a Adrian Likins, de "Selection to Image")
    (set! Seleccion (gimp-selection-bounds Imagen))
    (set! Izquierda (cadr Seleccion))
    (set! Arriba (caddr Seleccion))
    (set! Anchura (- (cadr (cddr Seleccion)) Izquierda))
    (set! Altura (- (caddr (cddr Seleccion)) Arriba))

    ; Nos quedamos con esa seleccin
    (gimp-crop Imagen Anchura Altura Izquierda Arriba)

    ; Convertimos a grises
    (gimp-convert-grayscale Imagen)

    ; Anulamos la seleccin
    (gimp-selection-none Imagen)

    ; Fin de undo
    ;(gimp-undo-push-group-end Imagen) ; no s por qu, pero esto no funciona
)

;*-------------------------------------------------------------------
;* Registro de la funcin
;*-------------------------------------------------------------------

(script-fu-register
  "script-fu-recgris"
  "<Image>/Script-Fu/Curso/RecGris"
  "Recorta a la seleccin y la convierte a grises"
  "Pedro Reina <pedro@pedroreina.net>"
  "Pedro Reina"
  "X.21.7.2004"
  "RGB* GRAY*"
  SF-IMAGE "Imagen" 0
  SF-DRAWABLE "Capa" 0
)
