/*--------------------------------------------------------------------
 * Fichero:  imprimeOOoPS.java
 * Objetivo: Imprimir un archivo OOo en PS
 * Autor:    Pedro Reina <pedro@pedroreina.org>
 * Fecha:    L.5.7.2004
 *------------------------------------------------------------------*/

/*--------------------------------------------------------------------
 *  Referencias
 *
 *  El cdigo principal es de Sun, como se ve en la licencia de ms
 *  abajo. Concretamente, del archivo DocumentPrinter.java que viene
 *  en el SDK de OOo 1.1
 *  http://www.openoffice.org/dev_docs/source/sdk/
 *  (sin embargo, para compilar el programa no es necesario este SDK,
 *  sino solo el de Java, como se ve en el Makefile)
 *
 *  El cdigo para comprobar si la impresin ha terminado es de
 *  http://www.oooforum.org/forum/viewtopic.php?t=4922
 *
 *------------------------------------------------------------------*/

/*************************************************************************
 *
 *  The Contents of this file are made available subject to the terms of
 *  the BSD license.
 *
 *  Copyright (c) 2003 by Sun Microsystems, Inc.
 *  All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *  1. Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *  3. Neither the name of Sun Microsystems, Inc. nor the names of its
 *     contributors may be used to endorse or promote products derived
 *     from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *  FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 *  COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 *  BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 *  OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 *  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
 *  TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 *  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *************************************************************************/

import com.sun.star.bridge.XUnoUrlResolver;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.uno.XComponentContext;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.view.XPrintable;


public class imprimeOOoPS {
  public static void main(String args[]) {
    try {
      String sConnectionString = "uno:socket,host=localhost,port=8100;urp;StarOffice.ServiceManager";

      if ( args.length < 4 ) {
        System.out.println(
        "uso: java -classpath .;<OOoDir>/program/classes/jurt.jar;" +
        "<OOoDir>/program/classes/ridl.jar;" +
        "<OOoDir>/program/classes/sandbox.jar;" +
        "<OOoDir>/program/classes/unoil.jar;" +
        "<OOoDir>/program/classes/juh.jar " +
        "imprimeOOoPs \"<Impresora>\" \"<Archivo OOo>\" " +
        "\"<Archivo PS>\" \"<Invisible>\"" );
        System.out.println( "\nejemplo:" );
        System.out.println(
        "java -classpath .;/opt/openofficeorg/program/classes/jurt.jar;" +
        "/opt/openofficeorg/program/classes/ridl.jar;" +
        "/opt/openofficeorg/program/classes/sandbox.jar;" +
        "/opt/openofficeorg/program/classes/unoil.jar; " +
        "/opt/openofficeorg/program/classes/juh.jar " +
        "imprimeOOoPs \"Generic Printer\" \"archivo.sxw\" \"/tmp/archivo.ps\" 0" );
        System.exit(1);
      }

      // It is possible to use a different connection string, passed as argument
      if ( args.length == 5 ) {
            sConnectionString = args[4];
      }

      /* Bootstraps a component context with the jurt base components
         registered. Component context to be granted to a component for running.
         Arbitrary values can be retrieved from the context. */
      XComponentContext xcomponentcontext =
      com.sun.star.comp.helper.Bootstrap.createInitialComponentContext( null );

      /* Gets the service manager instance to be used (or null). This method has
         been added for convenience, because the service manager is a often used
         object. */
      XMultiComponentFactory xmulticomponentfactory =
      xcomponentcontext.getServiceManager();

      /* Creates an instance of the component UnoUrlResolver which
         supports the services specified by the factory. */
      Object objectUrlResolver =
      xmulticomponentfactory.createInstanceWithContext(
      "com.sun.star.bridge.UnoUrlResolver", xcomponentcontext );

      // Create a new url resolver
      XUnoUrlResolver xurlresolver = ( XUnoUrlResolver )
      UnoRuntime.queryInterface( XUnoUrlResolver.class,
      objectUrlResolver );

      // Resolves an object that is specified as follow:
      // uno:<connection description>;<protocol description>;<initial object name>
      Object objectInitial = xurlresolver.resolve( sConnectionString );

      // Create a service manager from the initial object
      xmulticomponentfactory = ( XMultiComponentFactory )
      UnoRuntime.queryInterface( XMultiComponentFactory.class, objectInitial );

      // Query for the XPropertySet interface.
      XPropertySet xpropertysetMultiComponentFactory = ( XPropertySet )
      UnoRuntime.queryInterface( XPropertySet.class, xmulticomponentfactory );

      // Get the default context from the office server.
      Object objectDefaultContext =
      xpropertysetMultiComponentFactory.getPropertyValue( "DefaultContext" );

      // Query for the interface XComponentContext.
      xcomponentcontext = ( XComponentContext ) UnoRuntime.queryInterface(
      XComponentContext.class, objectDefaultContext );

      /* A desktop environment contains tasks with one or more
         frames in which components can be loaded. Desktop is the
         environment for components which can instanciate within
         frames. */
      XComponentLoader xcomponentloader = ( XComponentLoader )
      UnoRuntime.queryInterface( XComponentLoader.class,
      xmulticomponentfactory.createInstanceWithContext(
      "com.sun.star.frame.Desktop", xcomponentcontext ) );

      java.io.File sourceFile = new java.io.File(args[1]);
      StringBuffer sUrl = new StringBuffer("file:///");
      sUrl.append(sourceFile.getCanonicalPath().replace('\\', '/'));

      // Load a Writer document, displayed or not
      PropertyValue []propertyvalueL = new PropertyValue[ 1 ];
      propertyvalueL[ 0 ] = new PropertyValue();
      propertyvalueL[ 0 ].Name = "Hidden";
      propertyvalueL[ 0 ].Value = Boolean.FALSE;
      if ( args[ 3 ].equals ("1") )
        { propertyvalueL[ 0 ].Value = Boolean.TRUE; }
      XComponent xcomponent = xcomponentloader.loadComponentFromURL(
      sUrl.toString(), "_blank", 0, propertyvalueL);

      // Querying for the interface XPrintable on the loaded document
      XPrintable xprintable =
      ( XPrintable ) UnoRuntime.queryInterface( XPrintable.class, xcomponent );

      // Setting the property "Name" for the favoured printer (name of IP address)
      PropertyValue []propertyvalue = new PropertyValue[ 1 ];
      propertyvalue[ 0 ] = new PropertyValue();
      propertyvalue[ 0 ].Name = "Name";
      propertyvalue[ 0 ].Value = args[ 0 ];

      // Setting the name of the printer
      xprintable.setPrinter( propertyvalue );

      // Setting the property "FileName" to print to a file
      propertyvalue[ 0 ] = new PropertyValue();
      propertyvalue[ 0 ].Name = "FileName";
      propertyvalue[ 0 ].Value = args[ 2 ];

      // Printing the loaded document
      // (Sobreescribe el archivo sin consultar)
      xprintable.print( propertyvalue );

      // Esperamos a que termine la impresin
      boolean ImpresionEnMarcha = true;
      PropertyValue []Estado = new PropertyValue[ 8 ];
      while ( ImpresionEnMarcha )
        {
        Estado = xprintable.getPrinter();
        for (int i=0 ; i<Estado.length ; i++)
          {
          String name=Estado[i].Name;
          Object value=Estado[i].Value;
          if (name.equals("IsBusy"))
            { ImpresionEnMarcha = ( (Boolean) value).booleanValue(); }
          }
        Thread.sleep(100);
        }

      // Cerramos el documento
      xcomponent.dispose();

      System.exit(0);

    }
    catch( Exception exception ) {
      System.err.println( exception );
    }
  }
}
