/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

class LienzoExplicacion
extends Lienzo {
    private String ArchivoExplicacion = "/explicacion.txt";
    private Vector LineasExplicacion;
    private Font FuentePequena = Font.getFont((int)64, (int)0, (int)8);
    private int TotalLinea;
    private int FilasDisponibles;
    private int PrimeraLinea;
    private int MaxPrimeraLinea;
    private int UltimaFila;
    private int AlturaBarra;
    private boolean HayMovimiento;

    public LienzoExplicacion() {
        this.Avance = this.FuentePequena.getHeight();
        String string = this.LeeExplicacion();
        this.LineasExplicacion = this.TroceaCadena(string, this.FuentePequena, this.Anchura - 10);
        this.TotalLinea = this.LineasExplicacion.size() - 1;
        this.FilasDisponibles = this.AlturaUtil / this.Avance;
        if (this.TotalLinea > this.FilasDisponibles) {
            this.HayMovimiento = true;
            this.MaxPrimeraLinea = this.TotalLinea - this.FilasDisponibles;
            this.AlturaBarra = this.AlturaUtil * this.FilasDisponibles / this.TotalLinea;
            this.UltimaFila = this.FilasDisponibles;
        } else {
            this.HayMovimiento = false;
            this.MaxPrimeraLinea = 0;
            this.AlturaBarra = 0;
            this.UltimaFila = this.TotalLinea;
        }
    }

    protected void showNotify() {
        this.PrimeraLinea = 0;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        graphics.setFont(this.FuentePequena);
        for (int i = 0; i < this.UltimaFila; ++i) {
            String string = (String)this.LineasExplicacion.elementAt(i + this.PrimeraLinea);
            graphics.drawString(string, 5, this.AlturaCabecera + i * this.Avance, 0);
        }
        if (this.HayMovimiento) {
            graphics.setColor(200, 0, 0);
            int n = this.AlturaCabecera + 1 + this.PrimeraLinea * this.Avance * this.FilasDisponibles / this.TotalLinea;
            graphics.fillRect(this.Anchura - 3, n, 2, this.AlturaBarra);
        }
    }

    public void keyPressed(int n) {
        if (this.HayMovimiento) {
            int n2 = this.getGameAction(n);
            switch (n2) {
                case 1: {
                    --this.PrimeraLinea;
                    if (this.PrimeraLinea >= 0) break;
                    this.PrimeraLinea = 0;
                    break;
                }
                case 2: {
                    this.PrimeraLinea = 0;
                    break;
                }
                case 6: {
                    ++this.PrimeraLinea;
                    if (this.PrimeraLinea <= this.MaxPrimeraLinea) break;
                    this.PrimeraLinea = this.MaxPrimeraLinea;
                    break;
                }
                case 5: {
                    this.PrimeraLinea = this.MaxPrimeraLinea;
                }
            }
            this.repaint();
            this.serviceRepaints();
        }
    }

    private String LeeExplicacion() {
        String string;
        byte[] byArray = new byte[1024];
        try {
            InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream(this.ArchivoExplicacion);
            int n = inputStream.read(byArray);
            inputStream.close();
            string = new String(byArray, 0, n, "UTF-8");
            string = string.replace('\n', ' ');
            string = string.replace('#', '\n');
        }
        catch (Exception exception) {
            string = "Juego de Pedro Reina\nhttp://pedroreina.net";
        }
        return string;
    }

    private Vector TroceaCadena(String string, Font font, int n) {
        Vector<String> vector = new Vector<String>();
        WordWrap wordWrap = new WordWrap(font, string, n);
        boolean bl = true;
        int n2 = -1;
        int n3 = 0;
        while (bl) {
            String string2;
            n2 = wordWrap.next();
            if (n2 != -1) {
                string2 = string.substring(n3, n2 - 1);
                n3 = n2;
            } else {
                string2 = string.substring(n3);
                bl = false;
            }
            vector.addElement(string2);
        }
        return vector;
    }
}

