//-------------------------------------------------------------------------
// Fichero:  Aleatorio.java
// Objetivo: Implementar la clase Aleatorio
// Fecha:    S.15.9.2007
// Autor:    Pedro Reina <pedro@pedroreina.net>
// Licencia: GPLv3 http://www.gnu.org/licenses/gpl.html
//-------------------------------------------------------------------------

// Paquetes necesarios

import java.lang.*;
import java.util.Random;             // Para generar números aleatorios
import java.util.Vector;             // Para las listas de números

// Clase Aleatorio

class Aleatorio
  {
  // Variables de la clase
  private Random GeneradorAleatorio;
  private int Tope, Posicion;
  private int Lista[];

  // Constructor de la clase
  public Aleatorio (int Valor)
    {
    int i;
    Integer Numero;
    
    // Iniciamos el generador aleatorio
    GeneradorAleatorio = new Random();
    
    // Guardamos el valor tope
    Tope = Valor;
    
    // Creamos la lista de números
    Lista = new int[Tope];

    // La rellenamos con números consecutivos
    for ( i=0 ; i<Tope ; i++ )
      { Lista[i] = i; }
    }

  // Función que devuelve un número entre 0 y Maximo-1
  public int InventaNumero (int Maximo)
    {
    int Respuesta;
    Respuesta = Math.abs(GeneradorAleatorio.nextInt()) % Maximo;
    return Respuesta;
    }
    
  // Función que devuelve un vector de Longitud números entre 0 y Tope-1
  public Vector InventaVector (int Longitud)
    {
    int i;
    Integer Numero;
    Vector Respuesta;
    
    Respuesta = new Vector(Longitud);
    for ( i=0 ; i<Longitud ; i++ )
      {
      // Vamos avanzando por la lista de números.
      // Ahora mismo en una partida no puede ocurrir que
      // el índice se salga de rango, pero si se modifican los datos,
      // podría ocurrir.
      Numero = new Integer (Lista[Posicion++]);
      Respuesta.addElement (Numero);
      }

    return Respuesta;
    }

  // Función que baraja la lista de números
  public void Baraja ()
    {
    int i, Indice, Temporal;

    // Ponemos el puntero al comienzo de la lista
    Posicion = 0;
    
    // Vamos intercambiando cada posición con otra posición
    // elegida aleatoriamente
    for ( i=0 ; i<Tope ; i++ )
      {
      Temporal = Lista[i];
      Indice = InventaNumero (Tope);
      Lista[i] = Lista[Indice];
      Lista[Indice] = Temporal;
      }
    }
    
  }
