//-------------------------------------------------------------------------
// Fichero:  Banderas.java
// Objetivo: Implementar el juego Banderas para móviles con Java
// Fecha:    S.15.9.2007
// Autor:    Pedro Reina <pedro@pedroreina.net>
// Licencia: GPLv3 http://www.gnu.org/licenses/gpl.html
//-------------------------------------------------------------------------

// Paquetes necesarios

import java.lang.*;
import javax.microedition.midlet.*;
import javax.microedition.lcdui.*;
import java.util.Date;               // Para saber cuánto tarda el usuario
import java.util.Vector;             // Para las listas de banderas y nombres
import java.io.InputStream;          // Para leer el archivo con la lista

// Clase Banderas

public class Banderas extends MIDlet implements CommandListener
  {
  // Constantes
  private String ArchivoLista = "/lista.txt";
  private final int MaxTurno = 10;
  private final int PuntosAcierto = 5;

  // Variables necesarias para el GUI
  private Display Pantalla;
  private LienzoAprender Aprender;
  private Menu MenuPrincipal, MenuDificultad, PedirPais;
  private LienzoExplicacion Explicacion;
  private LienzoMostrarBandera MostrarBandera;
  private Info MostrarPuntos;
  private Command Salir, Volver, SeguirPrincipal, SeguirDificultad,
                  SeguirJuego, Anular, Visto;

  // Variables necesarias para el juego
  private Aleatorio Generador;
  private Vector Bandera, Nombre, ListaPaises, ListaNombresPaises;
  private int Turno, Puntos, TotalPaises, Dificultad;
  private int PaisPropuesto, PaisContestado;
  private StringBuffer Resultado;
  private Date CronoComienzo, CronoFinal;

  // Constructor de la clase
  public Banderas()
    {
    Vector OpcionesPrincipal, OpcionesDificultad;

    // Creamos las opciones del menú principal
    OpcionesPrincipal = new Vector (3);
    OpcionesPrincipal.addElement ("Jugar");
    OpcionesPrincipal.addElement ("Aprender");
    OpcionesPrincipal.addElement ("Instrucciones");
    
    // Creamos las opciones del menú de dificultad
    OpcionesDificultad = new Vector (3);
    OpcionesDificultad.addElement ("Baja");
    OpcionesDificultad.addElement ("Media");
    OpcionesDificultad.addElement ("Alta");

    // Creamos los vectores de banderas y de países
    Bandera = new Vector();
    Nombre = new Vector();
    
    // Leemos la lista de banderas y países
    LeeLista();
    
    // Ahora ya sabemos cuántos países tenemos
    TotalPaises = Bandera.size();

    // Preparamos el generador de números aleatorios
    Generador = new Aleatorio (TotalPaises);

    // Obtenemos el objeto Display del midlet.
    Pantalla = Display.getDisplay (this);

    // Creamos las órdenes
    Salir = new Command ("Salir", Command.EXIT, 1);
    Volver = new Command ("Volver", Command.EXIT, 1);
    Anular = new Command ("Anular", Command.EXIT, 1);
    SeguirPrincipal = new Command ("Seguir", Command.OK, 2);
    SeguirDificultad = new Command ("Seguir", Command.OK, 2);
    SeguirJuego = new Command ("Seguir", Command.OK, 2);
    Visto = new Command ("Visto", Command.OK, 2);

    // Creamos los canvas
    Aprender = new LienzoAprender (Bandera, Nombre);
    MenuPrincipal = new Menu (OpcionesPrincipal);
    MenuDificultad = new Menu (OpcionesDificultad);
    Explicacion = new LienzoExplicacion();
    MostrarBandera = new LienzoMostrarBandera (Pantalla, Bandera);
    PedirPais = new Menu();
    MostrarPuntos = new Info();

    // Siempre que mostremos una bandera, la pediremos a continuación
    MostrarBandera.setSiguiente (PedirPais);

    // Añadimos las órdenes e indicamos qué clase las manejará
    Aprender.addCommand (Volver);
    Aprender.setCommandListener (this);
    Explicacion.addCommand (Volver);
    Explicacion.setCommandListener (this);
    MenuPrincipal.addCommand (Salir);
    MenuPrincipal.addCommand (SeguirPrincipal);
    MenuPrincipal.setCommandListener (this);
    MenuDificultad.addCommand (Anular);
    MenuDificultad.addCommand (SeguirDificultad);
    MenuDificultad.setCommandListener (this);
    PedirPais.addCommand (Anular);
    PedirPais.addCommand (SeguirJuego);
    PedirPais.setCommandListener (this);
    MostrarPuntos.addCommand (Visto);
    MostrarPuntos.setCommandListener (this);
    }

  public void startApp() throws MIDletStateChangeException
    {
    // Seleccionamos lo primero que hay que mostrar
    Pantalla.setCurrent (MenuPrincipal);
    }

  public void commandAction (Command Orden, Displayable s) 
    {
    int Elegido;
    
    if ( Orden == Salir )
      {
      destroyApp (false);
      notifyDestroyed();
      }

    if ( Orden == SeguirPrincipal )
      {
      Elegido = MenuPrincipal.getElegido();
      switch ( Elegido )
        {
        case 0: // Jugar
          Pantalla.setCurrent (MenuDificultad);
          break;
        case 1: // Aprender
          Pantalla.setCurrent (Aprender);
          break;
        case 2: // Instrucciones
          Pantalla.setCurrent (Explicacion);
          break;
        }
      }

    if ( Orden == SeguirDificultad )
      {
      // Damos valores iniciales a las variables del juego
      Elegido = MenuDificultad.getElegido();
      switch ( Elegido )
        {
        case 0: Dificultad = 3; break; // Baja
        case 1: Dificultad = 6; break; // Media
        case 2: Dificultad = 9; break; // Alta
        }
      Turno = 0;
      Puntos = 0;
      Resultado = new StringBuffer();
      Generador.Baraja();
      
      // Mostramos y pedimos la primera bandera
      JuegaTurno();
      }

    if ( Orden == Volver )
      { Pantalla.setCurrent (MenuPrincipal); }

    if ( Orden == Anular )
      { Pantalla.setCurrent (MenuPrincipal); }

    if ( Orden == Visto )
      { Pantalla.setCurrent (MenuPrincipal); }
      
    if ( Orden == SeguirJuego )
      {
      int Indice;
      String CadenaPropuesto, CadenaContestado;

      // Terminamos de contar el tiempo que tarda el usuario en contestar
      CronoFinal = new Date();

      // Vemos qué pais ha contestado el usuario
      Indice = PedirPais.getElegido();
      if ( Indice >= 0 )
        { PaisContestado = ((Integer) ListaPaises.elementAt (Indice)).intValue(); }
      else
        { PaisContestado = -1; }
      
      // Según el usuario haya acertado o no
      CadenaPropuesto = (String) Nombre.elementAt (PaisPropuesto);
      if ( PaisContestado >= 0 )
        { CadenaContestado = (String) Nombre.elementAt (PaisContestado); }
      else
        { CadenaContestado = ""; }
      if ( CadenaPropuesto.compareTo (CadenaContestado) == 0 )
        {
        // Esto es un acierto
        Resultado.append ('1');
        Puntos += PuntosAcierto;
        
        // Vemos si tiene puntos extra por contestar en poco tiempo
        long Segundos = (CronoFinal.getTime() - CronoComienzo.getTime()) / 1000;
        Segundos -= 3;
        if ( Segundos < Dificultad )
          {  Puntos += Dificultad - Segundos; }
        }
      else
        {
        // Esto es un fallo
        Resultado.append ('0');
        }

      // Vemos si hay que seguir jugando o no
      Turno++;
      if ( Turno == MaxTurno )
        {
        // Hemos acabado de jugar, hay que mostrar el resultado y los puntos
        MostrarPuntos.setResultado (Resultado);
        MostrarPuntos.setPuntos (Puntos);
        Pantalla.setCurrent (MostrarPuntos);
        }

      else  // Seguimos jugando
        {
        // Lanzamos y pedimos la siguiente bandera
        JuegaTurno();
        }
      }      
    }

  public void pauseApp() {}

  public void destroyApp (boolean incondicional) {}

  // Función que prepara un turno de juego
  public void JuegaTurno()
    {
    int Indice, i;
    String Cadena;
    
    // Generamos una lista aleatoria de paises
    ListaPaises = Generador.InventaVector (Dificultad);
    
    // Elegimos un país de la lista
    Indice = Generador.InventaNumero (Dificultad);
    PaisPropuesto = ((Integer) ListaPaises.elementAt (Indice)).intValue();

    // Rellenamos las opciones que mostraremos al jugador
    ListaNombresPaises = new Vector();
    for ( i=0 ; i<Dificultad ; i++)
      {
      Indice = ((Integer) ListaPaises.elementAt (i)).intValue();
      Cadena = (String) Nombre.elementAt(Indice);
      ListaNombresPaises.addElement (Cadena);
      }    
    PedirPais.setOpcion (ListaNombresPaises);
    PedirPais.borraElegido();

    // Empezamos a contar el tiempo que tarda el usuario en contestar
    CronoComienzo = new Date();
    
    // Mostramos la bandera del país elegido
    MostrarBandera.setNumero (PaisPropuesto);
    Pantalla.setCurrent (MostrarBandera);    
    }

  // Función que lee la lista de banderas y países
  private void LeeLista ()
    {
    byte Bufer[] = new byte[4096];
    InputStream FicheroLista;
    String Cadena, Trozo;
    int Tamano;
    boolean HayQueSeguir;
    int PosicionEspacio, PosicionFinLinea;

    // Primero intentamos leer el archivo de recursos
    try
      {
      // Leemos el archivo en bruto
      FicheroLista = getClass().getResourceAsStream (ArchivoLista);
      Tamano = FicheroLista.read (Bufer);
      FicheroLista.close();

      // El fichero de origen debe estar codificado en UTF-8
      Cadena = new String (Bufer, 0, Tamano, "UTF-8");
      }

    // Si no se puede leer el archivo el error es irrecuperable
    catch (Exception Excepcion)
      {
      Cadena = "";  // Para que no se queje el compilador
      System.out.println ("Error fatal: no se encuentra el recurso "
                          + ArchivoLista);
      destroyApp (false);
      notifyDestroyed();      
      }

    // El archivo con la lista de banderas y países tiene el siguiente formato
    // Cada línea corresponde a una bandera y su país correspondiente
    // Hasta el primer espacio de la línea está el nombre del archivo png
    // El resto de la línea es el nombre del país
    HayQueSeguir = true;
    PosicionEspacio = 0;
    PosicionFinLinea = -1;
    while ( HayQueSeguir )
      {
      // Buscamos el siguiente espacio en blanco
      PosicionEspacio = Cadena.indexOf (' ', PosicionFinLinea);
      if ( PosicionEspacio != -1 )
        {
        // Guardamos el nombre de la bandera
        Trozo = Cadena.substring (PosicionFinLinea+1, PosicionEspacio);
        Bandera.addElement (Trozo);
        // Guardamos el nombre del país
        PosicionFinLinea = Cadena.indexOf ('\n', PosicionEspacio);
        Trozo = Cadena.substring (PosicionEspacio+1, PosicionFinLinea);
        Nombre.addElement (Trozo);
        }
      else
        { HayQueSeguir = false; }
      }
    }

  }
