//-------------------------------------------------------------------------
// Fichero:  LienzoAprender.java
// Objetivo: Implementar la clase LienzoAprender
// Fecha:    S.15.9.2007
// Autor:    Pedro Reina <pedro@pedroreina.net>
// Licencia: GPLv3 http://www.gnu.org/licenses/gpl.html
//-------------------------------------------------------------------------

// Paquetes necesarios

import java.lang.*;
import javax.microedition.midlet.*;
import javax.microedition.lcdui.*;
import java.util.Vector;             // Para las listas de banderas y nombres

// Clase CanvasAprender

class LienzoAprender extends Lienzo
  {
  // Variables de la clase
  private int Pais, TotalPaises;
  private Vector Bandera, Nombre;
  private boolean MostrarInfo;

  // Constructor de la clase
  public LienzoAprender (Vector Band, Vector Nomb)
    {
    MostrarInfo = true;
    Bandera = Band;
    Nombre = Nomb;
    TotalPaises = Bandera.size();
    Pais = 0;
    }
  
  public void paint (Graphics Graf)
    {
    String Cadena;
    Image ImagenBandera;
    
    // Llamamos al método general
    super.paint (Graf);
    
    // Cargamos la imagen de la bandera
    try
      {
      Cadena = (String) Bandera.elementAt(Pais);
      ImagenBandera = Image.createImage("/bandera/"+Cadena+".png");
      }
    catch (Exception Excepcion)
      {
      ImagenBandera = null;
      System.err.println ("Error: " + Excepcion);
      }

    // Pintamos un rectángulo gris para que los blancos y negros
    // de las banderas se vean correctamente
    Graf.setColor (128, 128, 128);
    if ( MostrarInfo )
      { Graf.fillRect (0, AlturaCabecera + 3*Avance/2, Anchura, 
                       AlturaUtil - 3*Avance); }
    else
      { Graf.fillRect (0, AlturaCabecera, Anchura, AlturaUtil); }

    // Ponemos la bandera
    Graf.drawImage (ImagenBandera, Anchura/2, AlturaCabecera+AlturaUtil/2,
                    Graphics.HCENTER | Graphics.VCENTER);

    if ( MostrarInfo )
      {
      // Mostramos el nombre del país
      Graf.setColor (0, 0, 0);
      Graf.setFont (FuenteMediana);
      Cadena = (String) Nombre.elementAt(Pais);
      Graf.drawString (Cadena, Margen, AlturaCabecera+1, 0);
    
      // Ponemos el número de país
      Cadena = (Pais+1) + " de " + TotalPaises;
      Graf.drawString (Cadena, Margen, Altura - Avance, 0);
      }
    }
    
  public void keyPressed (int CodigoTecla)
    {
    int Accion;
    
    Accion = getGameAction (CodigoTecla);
    switch (Accion)
      {
      case FIRE: MostrarInfo = !MostrarInfo;  break;
      case LEFT:  Pais--;     break;
      case UP:    Pais -= 10; break;
      case RIGHT: Pais++;     break;
      case DOWN:  Pais += 10; break;
      }

    // Cuidamos que el país no se salga de rango
    if ( Pais >= TotalPaises )
      { Pais -= TotalPaises; }
    if ( Pais < 0 )
      { Pais += TotalPaises; }

    // Actualizamos la pantalla
    repaint();
    serviceRepaints();
    }
  }
