//-------------------------------------------------------------------------
// Fichero:  LienzoExplicacion.java
// Objetivo: Implementar la clase LienzoExplicacion
// Fecha:    S.15.9.2007
// Autor:    Pedro Reina <pedro@pedroreina.net>
// Licencia: GPLv3 http://www.gnu.org/licenses/gpl.html
//-------------------------------------------------------------------------

// Paquetes necesarios

import java.lang.*;
import javax.microedition.midlet.*;
import javax.microedition.lcdui.*;
import java.util.Vector;             // Para crear un vector de cadenas
import java.io.InputStream;          // Para leer el archivo de explicaciones

// Clase LienzoExplicacion

class LienzoExplicacion extends Lienzo
  {
  // Constantes de la clase
  private String ArchivoExplicacion = "/explicacion.txt";

  // Variables de la clase
  private Vector LineasExplicacion;
  private Font FuentePequena;
  private int TotalLinea, FilasDisponibles, PrimeraLinea,
              MaxPrimeraLinea, UltimaFila;
  private int AlturaBarra;
  private boolean HayMovimiento;

  // Constructor de la clase
  public LienzoExplicacion ()
    {
    String TextoExplicacion;
    
    // Elegimos la fuente de letras
    FuentePequena = Font.getFont (Font.FACE_PROPORTIONAL, 
                    Font.STYLE_PLAIN, Font.SIZE_SMALL);

    // Altura de una línea
    Avance = FuentePequena.getHeight();

    // Leemos el texto de explicación del juego
    TextoExplicacion = LeeExplicacion();
    
    // Convertimos el texto en líneas
    LineasExplicacion = TroceaCadena (TextoExplicacion, 
                          FuentePequena, Anchura-2*Margen);

    // Las líneas que tiene el texto de explicación      
    TotalLinea = LineasExplicacion.size() - 1;
    
    // Las filas de las que disponemos en la pantalla para la explicación
    FilasDisponibles = AlturaUtil / Avance;
    
    if ( TotalLinea > FilasDisponibles )
      {
      // Vemos si será necesario mover el texto o no
      HayMovimiento = true;

      // La PrimeraLinea no podrá ser mayor que este valor porque quedaría
      // espacio en blanco en la parte inferior de la pantalla
      MaxPrimeraLinea = TotalLinea - FilasDisponibles;

      // La altura de la barra indicadora muestra la cantidad de texto que se ve
      AlturaBarra = AlturaUtil*FilasDisponibles/TotalLinea;

      // Vemos hasta dónde hay que escribir texto
      UltimaFila = FilasDisponibles;
      }

    else  // Este caso es trivial de manejar: hay más sitio que texto
      {
      HayMovimiento = false;
      MaxPrimeraLinea = 0;
      AlturaBarra = 0;
      UltimaFila = TotalLinea;
      }
    }
  
  protected void showNotify()
    {
    // La primera línea de la explicación que tiene que salir por pantalla.
    // Cuando el sistema nos dice que estamos a punto de aparecer en pantalla,
    // la ponemos al principio. Así siempre aparece en el punto correcto.
    PrimeraLinea = 0;
    }  

  public void paint (Graphics Graf)
    {
    int i, PosicionBarra;
    String Linea;

    // Llamamos al método general
    super.paint (Graf);
    
    // Activamos la fuente de la explicación
    Graf.setFont (FuentePequena);

    // Mostramos el texto de explicación
    for ( i=0 ; i<UltimaFila ; i++ )
      {
      Linea = (String) LineasExplicacion.elementAt(i+PrimeraLinea);
      Graf.drawString (Linea, Margen, AlturaCabecera+i*Avance, 0);
      }
      
    // La barra indicadora
    if ( HayMovimiento )
      {
      // Color rojo oscuro
      Graf.setColor (200, 0, 0);
      
      // En la siguiente operación hay una parte que parece que se podría
      // guardar en una variable para no tener que recalcularla cada vez,
      // pero para no perder la precisión necesaria la variable debería
      // ser float y eso no está disponible en todos los teléfonos móviles,
      // Build da error de verificación si se usa float con CLDC 1.0
      PosicionBarra = AlturaCabecera + 1 +
                      PrimeraLinea*Avance*FilasDisponibles/TotalLinea;
      
      // La barra es un rectángulo
      Graf.fillRect (Anchura-3, PosicionBarra, 2, AlturaBarra);
      }
    }

  public void keyPressed (int CodigoTecla)
    {
    int Accion;
    
    if ( HayMovimiento )
      {
      Accion = getGameAction (CodigoTecla);
      switch (Accion)
        {
        case UP:
          PrimeraLinea--;
          if ( PrimeraLinea < 0 )
            { PrimeraLinea = 0; }
          break;

        case LEFT:
          PrimeraLinea = 0;
          break;

        case DOWN:
          PrimeraLinea++;
          if ( PrimeraLinea > MaxPrimeraLinea )
            { PrimeraLinea = MaxPrimeraLinea; }
          break;

        case RIGHT:
          PrimeraLinea = MaxPrimeraLinea;
          break;
        }

      // Actualizamos la pantalla
      repaint();
      serviceRepaints();
      }
    }

  // Función que lee la explicación del juego de un fichero de recursos
  private String LeeExplicacion ()
    {
    byte Bufer[] = new byte[1024];
    InputStream FicheroExplicacion;
    String Respuesta;
    int Tamano;

    // Primero intentamos leer el archivo de recursos
    try
      {
      // Leemos el archivo en bruto
      FicheroExplicacion = getClass().getResourceAsStream (ArchivoExplicacion);
      Tamano = FicheroExplicacion.read (Bufer);
      FicheroExplicacion.close();

      // El fichero de origen debe estar codificado en UTF-8
      Respuesta = new String (Bufer, 0, Tamano, "UTF-8");

      // Convertimos los fines de línea en blancos
      Respuesta = Respuesta.replace ('\n', ' ');
      
      // Por mi convenio, la # significa un fin de línea
      Respuesta = Respuesta.replace ('#', '\n');
      }

    // Si no se puede leer el archivo, ponemos otro texto
    catch (Exception Excepcion)
      { Respuesta = "Juego de Pedro Reina\nhttp://pedroreina.net"; }
      
    // Contestamos lo que hemos obtenido
    return Respuesta;
    }

  // Función que convierte una cadena en un vector de cadenas
  private Vector TroceaCadena (String Cadena, Font Fuente, int Anchura)
    {
    WordWrap Wrap;
    boolean HayQueSeguir;
    int CorteSiguiente, CorteAnterior;
    Vector Respuesta;
    String Linea;

    // Creamos un vector para contener las cadenas
    Respuesta = new Vector();

    Wrap = new WordWrap (Fuente, Cadena, Anchura);
    HayQueSeguir = true;
    CorteSiguiente = -1;
    CorteAnterior = 0;

    while ( HayQueSeguir )
      {
      CorteSiguiente = Wrap.next();

      if ( CorteSiguiente != -1 )
        {
        // Hemos encontrado un punto de corte
        Linea = Cadena.substring (CorteAnterior, CorteSiguiente-1);
        CorteAnterior = CorteSiguiente;
        }

      else // Ya no hay más cortes
        {
        Linea = Cadena.substring (CorteAnterior);
        HayQueSeguir = false;
        }

      // Guardamos la línea      
      Respuesta.addElement (Linea);      
      }
      
    return Respuesta;
    }

  }
