//-------------------------------------------------------------------------
// Fichero:  LienzoMostrarBandera.java
// Objetivo: Implementar la clase LienzoMostrarBandera
// Fecha:    J.27.9.2007
// Autor:    Pedro Reina <pedro@pedroreina.net>
// Licencia: GPLv3 http://www.gnu.org/licenses/gpl.html
//-------------------------------------------------------------------------

// Paquetes necesarios

import java.lang.*;
import java.util.*;
import javax.microedition.midlet.*;
import javax.microedition.lcdui.*;

// Clase LienzoMostrarBandera

class LienzoMostrarBandera extends Lienzo
  {
  // Constantes de la clase
  private int Tiempo = 3000;

  // Variables de la clase
  private Vector Bandera;
  private int Numero;
  private Display Pantalla;
  private Displayable Siguiente;
  private Timer Terminador;

  // set-get
  public void setNumero (int Valor)
    { Numero = Valor; }
    
  public void setSiguiente (Displayable Pant)
    { Siguiente = Pant; }
    
  // Constructor de la clase
  public LienzoMostrarBandera (Display Pant, Vector Band)
    {
    // Nos quedamos con el manejador de la pantalla del MIDlet 
    Pantalla = Pant;
    
    // Anotamos el vector de banderas
    Bandera = Band;
    }

  public void paint (Graphics Graf)
    {
    String Cadena;
    Image ImagenBandera;
    
    // Llamamos al método general
    super.paint (Graf);
    
    // Cargamos la imagen de la bandera
    try
      {
      Cadena = (String) Bandera.elementAt(Numero);
      ImagenBandera = Image.createImage("/bandera/"+Cadena+".png");
      }
    catch (Exception Excepcion)
      {
      ImagenBandera = null;
      System.err.println ("Error: " + Excepcion);
      }

    // Pintamos un rectángulo gris para que los blancos y negros
    // de las banderas se vean correctamente
    Graf.setColor (128, 128, 128);
    Graf.fillRect (0, AlturaCabecera, Anchura, AlturaUtil);

    // Ponemos la bandera
    Graf.drawImage (ImagenBandera, Anchura/2, AlturaCabecera+AlturaUtil/2,
                    Graphics.HCENTER | Graphics.VCENTER);
    }
  
  protected void showNotify()
    {
    // Cuando el sistema nos dice que estamos a punto de aparecer en
    // pantalla, creamos un temporizador que nos haga desaparecer al cabo
    // de tres segundos.
    Terminador = new Timer();
    Terminador.schedule (new Contador(), Tiempo);
    }  

  private void Terminar()
    {
    // Para terminar, cancelamos el temporizador
    Terminador.cancel();
    
    // Y pasamos a la siguente pantalla
    Pantalla.setCurrent (Siguiente);
    }

  private class Contador extends TimerTask
    {
    public void run()
      { Terminar(); }
    }   
  }
