//-------------------------------------------------------------------------
// Fichero:  Menu.java
// Objetivo: Implementar la clase Menu
// Fecha:    J.27.9.2007
// Autor:    Pedro Reina <pedro@pedroreina.net>
// Licencia: GPLv3 http://www.gnu.org/licenses/gpl.html
//-------------------------------------------------------------------------

// Paquetes necesarios

import java.lang.*;
import javax.microedition.midlet.*;
import javax.microedition.lcdui.*;
import java.util.Vector;             // Para la lista de opciones

// Clase Menu

class Menu extends Lienzo
  {
  // Variables de la clase
  private int Elegido, Total;
  private Vector Opcion;
  private boolean UsarNumeros;
  private Font Fuente;

  // get-set
  public void setElegido (int Valor)
    { Elegido = Valor; }
    
  public int getElegido()
    { return Elegido; }

  public void setOpcion (Vector Op)
    {
    Opcion = Op;
    Total = Opcion.size();
    AjustaFuente();
    }

  // Constructores de la clase
  public Menu (Vector Op)
    {
    Opcion = Op;
    Total = Opcion.size();
    Elegido = 0;
    UsarNumeros = false;
    }
  
  public Menu ()
    {
    Elegido = -1;
    UsarNumeros = true;
    }

  // Función que borra el elemento elegido  
  public void borraElegido()
    { Elegido = -1; }

  public void paint (Graphics Graf)
    {
    int i;
    String Cadena, Prefijo;
    
    // Llamamos al método general
    super.paint (Graf);

    // Ajustamos la fuente    
    Graf.setFont (Fuente);
    
    // Imprimimos todas las opciones
    Prefijo = "";
    for ( i=0 ; i<Total ; i++)
      {
      if ( UsarNumeros )
        { Prefijo = (i+1) + ". ";}
      Cadena = Prefijo + (String) Opcion.elementAt(i);
      Graf.drawString (Cadena, Margen, AlturaCabecera+i*Avance+1, 0);
      }

    // Imprimimos resaltada la opción elegida
    if ( Elegido >= 0 )
      {
      Graf.setColor (0, 224, 0);
      if ( UsarNumeros )
        { Prefijo = (Elegido+1) + ". ";}
      Cadena = Prefijo + (String) Opcion.elementAt(Elegido);
      Graf.drawString (Cadena, Margen, AlturaCabecera+(Elegido)*Avance+1, 0);
      }
    }

  // Función que prepara el tipo de letra del menú
  private void AjustaFuente()
    {
    int FilasDisponibles;
    
    Fuente = FuenteMediana;
    
    // Las filas de las que disponemos en la pantalla para la explicación
    FilasDisponibles = AlturaUtil / Avance;
    
    // En algunos teléfonos no caben todas las opciones
    if ( FilasDisponibles < Total )
      {
      // Primero elegimos una letra más pequeña
      Fuente = Font.getFont (Font.FACE_PROPORTIONAL, Font.STYLE_PLAIN,
                             Font.SIZE_SMALL);
      Avance = Fuente.getHeight();
      FilasDisponibles = AlturaUtil / Avance;
      
      // Pero algunos teléfonos no hacen caso o bien
      // la fuente no es suficientemente pequeña
      if ( FilasDisponibles < Total )
        {
        // Entonces tomamos un interlineado más pequeño aunque
        // esto pueda originar que no se lean bien las opciones
        Avance = AlturaUtil / Total;
        }
      }
    }
    
  public void keyPressed (int CodigoTecla)
    {
    if ( UsarNumeros ) // Solo admitimos el teclado numérico
      {
      int Temporal;
      
      // Vemos qué tecla ha pulsado el usuario
      switch (CodigoTecla)
        {
        case KEY_NUM1: Temporal = 0; break;
        case KEY_NUM2: Temporal = 1; break;
        case KEY_NUM3: Temporal = 2; break;
        case KEY_NUM4: Temporal = 3; break;
        case KEY_NUM5: Temporal = 4; break;
        case KEY_NUM6: Temporal = 5; break;
        case KEY_NUM7: Temporal = 6; break;
        case KEY_NUM8: Temporal = 7; break;
        case KEY_NUM9: Temporal = 8; break;
        default: Temporal = Total; break;
        }
        
      // Si la tecla es una opción válida, la guardamos
      if ( Temporal < Total )
        { Elegido = Temporal; }
      }

    else // Solo admitimos el joystick
      {    
      int Accion;

      Accion = getGameAction (CodigoTecla);
      switch (Accion)
        {
        case LEFT:
        case UP:    Elegido --; break;
        case RIGHT:
        case DOWN:  Elegido ++; break;
        }

       // Cuidamos que la opción elegida no se salga de rango
       if ( Elegido >= Total )
         { Elegido -= Total; }
       if ( Elegido < 0 )
         { Elegido += Total; }
       }

    // Actualizamos la pantalla
    repaint();
    serviceRepaints();
    }
  }
