/*------------------------------------------------
 * Proyecto: Buscapal
 * Autor:    Pedro Reina <pedro@pedroreina.net>
 * Archivo:  BuscapalActivity.java
 * Fecha:    V.26.8.2011
 * Licencia: Licencia: GPLv2 (c) 1992 Pedro Reina
 *           y EQ Sistemas Inteligentes
 *----------------------------------------------*/

// El paquete de este programa
package net.pedroreina.buscapal;

// Manejar la actividad
import android.app.Activity;
import android.os.Bundle;

// Manejar el menú
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;

// Usar diálogos de alerta
import android.app.Dialog;
import android.app.AlertDialog;
import android.app.AlertDialog.Builder;

// Convertir entre números y cadenas
import java.lang.Integer;
import java.lang.Long;

// Usar listas
import java.util.ArrayList;

// Usar Arrays
import java.util.Arrays;

// Usar StringBuilder
import java.lang.StringBuilder;

// Usar el reloj de precisión
import android.os.SystemClock;

// Manejar textos con etiquetas HTML
import android.text.Html;
import android.text.Spanned;

// Lanzar la actividad de las preferencias
import android.content.Intent;

// Leer las preferencias
import android.preference.PreferenceManager;
import android.content.SharedPreferences;
import android.content.SharedPreferences.OnSharedPreferenceChangeListener;

// Elementos del GUI
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;

// Vistas
import android.view.View;

//-----------------------------------------------
// La actividad principal
//-----------------------------------------------
public class BuscapalActivity extends Activity
  implements OnSharedPreferenceChangeListener
  {
  // El número de letras de un problema
  public static final int N = 9;

  // Los textos de cada botón
  String Letra[] = {"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L",
    "M", "N", "Ñ", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z" };

  AlertDialog About, License, Credits;
  Intent Config, Help;

  // Botones
  Button BotonBuscar, BotonBorrar, BotonNuevo;
  Button[] BotonDato;

  // El lugar en el que ir escribiendo los datos del problema
  TextView TextoProblema;

  // El problema que estamos preparando
  String PreparacionProblema;

  // Los textos con los resultados
  TextView TextoObtenido, TextoTiempo;

  // Conjunto de preferencias
  SharedPreferences Pref;

  // El dato que va a introducir el usuario
  int PosicionEntrada;

  // El estado de la actividad
  Bundle Estado;

  //----------------------------------------------
  // El sistema crea la actividad
  //----------------------------------------------
  @Override
  public void onCreate (Bundle EstadoSalvado)
    {
    AlertDialog.Builder Constructor;

    super.onCreate (EstadoSalvado);
    Estado = EstadoSalvado;

    // Creamos los botones con las 27 letras
    BotonDato = new Button[27];

    // Preparamos el lector de preferencias
    Pref = PreferenceManager.getDefaultSharedPreferences (this);
    Pref.registerOnSharedPreferenceChangeListener (this);

    // Creamos el diálogo About
    Constructor = new AlertDialog.Builder(this);
    String Mensaje = "<b>" + getString (R.string.app_name) + "</b>";
      Mensaje += "<BR>" + getString (R.string.version);
      Mensaje += " " + getString (R.string.num_version);
      Mensaje += ", " + getString (R.string.fecha);
      Mensaje += "<BR>Pedro Reina";
      Mensaje += "<BR>http://pedroreina.net";
    Constructor.setTitle (getString (R.string.about));
    Constructor.setMessage (Html.fromHtml (Mensaje));
    Constructor.setPositiveButton (getString(R.string.OK), null);
    About = Constructor.create();

    // Creamos el diálogo License
    Constructor = new AlertDialog.Builder (this);
    Constructor.setTitle (getString (R.string.license));
    Constructor.setMessage (getText (R.string.text_license));
    Constructor.setPositiveButton (getString (R.string.OK), null);
    License = Constructor.create();

    // Creamos el diálogo Credits
    Constructor = new AlertDialog.Builder(this);
    Constructor.setTitle (getString (R.string.credits));
    Constructor.setMessage (getText (R.string.text_credits));
    Constructor.setPositiveButton (getString (R.string.OK), null);
    Credits = Constructor.create();

    // Preparamos la actividad Preferences
    Config = new Intent (getBaseContext(), BuscapalPreferences.class);

    // Preparamos la actividad Help
    Help = new Intent (getBaseContext(), BuscapalHelp.class);

    // Lanzamos la vista del GUI
    PreparaVista();
    }

  //----------------------------------------------
  // Creación del menú de opciones
  //----------------------------------------------
  @Override
  public boolean onCreateOptionsMenu (Menu menu)
    {
    MenuInflater inflater = getMenuInflater();
    inflater.inflate (R.menu.options, menu);
    return true;
    }

  //----------------------------------------------
  // Manejo de las contestaciones del menú de opciones
  //----------------------------------------------
  @Override
  public boolean onOptionsItemSelected (MenuItem item)
    {
    // Actuamos segun elija el usuario
    switch ( item.getItemId() )
      {
      case R.id.config:
        startActivity (Config);
        return true;

      case R.id.help:
        startActivity (Help);
        return true;

      case R.id.license:
        License.show();
        return true;

      case R.id.credits:
        Credits.show();
        return true;

      case R.id.about:
        About.show();
        return true;

      case R.id.quit:
        // Cerramos el programa
        this.finish();
        System.runFinalizersOnExit (true);
        System.exit (0);
        return true;

      default:
        return super.onOptionsItemSelected (item);
      }
    }

  //----------------------------------------------
  // Cuando arranca la vista de la actividad
  //----------------------------------------------
  @Override
  public void onStart()
    {
    super.onStart();

    if ( Estado == null )
      {
      // Valores iniciales
      PreparacionProblema = "";
      PosicionEntrada = 0;
      }
    else
      { LeeEstado(); }

    PreparaVista();
    }

  //----------------------------------------------
  // Si el sistema avisa de que vamos a salir de la pantalla
  //----------------------------------------------
  @Override
  protected void onSaveInstanceState (Bundle Estado)
    {
    super.onSaveInstanceState (Estado);
    EscribeEstado (Estado);
    }

  //----------------------------------------------
  // Si el sistema avisa de que nos van a pausar
  //----------------------------------------------
  @Override
  protected void onPause()
    {
    super.onPause();
    if ( Estado == null )
      { Estado = new Bundle(); }
    EscribeEstado (Estado);
    }

  //----------------------------------------------
  // Si el sistema avisa de que vamos a volver
  //----------------------------------------------
  @Override
  protected void onResume()
    {
    super.onResume();
    if ( Estado != null )
      {
      LeeEstado();
      PreparaVista();
      }
    }

  //----------------------------------------------
  // Leer las variables del estado
  //----------------------------------------------
  public void LeeEstado()
    {
    PosicionEntrada = Estado.getInt ("posicion");
    PreparacionProblema = Estado.getString ("problema");
    }

  //----------------------------------------------
  // Escribir las variables del estado
  //----------------------------------------------
  public void EscribeEstado (Bundle Estado)
    {
    Estado.putInt ("posicion", PosicionEntrada);
    Estado.putString ("problema", PreparacionProblema);
    }

  //----------------------------------------------
  // Si se cambia algún valor de las preferencias
  //----------------------------------------------
  @Override
  public void onSharedPreferenceChanged (SharedPreferences Pref, String Key)
    { PreparaVista(); }

  //----------------------------------------------
  // Preparar la pantalla para pedir el problema
  //----------------------------------------------
  public void PreparaVista()
    {
    // Cargamos el diseño
    setContentView (R.layout.normal);

    // Preparamos el texto donde prepararemos el problema
    TextoProblema = (TextView) findViewById (R.id.problema);
    TextoProblema.setText (PreparacionProblema);

    // Buscamos el botón de borrar
    BotonBorrar = (Button) findViewById (R.id.borrar);

    // Le asignamos su función al pulsar
    BotonBorrar.setOnClickListener (new View.OnClickListener()
      {
      public void onClick (View Vista)
        { BorraUnDato(); }
      });

    // Le asignamos su función con pulsación larga
    BotonBorrar.setOnLongClickListener (new View.OnLongClickListener()
      {
      public boolean onLongClick (View Vista)
        {
        BorraDatos();
        return true;
        }
      });

    // Buscamos el botón de nuevo problema
    BotonNuevo = (Button) findViewById (R.id.nuevo);

    // Le asignamos su función
    BotonNuevo.setOnClickListener (new View.OnClickListener()
      {
      public void onClick (View Vista)
        { NuevoProblema(); }
      });

    // Buscamos el botón de buscar
    BotonBuscar = (Button) findViewById (R.id.busca);

    // Asignamos al botón su función
    BotonBuscar.setOnClickListener (new View.OnClickListener()
      {
      public void onClick (View Vista)
        { Resuelve(); }
      });

    // Buscamos las vistas de los textos del GUI
    TextoObtenido = (TextView) findViewById (R.id.obtenido);
    TextoTiempo = (TextView) findViewById (R.id.tiempo);

    // Buscamos los botones para introducir datos
    BotonDato[0] = (Button) findViewById (R.id.a);
    BotonDato[1] = (Button) findViewById (R.id.b);
    BotonDato[2] = (Button) findViewById (R.id.c);
    BotonDato[3] = (Button) findViewById (R.id.d);
    BotonDato[4] = (Button) findViewById (R.id.e);
    BotonDato[5] = (Button) findViewById (R.id.f);
    BotonDato[6] = (Button) findViewById (R.id.g);
    BotonDato[7] = (Button) findViewById (R.id.h);
    BotonDato[8] = (Button) findViewById (R.id.i);
    BotonDato[9] = (Button) findViewById (R.id.j);
    BotonDato[10] = (Button) findViewById (R.id.k);
    BotonDato[11] = (Button) findViewById (R.id.l);
    BotonDato[12] = (Button) findViewById (R.id.m);
    BotonDato[13] = (Button) findViewById (R.id.n);
    BotonDato[14] = (Button) findViewById (R.id.nn);
    BotonDato[15] = (Button) findViewById (R.id.o);
    BotonDato[16] = (Button) findViewById (R.id.p);
    BotonDato[17] = (Button) findViewById (R.id.q);
    BotonDato[18] = (Button) findViewById (R.id.r);
    BotonDato[19] = (Button) findViewById (R.id.s);
    BotonDato[20] = (Button) findViewById (R.id.t);
    BotonDato[21] = (Button) findViewById (R.id.u);
    BotonDato[22] = (Button) findViewById (R.id.v);
    BotonDato[23] = (Button) findViewById (R.id.w);
    BotonDato[24] = (Button) findViewById (R.id.x);
    BotonDato[25] = (Button) findViewById (R.id.y);
    BotonDato[26] = (Button) findViewById (R.id.z);

    // Asignamos a los botones su función
    for ( int i=0 ; i<27 ; i++ )
      {
      BotonDato[i].setOnClickListener (new View.OnClickListener()
        {
        public void onClick (View Vista)
          { BotonDatoPulsado (Vista); }
        });
      }

    // Mostramos los botones
    PreparaBotonera();
    }

  //----------------------------------------------
  // Preparamos qué botones verá el usuario
  //----------------------------------------------
  public void PreparaBotonera()
    {
    // Si el problema está completo
    if ( PosicionEntrada == 9 )
      {
      // No se muestra ningún botón de datos
      for ( int i=0 ; i<27 ; i++ )
        {
        BotonDato[i].setText ("");
        BotonDato[i].setClickable (false);
        }
      // Se activa el botón de análisis
      BotonBuscar.setText (getString (R.string.busca));
      BotonBuscar.setClickable (true);
      }

    // Si el problema no está completo
    else
      {
      // Se muestran los botones de datos
      for ( int i=0 ; i<27 ; i++ )
        {
        BotonDato[i].setText ((Letra[i]));
        BotonDato[i].setClickable (true);
        }
      // El botón de Borrar no se muestra al comenzar
      if ( PosicionEntrada == 0 )
        {
        BotonBorrar.setText ("");
        BotonBorrar.setClickable (false);
        }
      else
        {
        BotonBorrar.setText (getString (R.string.borrar));
        BotonBorrar.setClickable (true);
        }
      // Se desactiva el botón de análisis
      BotonBuscar.setText ("");
      BotonBuscar.setClickable (false);
      }
    }

  //----------------------------------------------
  // Cuando se pulsa un botón de introducción de datos
  //----------------------------------------------
  public void BotonDatoPulsado (View Boton)
    {
    String NuevoDato = "";

    // Buscamos qué botón nos mandan
    for ( int i=0 ; i<27 ; i++ )
      {
      // Si lo encontramos
      if ( BotonDato[i] == (Button) Boton )
        { NuevoDato += Letra[i]; }
      }

    // Actualizamos el problema
    if ( PreparacionProblema.length() > 0 )
      { PreparacionProblema += " "; };
    PreparacionProblema += NuevoDato;

    // Avanzamos la posición
    PosicionEntrada++;

    // Anotamos cómo va el problema
    TextoProblema.setText (PreparacionProblema);

    // Repasamos los botones
    PreparaBotonera();
    }

  //----------------------------------------------
  // Borramos los datos introducidos hasta el momento
  //----------------------------------------------
  public void BorraDatos()
    {
    PreparacionProblema = "";
    TextoProblema.setText (PreparacionProblema);
    PosicionEntrada = 0;
    PreparaBotonera();
    }

  //----------------------------------------------
  // Borramos el último dato introducido
  //----------------------------------------------
  public void BorraUnDato()
    {
    int Posicion;

    // Solo hay que hacer algo cuando hay datos
    if ( PosicionEntrada > 0 )
      {
      // Si solo hay un dato, lo borramos
      if ( PosicionEntrada == 1 )
        { PreparacionProblema = ""; }

      // En cualquier otro caso
      else
        {
        // Buscamos el último espacio
        Posicion = PreparacionProblema.lastIndexOf (" ");
        // Nos quedamos con la primera parte
        PreparacionProblema = PreparacionProblema.substring (0, Posicion);
        }

      // Retrasamos la posición
      PosicionEntrada--;

      // Anotamos cómo va el problema
      TextoProblema.setText (PreparacionProblema);

      // Repasamos los botones
      PreparaBotonera();
      }
    }

  //----------------------------------------------
  // Preparamos para un nuevo problema
  //----------------------------------------------
  public void NuevoProblema()
    {
    for ( int i=0 ; i<27 ; i++ )
      { BotonDato[i].setVisibility (View.VISIBLE); }
    BotonBorrar.setVisibility (View.VISIBLE);
    BotonBuscar.setVisibility (View.VISIBLE);
    BotonNuevo.setVisibility (View.GONE);
    TextoObtenido.setText ("");
    TextoTiempo.setText ("");
    BorraDatos();
    }

  //----------------------------------------------
  // Preparamos para dejar sitio a la solución
  //----------------------------------------------
  public void PreparaParaDarSolucion()
    {
    for ( int i=0 ; i<27 ; i++ )
      {
      BotonDato[i].setText ("");
      BotonDato[i].setVisibility (View.GONE);
      }
    BotonBorrar.setVisibility (View.GONE);
    BotonBuscar.setVisibility (View.GONE);
    BotonNuevo.setVisibility (View.VISIBLE);
    }

  //----------------------------------------------
  // Resolver el problema
  //----------------------------------------------
  public void Resuelve()
    {
    String Problema="", Resultado;
    long Antes, Ahora, Tiempo;

    // Obtenemos el problema
    Problema = TextoProblema.getText().toString();

    // Quitamos los espacios
    Problema = Problema.replace (" ", "");

    // Tratamiento de la ñ
    Problema = Problema.replace ("Ñ", "+");

    // Conversión a minúsculas
    Problema = Problema.toLowerCase();

    // Llamamos al código para que busque las palabras
    BotonBuscar.setText (getString (R.string.analizando));
    Antes = SystemClock.uptimeMillis();
    Resultado = BuscaPalabras (Problema);
    Ahora = SystemClock.uptimeMillis();
    Tiempo = Ahora - Antes;

    // Anotamos el resultado
    PreparaParaDarSolucion();
    TextoObtenido.setText (Resultado);
    TextoTiempo.setText (getString (R.string.tiempo) + ": " +
                         Long.toString (Tiempo) + " ms");
    BotonBuscar.setText (getString (R.string.busca));
    }

  //----------------------------------------------
  // Buscar palabras con las letras dadas
  //----------------------------------------------
  public String BuscaPalabras (String Problema)
    {
    boolean HayQueBuscar, Primero=true;
    int Longitud;
    String Resultado = "", NombrePreferencia, LongTexto;
    ArrayList<String> Claves, Palabras;
    BuscapalDatabase BaseDato;

    // Creamos un manejador de base de datos
    BaseDato = new BuscapalDatabase (getBaseContext());

    // Si encontramos la base de datos nos ponemos a buscar palabras
    if ( BaseDato.Existe() )
      {
      // Vamos de longitudes mayores a menores
      for ( Longitud = 9 ; Longitud >=5 ; Longitud-- )
        {
        LongTexto = Integer.toString (Longitud);

        // Vemos si nos han pedido buscar palabras de esta longitud
        NombrePreferencia = "p" + LongTexto;
        HayQueBuscar = Pref.getBoolean (NombrePreferencia, true);

        // Si lo han pedido, buscamos
        if ( HayQueBuscar )
          {
          // La primera vez no ponemos ENTER, las demás sí
          if ( ! Primero )
            { Resultado += "\n"; }
          else
            { Primero = false; }
          Resultado += LongTexto + ":";

          // Generamos todas las claves del problema
          Claves = GeneraClaves (Problema, Longitud);

          // Buscamos las palabras asociadas a las claves
          Palabras = BaseDato.ListaPalabras (Claves);

          // Si encontramos palabras, las escribimos
          if ( ! Palabras.isEmpty() )
            {
            for ( String Palabra : Palabras )
              { Resultado += " " + Palabra; }
            }

          // Si no encontramos palabras, lo decimos
          else
            { Resultado += " [" + getString (R.string.ninguna) + "]."; }
          }
        }
      BaseDato.Cierra();
      }

    // Si no encontramos la base de datos, emitimos un mensaje de error
    else
      {
      Resultado = "Error: " + BaseDato.Fichero() + " " +
                  getString (R.string.noencontrado);
      }

    return Resultado;
    }

  //----------------------------------------------
  // Generar las posibles claves que se pueden
  // obtener de un problema que tengan longitud dada
  //----------------------------------------------
  public ArrayList<String> GeneraClaves (String Problema, int Longitud)
    {
    ArrayList<String> ConjuntoClaves;
    ConjuntoClaves = new ArrayList<String>();

    if ( Longitud == 9 )  { ConjuntoClaves = Genera9 (Problema); }
    if ( Longitud == 8 )  { ConjuntoClaves = Genera8 (Problema); }
    if ( Longitud == 7 )  { ConjuntoClaves = Genera7 (Problema); }
    if ( Longitud == 6 )  { ConjuntoClaves = Genera6 (Problema); }
    if ( Longitud == 5 )  { ConjuntoClaves = Genera5 (Problema); }

    return ConjuntoClaves;
    }

  //----------------------------------------------
  // Generar la única clave de longitud 9
  // que se puede obtener de un problema
  //----------------------------------------------
  public ArrayList<String> Genera9 (String Problema)
    {
    String Clave;
    ArrayList<String> ConjuntoClaves;

    // Una lista para poner la clave
    ConjuntoClaves = new ArrayList<String>();

    // Ordenamos las letras de la palabra y formamos la clave
    Clave = OrdenaPalabra (Problema);

    // La almacenamos
    ConjuntoClaves.add (Clave);

    // Devolvemos el conjunto de claves
    return ConjuntoClaves;
    }

  //----------------------------------------------
  // Generar las posibles claves que se pueden
  // obtener de un problema que tengan longitud 8
  //----------------------------------------------
  public ArrayList<String> Genera8 (String Problema)
    {
    String Clave;
    StringBuilder Palabra;
    ArrayList<String> ConjuntoClaves;
    int Quita1, i;

    // Una lista para poner todas las claves diferentes
    ConjuntoClaves = new ArrayList<String>();

    // Vamos quitando un carácter
    for ( Quita1=0 ; Quita1<N ; Quita1++ )
      {
      Palabra = new StringBuilder(N);
      for ( i=0 ; i<N ; i++ )
        {
        if ( i != Quita1 )
          { Palabra.append (Problema.charAt(i)); }
        }
      Clave = new String (Palabra);

      // Ordenamos las letras de la clave
      Clave = OrdenaPalabra (Clave);

      // La almacenamos si no está ya
      if ( ! ConjuntoClaves.contains (Clave) )
        { ConjuntoClaves.add (Clave); }
      }

    // Devolvemos el conjunto de claves
    return ConjuntoClaves;
    }

  //----------------------------------------------
  // Generar las posibles claves que se pueden
  // obtener de un problema que tengan longitud 7
  //----------------------------------------------
  public ArrayList<String> Genera7 (String Problema)
    {
    String Clave;
    StringBuilder Palabra;
    ArrayList<String> ConjuntoClaves;
    int Quita1, Quita2, i;

    // Una lista para poner todas las claves diferentes
    ConjuntoClaves = new ArrayList<String>();

    // Vamos quitando dos caracteres
    for ( Quita1=0        ; Quita1<N-1 ; Quita1++ ) {
    for ( Quita2=Quita1+1 ; Quita2<N   ; Quita2++ )
      {
      Palabra = new StringBuilder(N);
      for ( i=0 ; i<N ; i++ )
        {
        if ( i != Quita1 && i != Quita2 )
          { Palabra.append (Problema.charAt(i)); }
        }
      Clave = new String (Palabra);

      // Ordenamos las letras de la clave
      Clave = OrdenaPalabra (Clave);

      // La almacenamos si no está ya
      if ( ! ConjuntoClaves.contains (Clave) )
        { ConjuntoClaves.add (Clave); }
      }}

    // Devolvemos el conjunto de claves
    return ConjuntoClaves;
    }

  //----------------------------------------------
  // Generar las posibles claves que se pueden
  // obtener de un problema que tengan longitud 6
  //----------------------------------------------
  public ArrayList<String> Genera6 (String Problema)
    {
    String Clave;
    StringBuilder Palabra;
    ArrayList<String> ConjuntoClaves;
    int Quita1, Quita2, Quita3, i;

    // Una lista para poner todas las claves diferentes
    ConjuntoClaves = new ArrayList<String>();

    // Vamos quitando tres caracteres
    for ( Quita1=0        ; Quita1<N-2 ; Quita1++ ) {
    for ( Quita2=Quita1+1 ; Quita2<N-1 ; Quita2++ ) {
    for ( Quita3=Quita2+1 ; Quita3<N   ; Quita3++ )
      {
      Palabra = new StringBuilder(N);
      for ( i=0 ; i<N ; i++ )
        {
        if ( i != Quita1 && i != Quita2 && i!= Quita3 )
          { Palabra.append (Problema.charAt(i)); }
        }
      Clave = new String (Palabra);

      // Ordenamos las letras de la clave
      Clave = OrdenaPalabra (Clave);

      // La almacenamos si no está ya
      if ( ! ConjuntoClaves.contains (Clave) )
        { ConjuntoClaves.add (Clave); }
      }}}

    // Devolvemos el conjunto de claves
    return ConjuntoClaves;
    }

  //----------------------------------------------
  // Generar las posibles claves que se pueden
  // obtener de un problema que tengan longitud 5
  //----------------------------------------------
  public ArrayList<String> Genera5 (String Problema)
    {
    String Clave;
    StringBuilder Palabra;
    ArrayList<String> ConjuntoClaves;
    int Quita1, Quita2, Quita3, Quita4, i;

    // Una lista para poner todas las claves diferentes
    ConjuntoClaves = new ArrayList<String>();

    // Vamos quitando cuatro caracteres
    for ( Quita1=0        ; Quita1<N-3 ; Quita1++ ) {
    for ( Quita2=Quita1+1 ; Quita2<N-2 ; Quita2++ ) {
    for ( Quita3=Quita2+1 ; Quita3<N-1 ; Quita3++ ) {
    for ( Quita4=Quita3+1 ; Quita4<N   ; Quita4++ )
      {
      Palabra = new StringBuilder(N);
      for ( i=0 ; i<N ; i++ )
        {
        if ( i != Quita1 && i != Quita2 && i!= Quita3 && i!=Quita4 )
          { Palabra.append (Problema.charAt(i)); }
        }
      Clave = new String (Palabra);

      // Ordenamos las letras de la clave
      Clave = OrdenaPalabra (Clave);

      // La almacenamos si no está ya
      if ( ! ConjuntoClaves.contains (Clave) )
        { ConjuntoClaves.add (Clave); }
      }}}}

    // Devolvemos el conjunto de claves
    return ConjuntoClaves;
    }

  //----------------------------------------------
  // Ordenar las letras de una palabra
  // Código de Jon Skeet en stackoverflow.com
  //----------------------------------------------
  public String OrdenaPalabra (String Palabra)
    {
    String Resultado;
    char[] PalabraArray;

    // Convertimos la palabra en un array
    PalabraArray = Palabra.toCharArray();

    // Ordenamos el array
    Arrays.sort (PalabraArray);

    // Convertimos el array en cadena
    Resultado = new String (PalabraArray);

    // Y devolvemos el resultado
    return Resultado;
    }
  }
