/*------------------------------------------------
 * Proyecto: Buscapal
 * Autor:    Pedro Reina <pedro@pedroreina.net>
 * Archivo:  BuscapalDatabase.java
 * Fecha:    M.2.8.2011
 * Licencia: GPLv2
 *----------------------------------------------*/

// El paquete de este programa
package net.pedroreina.buscapal;

// Manejar la actividad
import android.app.Activity;
import android.os.Bundle;

// Leer las preferencias
import android.preference.PreferenceManager;
import android.content.SharedPreferences;

// Manejar el contexto de la aplicacion
import android.content.Context;

// Saber si existe un fichero
import java.io.File;

// Manejar ficheros SQLite
import android.database.sqlite.SQLiteDatabase;
import android.database.Cursor;

// Usar listas
import java.util.ArrayList;

// Convertir entero en cadena
import java.lang.Integer;

//-----------------------------------------------
// La clase
//-----------------------------------------------
public class BuscapalDatabase
  {
  // Contexto de la aplicacion
  Context Contexto;

  // El nombre del fichero con la base de datos
  String Fichero, FicheroDefecto;

  // Conjunto de preferencias
  SharedPreferences Pref;

  // Saber si existe el archivo de la base de datos
  boolean ExisteFichero;

  // La base de datos
  SQLiteDatabase BaseDato;

  // Los componentes de una consulta
  String Select, From, Where, Order;

  // Constructor
  BuscapalDatabase (Context Cont)
    {
    // Guardamos el contexto
    Contexto = Cont;

    // Las cadenas para montar la consulta a la base de datos
    Select = "SELECT palabra ";
    From =   "FROM palabra";
    Order =  " ORDER BY palabra";

    // Averiguamos el nombre por defecto del fichero
    FicheroDefecto = Contexto.getString (R.string.dbfile_default);

    // Preparamos el lector de preferencias
    Pref = PreferenceManager.getDefaultSharedPreferences (Contexto);

    // Leemos el fichero de las preferencias
    Fichero = Pref.getString ("dbfile", FicheroDefecto);

    // Vemos si existe el archivo con la base de datos
    File Manejador = new File (Fichero);
    if ( Manejador.exists()  )
      {
      ExisteFichero = true;

      // Abrimos la base de datos
      BaseDato = SQLiteDatabase.openDatabase
        (Fichero, null, SQLiteDatabase.OPEN_READONLY+
                        SQLiteDatabase.NO_LOCALIZED_COLLATORS);
      }

    else
      { ExisteFichero = false; }
    }

  // Contestamos el nombre del archivo con la base de datos
  public String Fichero()
    { return Fichero; }

  // Contestamos si existe el archivo con la base de datos
  public boolean Existe()
    { return ExisteFichero; }

  // Cerramos la base de datos
  public void Cierra()
    { BaseDato.close(); }

  // Contestamos la lista de palabras de una lista de claves
  public ArrayList<String> ListaPalabras (ArrayList<String> Claves)
    {
    String Consulta;
    int Longitud=0;
    boolean Primera = true;

    // Averiguamos la longitud de la clave, que hace falta para
    // el nombre de la tabla
    for ( String Clave : Claves )
      {
      if ( Primera )
        {
        Longitud = Clave.length();
        Primera = false;
        }
      }

    // Preparamos la consulta
    Consulta = Select + From + Integer.toString (Longitud);
    Where =  PreparaCondicion (Claves);
    Consulta += " WHERE " + Where;
    Consulta += Order;

    return ObtenerLista (Consulta);
    }

  // Montar una condición para filtrar una consulta
  public String PreparaCondicion (ArrayList<String> Claves)
    {
    String Condicion="";
    boolean Primera = true;

    for ( String Clave : Claves )
      {
      if ( Primera )
        {
        Condicion = "clave='" + Clave + "'";
        Primera = false;
        }
      else
        { Condicion += " OR clave='" + Clave + "'"; }
      }

    // Devolvemos la condición
    return Condicion;
    }

  // Montar una lista de cadenas que cumplen la condición pedida
  public ArrayList<String> ObtenerLista (String Consulta)
    {
    ArrayList<String> Respuesta;
    Cursor Resultado;

    // Creamos la lista vacía
    Respuesta = new ArrayList<String>();

    // Realizamos la consulta
    Resultado = BaseDato.rawQuery (Consulta, null);

    // Vamos guardando cada registro obtenido
    Resultado.moveToFirst();
    while ( Resultado.isAfterLast() == false )
      {
      Respuesta.add (Resultado.getString(0));
      Resultado.moveToNext();
      }

    // Cerramos la consulta
    Resultado.close();

    // Devolvemos la lista creada
    return Respuesta;
    }
  }
