<?php

//--------------------------------------------------------------
// Fichero:  basedato.php
// Objetivo: Manejo de bases de datos
// Fecha:    D.25.5.2014
// Autor:    Pedro Reina <pedro@pedroreina.net>
//--------------------------------------------------------------

//----------------------------
// Variables globales
//----------------------------

$FicheroBaseDato = "encuesta.db";

//----------------------------
// Funciones que ofrecemos
//----------------------------

// Devuelve un único valor consultado a la base de datos
function BD_ConsultaValor ($Consulta)
  {
  // Abrimos una conexión a la base de datos
  $Conexion = BD_Conexion();

  // Ejecutamos la consulta
  $Resultado = $Conexion->query ($Consulta);

  // Nos quedamos el resultado
  $Respuesta = $Resultado->fetchColumn();

  // Cerramos la conexión
  $Conexion = null;

  // Devolvemos el resultado
  return $Respuesta;
  }

//--------------------------------------------------------------
// Devuelve un único registro consultado a la base de datos
function BD_ConsultaRegistro ($Consulta)
  {
  // Abrimos una conexión a la base de datos
  $Conexion = BD_Conexion();

  // Ejecutamos la consulta
  $Resultado = $Conexion->query ($Consulta);

  // Nos quedamos con el primer registro
  $Respuesta = $Resultado->fetch();

  // Cerramos la conexión
  $Conexion = null;

  // Devolvemos el resultado
  return $Respuesta;
  }

//--------------------------------------------------------------
// Devuelve una lista de registros consultados a la base de datos
function BD_ConsultaListaRegistro ($Consulta)
  {
  // Abrimos una conexión a la base de datos
  $Conexion = BD_Conexion();

  // Obtenemos el resultado  de la consulta
  $Resultado = $Conexion->query ($Consulta);

  // Nos quedamos con todos los registros
  $Respuesta = $Resultado->fetchAll();

  // Cerramos la conexión
  $Conexion = null;

  // Devolvemos la lista de registros
  return $Respuesta;
  }

//--------------------------------------------------------------
// Devuelve una lista de cadenas de texto como resultado de una consulta
function BD_ConsultaListaTexto ($Consulta)
  {
  // La lista que responderemos
  $Lista = array();

  // Abrimos una conexión a la base de datos
  $Conexion = BD_Conexion();

  // Vamos leyendo cada registro y añadiéndolo a la lista
  foreach ( $Conexion->query ($Consulta) as $Registro )
    { array_push ($Lista, $Registro[0]); }

  // Cerramos la conexión
  $Conexion = null;

  // Devolvemos el resultado
  return $Lista;
  }

//--------------------------------------------------------------
// Ejecuta una consulta y devuelve un texto de error
function BD_EjecutaConsulta ($Consulta)
  {
  // Abrimos una conexión a la base de datos
  $Conexion = BD_Conexion();

  // Ejecutamos la consulta
  $Resultado = $Conexion->query ($Consulta);

  // Vemos si hay error
  $Error = $Conexion->errorInfo();

  // La respuesta depende del error
  if ( $Error[0] )
    { $Respuesta = $Error[2]; }
  else
    { $Respuesta = ""; }

  // Cerramos la conexión
  $Conexion = null;

  // Devolvemos el error
  return $Respuesta;
  }

//--------------------------------------------------------------
// Ejecuta una consulta sobre una lista de cadenas
// y devuelve un texto de error
function BD_EjecutaConsultaListaTexto ($Consulta, $Lista)
  {
  // Abrimos una conexión a la base de datos
  $Conexion = BD_Conexion();

  // Preparamos la consulta
  $Sentencia = $Conexion->prepare ($Consulta);

  // Ejecutamos la consulta en cada cadena
  foreach ( $Lista as $Texto )
    { $Sentencia->execute (array($Texto)); }

  // Vemos si hay error
  $Error = $Conexion->errorInfo();

  // La respuesta depende del error
  if ( $Error[0] )
    { $Respuesta = $Error[2]; }
  else
    { $Respuesta = ""; }

  // Cerramos la conexión
  $Conexion = null;

  // Devolvemos el error
  return $Respuesta;
  }

//--------------------------------------------------------------
// Ejecuta una consulta sobre una lista de parámetros
// y devuelve un texto de error
function BD_EjecutaConsultaLista ($Consulta, $Lista)
  {
  // Abrimos una conexión a la base de datos
  $Conexion = BD_Conexion();

  // Preparamos la consulta
  $Sentencia = $Conexion->prepare ($Consulta);

  // Ejecutamos la consulta en cada registro
  foreach ( $Lista as $Dato )
    { $Sentencia->execute ($Dato); }

  // Vemos si hay error
  $Error = $Conexion->errorInfo();

  // La respuesta depende del error
  if ( $Error[0] )
    { $Respuesta = $Error[2]; }
  else
    { $Respuesta = ""; }

  // Cerramos la conexión
  $Conexion = null;

  // Devolvemos el error
  return $Respuesta;
  }

//----------------------------
// Funciones internas
//----------------------------

//--------------------------------------------------------------
// Atrapa las posibles excepciones
function BD_GestorExcepciones ($Excepcion)
  { echo "Excepción no capturada: " , $Excepcion->getMessage(), "\n"; }

//--------------------------------------------------------------
// Devuelve un manejador PDO para conectar con la base de datos
function BD_Conexion()
  {
  // El archivo con la base de datos
  global $FicheroBaseDato;

  // Nos preparamos para manejar una excepción si no se puede
  // realizar la conexión
  set_exception_handler('BD_GestorExcepciones');
  
  // Abrimos una conexión a la base de datos
  $Conexion = new PDO ("sqlite:$FicheroBaseDato");

  // Devolvemos el manejador
  return $Conexion;
  }

?>
