<?php

//--------------------------------------------------------------
// Fichero:  encuesta.php
// Objetivo: Rutinas PHP de apoyo de Encuesta
// Fecha:    D.25.5.2014
// Autor:    Pedro Reina <pedro@pedroreina.net>
//--------------------------------------------------------------

//----------------------------
// Archivos requeridos
//----------------------------

require "basedato.php";

//----------------------------
// Funciones
//----------------------------

//--------------------------------------------------------------
// Emite el DTD de la página web
function Encuesta_EmiteDTD()
  {
  print ("<!-- HTML 4.01 estricto -->\n");
  print ("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\"\n");
  print ("  \"http://www.w3.org/TR/html4/strict.dtd\">\n");
  }

//--------------------------------------------------------------
// Emite la cabecera de la página
function Encuesta_EmiteCabecera ($Titulo)
  {
  // El icono
  // http://icons.iconarchive.com/icons/deleket/sleek-xp-basic/128/Help-icon.png
  $Icono = "encuesta.png";

  // La hoja de estilos
  $Hoja = "encuesta.css";

  // Imprimimos la cabecera
  print ("<HEAD>\n");
  print ("<TITLE>$Titulo</TITLE>\n");
  print ("<META HTTP-EQUIV=\"Content-Type\" " .
         "CONTENT=\"text/html; charset=UTF-8\">\n");
  print ("<LINK REL=\"icon\" HREF=\"$Icono\" " .
         "TYPE=\"image/png\">\n");
  print ("<LINK REL=\"StyleSheet\" HREF=\"$Hoja\" TYPE=\"text/css\">\n");
  print ("</HEAD>\n");
  }

//--------------------------------------------------------------
// Lista los límites de fechas para hacer la encuesta
function Encuesta_ListaLimites()
  {
  $Consulta = "SELECT limite FROM plazo ORDER BY limite";
  return BD_ConsultaListaTexto ($Consulta);
  }

//--------------------------------------------------------------
// Devuelve la fecha de hoy con formato AAAA-MM-DD
function Encuesta_FechaHoy()
  { return date ("Y-m-d"); }

//--------------------------------------------------------------
// Dice si una clave es válida y aún no ha sido utilizada
function Encuesta_ClaveValidaNoUsada ($Clave)
  {
  $Consulta = "SELECT COUNT(*) FROM codigo " .
              "WHERE clave ='$Clave' AND usado=0";

  return BD_ConsultaValor ($Consulta);
  }

//--------------------------------------------------------------
// Devuelve una lista con las preguntas de la encuesta
function Encuesta_ListaPreguntas()
  {
  $Consulta = "SELECT rowid, texto FROM pregunta";
  return BD_ConsultaListaRegistro ($Consulta);
  }

//--------------------------------------------------------------
// Incrementa el número de respuestas de una puntuación de una pregunta
function Encuesta_Incrementa ($IdPregunta, $Puntuacion)
  {
  // Preparamos el nombre del campo que hay que incrementar
  $NombreCampo = "r" . $Puntuacion;

  // Aumentamos su valor en 1
  $Consulta = "UPDATE pregunta SET $NombreCampo=$NombreCampo+1 " .
              "WHERE rowid=$IdPregunta";
  BD_EjecutaConsulta ($Consulta);
  }

//--------------------------------------------------------------
// Anula un código de acceso para que no se pueda volver a usar
function Encuesta_Anula ($Clave)
  {
  $Consulta = "UPDATE codigo SET usado=1 WHERE clave='$Clave'";
  BD_EjecutaConsulta ($Consulta);
  }

?>
