<!--
**********************************************************************
* Fichero:  encuesta/index.php
* Objetivo: Página principal de Encuesta
* Fecha:    D.25.5.2014
* Autor:    Pedro Reina <pedro@pedroreina.net>
**********************************************************************
-->

<?php require "encuesta.php"; ?>

<?php Encuesta_EmiteDTD(); ?>

<HTML>

<?php Encuesta_EmiteCabecera ("Encuesta"); ?>

<BODY>

<!-- Presentación -->

<DIV CLASS="cuadro">

  <DIV CLASS="titulo1">Encuesta sobre el profesor Pedro Reina</DIV>

  <DIV CLASS="contenido">
    <?php Encuesta(); ?>
  </DIV>

</DIV>

<!-- Fin de página web -->

</BODY>

</HTML>

<?php

//--------------------------------------------------------------
// Función principal
function Encuesta()
  {
  if ( FechaValida() )
    {
    if ( ! isset ($_POST['clave']) )
      { PideCodigo(); }
    else
      {
      $Clave = $_POST['clave'];
      if ( ClaveValida ($Clave) )
        {
        if ( ! isset ($_POST['Enviar']) )
          { EscribeEncuesta ($Clave); }
        else
          { ProcesaEncuesta ($Clave); }
        }
      }
    }
  }

//--------------------------------------------------------------
// Dice si la fecha de hoy es válida para hacer la encuesta
function FechaValida()
  {
  $Limites = Encuesta_ListaLimites();
  $Hoy = Encuesta_FechaHoy();

  if ( $Limites[0] <= $Hoy AND $Hoy <= $Limites[1] )
    {  $Respuesta = TRUE; }

  else
    {
    print "El plazo para realizar la encuesta es desde " .
          $Limites[0] . " hasta " . $Limites[1] . " y hoy es " . $Hoy;
    $Respuesta = FALSE;
    }

  return $Respuesta;
  }

//--------------------------------------------------------------
// Imprime un formulario para pedir el código de acceso
function PideCodigo()
  {
  $YoMismo = $_SERVER['PHP_SELF'];

  print "<P CLASS=\"centrado\">Escribe el código de acceso: \n";
  print "<FORM ACTION=\"$YoMismo\" METHOD=\"POST\">\n";
  print "<P CLASS=\"centrado\">\n";
  print "<INPUT NAME=\"clave\" TYPE=\"password\" SIZE=\"6\">\n";
  print "<INPUT TYPE=\"submit\" NAME=\"Acceder\" VALUE=\" Acceder \">\n";
  print "</FORM>\n";
  }

//--------------------------------------------------------------
// Compueba si una clave es válida para entrar a la encuesta
function ClaveValida ($Clave)
  {
  if ( Encuesta_ClaveValidaNoUsada ($Clave) )
    { $Respuesta = TRUE; }

  else
    {
    print "La clave que has escrito no es válida o ya ha sido usada. ";
    print "<A HREF=\".\">Puedes volver a intentarlo</A>.";
    $Respuesta = FALSE;
    }

  return $Respuesta;
  }

//--------------------------------------------------------------
// Escribe el formulario con las preguntas de la encuesta
function EscribeEncuesta ($Clave)
  {
  $YoMismo = $_SERVER['PHP_SELF'];

  $Preguntas = Encuesta_ListaPreguntas();

  print "<P>Esta encuesta es anónima y su objetivo es evaluar el trabajo\n";
  print "del profesor. Por favor, contesta con sinceridad. Puedes\n";
  print "graduar cada respuesta desde el valor mínimo 1 hasta el\n";
  print "valor máximo 5.\n";
  print "<HR WIDTH=\"50%\">\n";

  print "<FORM ACTION=\"$YoMismo\" METHOD=\"POST\">\n";
  print "<INPUT TYPE=\"HIDDEN\" NAME=\"clave\" VALUE=\"$Clave\">\n";

  foreach ( $Preguntas as $Pregunta )
    {
    $Id = $Pregunta['rowid'];
    $Texto = $Pregunta['texto'];

    print "<P>$Texto\n";
    print "<TABLE>\n";

    print "<TR>\n";
    print "<TD ALIGN=\"CENTER\">1</TD>\n";
    print "<TD ALIGN=\"CENTER\">2</TD>\n";
    print "<TD ALIGN=\"CENTER\">3</TD>\n";
    print "<TD ALIGN=\"CENTER\">4</TD>\n";
    print "<TD ALIGN=\"CENTER\">5</TD>\n";
    print "</TR>\n";

    print "<TR>\n";
    print "<TD><INPUT TYPE=\"radio\" NAME=\"$Id\" value=\"1\"></TD>\n";
    print "<TD><INPUT TYPE=\"radio\" NAME=\"$Id\" value=\"2\"></TD>\n";
    print "<TD><INPUT TYPE=\"radio\" NAME=\"$Id\" value=\"3\"></TD>\n";
    print "<TD><INPUT TYPE=\"radio\" NAME=\"$Id\" value=\"4\"></TD>\n";
    print "<TD><INPUT TYPE=\"radio\" NAME=\"$Id\" value=\"5\"></TD>\n";
    print "</TR>\n";

    print "</TABLE>\n";
    print "<HR WIDTH=\"50%\">\n";
    }
  print "<P CLASS=\"centrado\">\n";
  print "<INPUT TYPE=\"submit\" NAME=\"Enviar\" ".
        "VALUE=\" Enviar respuestas\">\n";

  print "</FORM>\n";
  }

//--------------------------------------------------------------
// Recoge las respuestas del usuario
function ProcesaEncuesta ($Clave)
  {
  // Preparamos la lista de todas las preguntas
  $Preguntas = Encuesta_ListaPreguntas();

  // Para cada pregunta
  foreach ( $Preguntas as $Pregunta )
    {
    $Id = $Pregunta['rowid'];

    // Si han contestado a esta pregunta
    if ( isset ($_POST[$Id]) )
      {
      // Vemos qué calificación ha puesto el usuario
      $Puntuacion = $_POST[$Id];

      // Aumentamos el contador de esa pregunta y puntuación
      Encuesta_Incrementa ($Id, $Puntuacion);
      }
    }

  // Anulamos el código de acceso
  Encuesta_Anula ($Clave);

  // Informamos al usuario
  print "<P>Las respuestas han sido almacenadas. \n";
  print "Gracias por tu colaboración.\n";
  }

?>
