#!/usr/bin/python
# coding: latin-1

#--------------------------------------------------------------------
# Fichero:  prepara.py
# Objetivo: Preparar la base de datos para hacer una encuesta
# Autor:    Pedro Reina <pedro@pedroreina.net>
# Fecha:    S.15.10.2011
#--------------------------------------------------------------------

#------------------------------------------------
# Variables del programa
#------------------------------------------------

# El archivo con las preguntas. Codificacin UTF-8
Origen = "pregunta.txt"

# El archivo con la base de datos
Destino = "encuesta.db"

# El PDF para imprimir
Documento = "encuesta.pdf"

# Primera linea del documento
Titulo = "Encuesta sobre el profesor Pedro Reina"

# Web de la encuesta
Web = u"Direccin web: http://pedroreina.net/encuesta"

# Fecha de inicio del plazo para responder la encuesta
Inicio = "2012-02-18"

# Fecha de final del plazo para responder la encuesta
Final = "2012-02-19"

# Caracteres para generar los cdigos
Validos = "abcdefghjmnpqrstuyz23456789"

# Longitud de los cdigos
Longitud = 6

# Los mrgenes de la pgina, en centmetros
MargenIzquierdo = 2
MargenSuperior = 4

# La distancia entre lneas de texto, en centmetros
Interlineado = 1

#------------------------------------------------
# Mdulos necesarios
#------------------------------------------------

# Another Python SQLite Wrapper
import apsw

# Para leer la lnea de rdenes
import sys

# Para leer archivos en UTF-8
import codecs

# Para generar nmeros aleatorios
import random

# Creacin de PDF con ReportLab
from reportlab.pdfgen import canvas
from reportlab.lib.units import cm
from reportlab.lib.pagesizes import A4

#------------------------------------------------
# Variables globales
#------------------------------------------------

# La lista con los cdigos
ListaCodigos = []

#------------------------------------------------
# Funciones
#------------------------------------------------

def IntroduceFechas (Conexion):
  Cursor = Conexion.cursor()

  Consulta = "INSERT INTO plazo VALUES (\"" + Inicio + "\");"
  Cursor.execute (Consulta)

  Consulta = "INSERT INTO plazo VALUES (\"" + Final + "\");"
  Cursor.execute (Consulta)

#------------------------------------------------

def IntroducePreguntas (Conexion):
  Consulta = "INSERT INTO pregunta (texto) VALUES (:Enunciado)"
  Enunciado = ""

  Cursor = Conexion.cursor()
  Entrada = codecs.open (Origen, encoding='utf-8', mode='r')

  for Linea in Entrada:
    Linea = Linea.strip()
    if ( len (Linea) ):
      if ( len (Enunciado) ):
        Enunciado += " " + Linea
      else:
        Enunciado = Linea
    else:
      Cursor.execute (Consulta, locals())
      Enunciado = ""

  Cursor.execute (Consulta, locals())

#------------------------------------------------

def IntroduceCodigos (Conexion):
  Consulta = "INSERT INTO codigo (clave) VALUES (:Clave)"
  Obtenidos = 0

  Cursor = Conexion.cursor()

  # Generamos tantos cdigos como nos pidan
  while ( Obtenidos < Numero ):
    Clave = GeneraCodigo (Longitud)
    if ( not Clave in ListaCodigos ):
      ListaCodigos.append (Clave)
      Obtenidos += 1

  # Los almacenamos en la base de datos
  for Clave in ListaCodigos:
    Cursor.execute (Consulta, locals())

#------------------------------------------------

def GeneraCodigo (Longitud):
  Total = len(Validos)
  Secuencia = []

  # Copiamos los caracteres vlidos en una lista
  for i in range ( Total ):
    Secuencia.append (Validos[i])

  # Barajamos al azar la lista
  for i in range ( Total ):
    Aleatorio = random.randrange (Total)
    Tmp = Secuencia [Aleatorio]
    Secuencia [Aleatorio] = Secuencia [i]
    Secuencia [i] = Tmp

  # Creamos una cadena con los primeros caracteres de la lista
  Codigo = ""
  for i in range ( Longitud ):
    Codigo += Secuencia [i]

  # Ese es el cdigo que hemos generado
  return Codigo

#------------------------------------------------

def GeneraDocumento():
  # Preparamos el pdf
  Pdf = canvas.Canvas (Documento, pagesize=A4)
  Pdf.setAuthor ("Pedro Reina")
  Pdf.setTitle (u"Cdigos para encuesta")

  # Guardamos las dimensiones de la pgina
  Anchura, Altura = A4

  Registro = 1
  for Clave in ListaCodigos:
    if ( Registro % 2 == 1 ):
      Linea = Altura - MargenSuperior
    else:
      Linea = Altura / 2 - MargenSuperior
    Pdf.setFont ("Helvetica", 18)
    Pdf.drawString (MargenIzquierdo, Linea, Titulo)
    Linea -= Interlineado
    Pdf.setFont ("Times-Roman", 16)
    Texto = "Fecha de inicio: " + Inicio + u". Fecha de finalizacin: " + Final
    Pdf.drawString (MargenIzquierdo, Linea, Texto)
    Linea -= Interlineado
    Pdf.setFont ("Courier", 16)
    Pdf.drawString (MargenIzquierdo, Linea, Web)
    Linea -= Interlineado
    Pdf.setFont ("Times-Roman", 18)
    Pdf.drawString (MargenIzquierdo, Linea, u"Cdigo de acceso: " + Clave)
    if ( Registro % 2 == 0 ):
      Pdf.showPage()
    Registro += 1

  # Escribimos el PDF
  Pdf.save()

#------------------------------------------------
# El programa
#------------------------------------------------

# Si no nos pasan dos argumentos (nombre del programa y un
# nmero entero), nos quejamos y paramos
if len (sys.argv) != 2:
  sys.exit ("Hace falta el nmero de cdigos que generar")

# El nmero de cdigos que hay que generar lo tomamos de la
# lnea de rdenes
Numero = int (sys.argv[1])

# Informamos al usuario
print "Origen: " + Origen
print "Destino: " + Destino
print "Documento: " + Documento
print "Nmero de cdigos: " + str(Numero)
print "Preparando..."

# Abrimos conexin a la base de datos
Conexion = apsw.Connection (Destino)

# Los pasos individuales para crear la base de datos
IntroduceFechas (Conexion)
IntroducePreguntas (Conexion)
IntroduceCodigos (Conexion)

# Cerramos la conexin
Conexion.close (True)

# Conversin de medidas: todas las hemos pedido en cm
# pero se usan en puntos tipogrficos
MargenIzquierdo *= cm
MargenSuperior *= cm
Interlineado *= cm

# Generamos el PDF
GeneraDocumento()

# Informamos al usuario
print "Terminado."
