#!/usr/bin/perl

#--------------------------------------------------------------------
# Fichero:  mgp-castellanizar.pl
# Objetivo: Traducir pginas web generadas por MagicPoint
# Autor:    Pedro Reina <pedro@pedroreina.net>
# Fecha:    J.11.8.2005
#--------------------------------------------------------------------

#---------------------------------
# Declaracin de mdulos
#---------------------------------

use strict;                 # Comprobaciones estrictas

#---------------------------------
# Declaracin de variables
#---------------------------------

my $Narg = 0;               # Nmero de argumentos
my $Clave = "";             # Nombre en clave de la presentacin
my $NombreDirectorio = "";  # Nombre del directorio en que se trabaja
my $NumDiapos = 0;          # Nmero de diapositivas
my $Nombre = "";            # Nombre original de un archivo
my $Nuevo = "";             # Nuevo nombre de un archivo
my @Texto = ();             # Texto del fichero
my @Listado = ();           # Listado del directorio
my $Linea = "";             # Cada lnea del fichero
my %Traduccion = ();        # Traduccin de elementos
my $i = 0;                  # Un ndice
my $a = "";                 # Variable auxiliar
my $b = "";                 # Variable auxiliar

#---------------------------------
# Definicin de Traduccion
#---------------------------------

# Esto es un vector asociativo en el que se anotan por
# parejas los elementos originales y su reemplazamiento

%Traduccion =
  (
  '\[index\]'     , '[Indice]',
  '\[text page\]' , '[Texto]',
  'start'         , 'primera',
  'prev'          , 'anterior',
  'next'          , 'siguiente',
  'last'          , 'ltima',
  'Page'          , 'Diapositiva',
  'Generated by'  , 'Generado por',
  '\.idx'         , '-mini'
  );

#---------------------------------
# Programa principal
#---------------------------------

# Presentacin
print "\nCastellanizacin de archivos generados por MagicPoint";

# Si no hay argumentos, indicacin al usuario
$Narg = push(@ARGV);
if ( $Narg != 2 )
  { print "\nUso: mgp-castellanizar clave directorio"; }

else
  {
  # El primer argumento es la clave de la presentacin
  $Clave = $ARGV[0];
  print "\nClave: $Clave";

  # El segundo argumento es el directorio con los archivos
  $NombreDirectorio = $ARGV[1];
  print "\nDirectorio: $NombreDirectorio";

  # Calculamos cuntas diapos hay
    # Abrimos el directorio
    opendir (DIRECTORIO, $NombreDirectorio);

    # Leemos su contenido
    @Listado = readdir (DIRECTORIO);

    # Y cerramos el directorio
    closedir (DIRECTORIO);

    # En el directorio hay tres entradas que no corresponden
    # a diapos y cada diapo tiene asociados cuatro archivos
    $NumDiapos = (@Listado-3)/4;
  print "\nNmero de diapositivas: $NumDiapos";

  # Trabajamos con cada diapo
  print "\nCastellanizando:";
  for ( $i = 1 ; $i <= $NumDiapos ; ++$i )
    {
    # Informamos al usuario del avance
    print " $i";

    # El nombre original lo pone MagicPoint
    $Nombre = sprintf ("mgp%05d", $i);

    # El nuevo nombre lo pongo yo como la clave y dos dgitos
    $Nuevo = sprintf ($Clave . "%02d", $i);

    # Aadimos el directorio a los nombres
    $Nombre = $NombreDirectorio . "/" . $Nombre;
    $Nuevo = $NombreDirectorio . "/" . $Nuevo;

    # Cambiamos el nombre a todos los archivos de las diapos
    rename $Nombre . ".html"   , $Nuevo . ".html";
    rename $Nombre . ".txt"    , $Nuevo . ".txt";
    rename $Nombre . ".png"    , $Nuevo . ".png";
    rename $Nombre . ".idx.png", $Nuevo . "-mini.png";

    # Modificamos el archivo html
      # Lo abrimos, leemos y cerramos
      open (Entrada, $Nuevo . ".html");
      @Texto = <Entrada>;
      close (Entrada);

      # Estudiamos cada lnea
      foreach $Linea (@Texto)
        {
        # Traducciones directas
        while ( ($a, $b) = each (%Traduccion) )
          { $Linea =~ s/$a/$b/g; }
        $Linea =~ s/mgp000/$Clave/g;

        # Traducciones adaptadas
        $Linea =~ s/MagicPoint presentation foils/$Clave $i/g;
        }

      # Creamos el archivo html, lo escribimos y cerramos
      open (Salida, ">$Nuevo" . ".html");
      print Salida @Texto;
      close (Salida);
    }

  # Modificamos en archivo index.html
  print " index.html";

    # Lo abrimos, leemos y cerramos
    open (Entrada, $NombreDirectorio . "/index.html");
    @Texto = <Entrada>;
    close (Entrada);

    # Estudiamos cada lnea
    foreach $Linea (@Texto)
      {
      # Traducciones directas
      while ( ($a, $b) = each (%Traduccion) )
        { $Linea =~ s/$a/$b/g; }

      # Traducciones adaptadas
      $Linea =~ s/mgp000/$Clave/g;
      $Linea =~ s/MagicPoint presentation foils/$Clave/g;
      }

    # Creamos el archivo index.html, lo escribimos y cerramos
    open (Salida, ">$NombreDirectorio" . "/index.html");
    print Salida @Texto;
    close (Salida);
  }

# Despedida
print "\nTerminado\n";
