<?php

//---------------------------------------------------------
// Fichero:  ejemploming-swf.php
// Objetivo: Devolver un swf con un efecto de texto
// Fecha:    D.2.11.2003
// Autor:    Pedro Reina
//---------------------------------------------------------

// Elegimos el tipo de letra
$Fuente = new SWFFont("ejemploming.fdb");

// Comenzamos una pelcula
$Pelicula = new SWFMovie();
$Pelicula->setRate (24.0);
$Pelicula->setDimension (320, 240);

// Ponemos el color de fondo
$Pelicula->setBackground (0x10, 0x10, 0x10);

$InstanciaObjetoTexto = CreaInstanciaObjeto
	(0xFF, 0xFF, 0xFF, 0xFF, 900, 200, 150, 0.03, $Texto);

  for ( $i=0 ; $i<100 ; ++$i )
    {
    $InstanciaObjetoTexto = Transforma ($InstanciaObjetoTexto);
    $Pelicula->nextFrame();
    }

// Mandamos la pelcula al navegador
header('Content-type: application/x-shockwave-flash');
$Pelicula->output();

//---------------------------------------------------------

function CreaInstanciaObjeto ($r, $g, $b, $a,
           $rot, $x, $y, $scale, $string)
  {
  global $Fuente, $Pelicula;

  // Preparamos un objeto de texto
  $ObjetoTexto = new SWFText();
  $ObjetoTexto->setFont ($Fuente);
  $ObjetoTexto->setColor ($r, $g, $b, $a);
  $ObjetoTexto->setHeight (96);
  $ObjetoTexto->moveTo (-($ObjetoTexto->getWidth($string))/2,
                        $Fuente->getAscent()/2);
  $ObjetoTexto->addString ($string);

  // Aadimos el objeto a la pelcula y obtenemos una instancia
  $Instancia = $Pelicula->add ($ObjetoTexto);

  // Damos valores a la instancia
  $Instancia->x = $x;
  $Instancia->y = $y;
  $Instancia->rot = $rot;
  $Instancia->s = $scale;
  $Instancia->rotateTo ($rot);
  $Instancia->scale ($scale, $scale);

  // Devolvemos la instancia
  return ($Instancia);
  }

//---------------------------------------------------------

function Transforma ($Instancia)
  {
  $Instancia->rot = 19*$Instancia->rot/20;
  $Instancia->x = (19*$Instancia->x + 160)/20;
  $Instancia->y = (19*$Instancia->y + 120)/20;
  $Instancia->s = (19*$Instancia->s + 1.0)/20;

  $Instancia->rotateTo ($Instancia->rot);
  $Instancia->scaleTo ($Instancia->s, $Instancia->s);
  $Instancia->moveTo ($Instancia->x, $Instancia->y);

  return ($Instancia);
  }

php?>
