<!-- --------------------------------
 Fichero:  th/index.php
 Objetivo: Grficos de temperatura y humedad del servidor
 Fecha:    D.2.10.2011
 Autor:    Pedro Reina
--------------------------------- -->

<?php require "../prnet.php"; php?>
<?php require "th.php"; php?>

<?php EmiteDTD ("HTML401strict"); php?>

<HTML>

<HEAD>

<TITLE>Grficos de temperatura y humedad</TITLE>

<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">
<META HTTP-EQUIV="Refresh" CONTENT="300">
<LINK REL="icon" HREF="/imagen/prnet.png" TYPE="image/png">
<LINK REL="StyleSheet" HREF="../prnet.css" TYPE="text/css">

</HEAD>

<BODY>

<?php EmiteLogotipo(); php?>

<!-- Presentacin -->

<DIV CLASS="cuadro">

  <DIV CLASS="titulo1">Grficos de temperatura y humedad</DIV>

  <DIV CLASS="contenido">

  Utilizando una placa Arduino y un sensor, mantengo un historial de
  temperatura y humedad relativa en el armario ocupado por el servidor.

  </DIV>

</DIV>

<!-- ltimos datos -->

<DIV CLASS="cuadro">

  <DIV CLASS="titulo2">ltimos datos</DIV>

  <DIV CLASS="contenido">
    <?php EmiteMomento(); php?>
    <?php EmiteDatos(); php?>
  </DIV>

</DIV>

<!-- Grficos -->

<DIV CLASS="cuadro">

  <DIV CLASS="titulo2">Grficos</DIV>

  <DIV CLASS="contenido">
    <?php EmiteParametro ("temperatura"); php?>
    <?php EmiteParametro ("humedad"); php?>
  </DIV>

</DIV>

<!-- Notas tcnicas -->

<DIV CLASS="cuadro">

  <DIV CLASS="titulo3">Notas tcnicas</DIV>

  <DIV CLASS="contenido">
  
  <UL>

  <LI>El sensor de temperatura y humedad es un DHT11 conectado a una placa 
  <A HREF="http://arduino.cc/en/Main/ArduinoBoardUno">Arduino UNO</A>
  que se conecta por USB al servidor.

  <LI>El proceso para generar los grficos que utilizan esta
  pgina y sus pginas auxiliares consiste en que el
  programa <code>cron</code> lanza cada cinco minutos un
  pequeo programa en Perl que recopila los datos, los almacena
  y llama a <A HREF="http://oss.oetiker.ch/rrdtool/">RRDtool</A>
  para generar los grficos.
  
  <LI>Puedes descargar los archivos necesarios de
  <A HREF="th-1.0.zip">th-1.0.zip</A>; se entregan con
  licencia "Dominio pblico".

  </UL>

  </DIV>

</DIV>

<!-- Posibilidades para seguir -->

<DIV CLASS="cuadro">

  <DIV CLASS="titulo3">Posibilidades para seguir</DIV>

  <DIV CLASS="contenido">
    <A HREF="/">Volver a la pgina principal</A>
  </DIV>

</DIV>

<!-- Validadores -->

<?php EmiteValidadores(); php?>

<!-- Fin de pgina web -->

</BODY>

</HTML>

<!-- Programa PHP -->

<?php

function EmiteParametro ($Variable)
  {
  global $Nombre;

  $Texto = $Nombre["$Variable"];

  $CodigoHTML=<<<HTML

  <P CLASS="centrado">
  <A HREF="ver.php?v=$Variable">
  <IMG WIDTH="681" HEIGHT="$Altura" CLASS="sinborde"
       SRC="$Variable-diario.png" ALT="$Texto">
  </A>

HTML;
  print $CodigoHTML;
  }

function EmiteDatos()
  {
  $FicheroBaseDato = "th.db";
  $Consulta = "SELECT temperatura, humedad FROM th " .
              "WHERE rowid=(SELECT max(rowid) FROM th);";

  // Abrimos la base de datos
  $BaseDato = new PDO ("sqlite:$FicheroBaseDato"); 

  // Ejecutamos la consulta
  $Resultado = $BaseDato->query ($Consulta);

  // Obtenemos los datos
  $Datos = $Resultado->fetch (PDO::FETCH_ASSOC);
  $Temperatura = $Datos['temperatura'];
  $Humedad = $Datos['humedad'];

  // Cerramos la base de datos
  $BaseDato = null; 

  print "<P>Temperatura: <B>$Temperatura &#176;C</B>. ";
  print "Humedad relativa: <B>$Humedad%</B>";
  }

php?>
