//----------------------------------------------------------
// Archivo:  th
// Autor:    Pedro Reina
// Fecha:    D.25.9.2011
// Licencia: Dominio público
// Objetivo: Leer temperatura y humedad de un sensor DHT11
//----------------------------------------------------------

// Cableado
// Sensor - Arduino UNO
//   GND  -   GND   (negro)
//   VCC  -   5V    (rojo)
//   SIG  -   A0    (blanco)

// El pin de datos
#define DHT11_PIN 0      // ADC0

void setup()
  {
  // Para leer el DHT11
  DDRC |= _BV(DHT11_PIN);
  PORTC |= _BV(DHT11_PIN);

  // Iniciamos el pin digital como salida
  // El pin 13 tiene un LED conectado en muchas placas Arduino
  pinMode (13, OUTPUT);

  // Establecemos la velocidad de comunicación del puerto
  Serial.begin (9600);
  }

void loop()
  {
  // El dato que mandamos a Arduino
  int Dato = 0;

  // Vemos si han mandado algún dato
  if (Serial.available() > 0)
    {
    // Lo leemos
    Dato = Serial.read();

    // Imprimimos temperatura y humedad
    ImprimeTH();

    // Lanzamos destellos
    Destellos();
    }

  else
    { Intermitencia(); }
  }

void ImprimeTH()
  {
  byte dht11_dat[5];
  byte dht11_in;
  byte i;
  // start condition
  // 1. pull-down i/o pin from 18ms
  PORTC &= ~_BV(DHT11_PIN);
  delay (18);
  PORTC |= _BV(DHT11_PIN);
  delayMicroseconds (40);

  DDRC &= ~_BV(DHT11_PIN);
  delayMicroseconds(40);

  dht11_in = PINC & _BV(DHT11_PIN);

  if (dht11_in)
    {
    Serial.println ("DHT11 start condition 1 not met");
    return;
    }
  delayMicroseconds (80);

  dht11_in = PINC & _BV(DHT11_PIN);

  if ( !dht11_in )
    {
    Serial.println ("DHT11 start condition 2 not met");
    return;
    }
  delayMicroseconds (80);

  // now ready for data reception
  for (i=0; i<5; i++)
    dht11_dat[i] = read_dht11_dat();

  DDRC |= _BV(DHT11_PIN);
  PORTC |= _BV(DHT11_PIN);

  // check check_sum
  byte dht11_check_sum = dht11_dat[0]+dht11_dat[1]+dht11_dat[2]+dht11_dat[3];
  if ( dht11_dat[4] != dht11_check_sum )
    { Serial.println ("DHT11 checksum error"); }

  // Imprimimos la parte entera de la temperatura
  Serial.print (dht11_dat[2], DEC);

  // Imprimimos como separador un espacio
  Serial.print (" ");

  // Imprimimos la parte entera de la humedad
  Serial.println (dht11_dat[0], DEC);
  }

// Rutina para leer a bajo nivel el sensor
byte read_dht11_dat()
  {
  byte i = 0;
  byte result=0;
  for ( i=0 ; i<8 ; i++ )
    {
    while ( !(PINC & _BV(DHT11_PIN)) );  // wait for 50us
    delayMicroseconds(30);

    if ( PINC & _BV(DHT11_PIN) )
      { result |=(1<<(7-i)); }
    while ( (PINC & _BV(DHT11_PIN)) );  // wait '1' finish
    }
  return result;
  }

void Intermitencia()
  {
  // Encendemos el LED
  digitalWrite (13, HIGH);

  // Esperamos un segundo
  delay (1000);

  // Apagamos el LED
  digitalWrite (13, LOW);

  // Esperamos un segundo
  delay (1000);
  }

void Destellos()
  {
  for (int i=0; i<5; i++)
    {
    // Encendemos el LED
    digitalWrite (13, HIGH);

    // Esperamos una décima de segundo
    delay (100);

    // Apagamos el LED
    digitalWrite (13, LOW);

    // Esperamos una décima de segundo
    delay (100);
    }

  // Apagamos el LED
  digitalWrite (13, LOW);
  }
