<?php

//--------------------------------------------------------------
// Fichero:  admin.php
// Objetivo: Administrar el libro de visitas
// Fecha:    X.10.2.2016
// Autor:    Pedro Reina <pedro@pedroreina.net>
// Licencia: CC0 1.0 Universal
//           https://creativecommons.org/publicdomain/zero/1.0/
//--------------------------------------------------------------

//--------------------------------------------------------------
// Los archivos comunes del sistema
//--------------------------------------------------------------

require_once "visita.php";

//--------------------------------------------------------------
// La contraseña de administración
//--------------------------------------------------------------

require_once "contrasena.php";

//--------------------------------------------------------------
// Programa principal
//--------------------------------------------------------------

// Arrancamos el sistema de sesiones de PHP
session_start();

// Miramos si el usuario se ha identificado
if ( isset ($_SESSION['DentroVisitas']) )
  { $Dentro = $_SESSION['DentroVisitas']; }
else
  { $Dentro = FALSE; }

// Si no se ha identificado, pedimos o comprobamos la contraseña
if ( ! $Dentro )
  {
  // Si acabamos de cargar la página, hay que pedir la contraseña
  if ( ! isset ($_POST['cs']) )
    { MuestraFormulario(); }

  // Si ya han escrito la contraseña, la comprobamos
  else
    {
    // Si la contraseña es correcta, dejamos pasar
    if ( password_verify ($_POST['cs'], $Contrasena) )
      { $_SESSION['DentroVisitas'] = TRUE; }

    // Recargamos la página
    header ('location: ' . $_SERVER['PHP_SELF']);
    }
  }

// Si estamos dentro, vemos qué nos han pedido
else
  {
  if ( isset ($_GET['Orden']) )
    {
    $Orden = $_GET['Orden'];
    if ( strcmp ($Orden, "Terminar") == 0 )
      { TerminaAdministracion(); }
    if ( strcmp ($Orden, "Pendientes") == 0 )
      { MostrarPendientes(); }
    }

  if ( isset ($_POST['Administrar']) )
    { AdministrarPendientes(); }

  // Si hemos llegado hasta aquí, es la primera página que vemos
  // tras la autentificación
  if ( ! isset ($_GET['Orden']) and ! isset ($_POST['Administrar']) )
    { ComienzaPagina(); }

  // Mostramos opciones de administración
  MuestraOpciones();
  }

//--------------------------------------------------------------
// Funciones
//--------------------------------------------------------------

// ----------------------------------------------
// Rutina para comenzar la página
function ComienzaPagina()
  {
  global $Titulo;

  Tedecea_EmiteDTD ('HTML401strict');
  print "<HTML>\n";
  Tedecea_EmiteCabecera ($Titulo, 'UTF-8');
  print "<BODY>\n";
  Tedecea_EmiteLogotipo();
  print "<DIV CLASS=\"cuadro\">\n";
  print "  <DIV CLASS=\"titulo1\">Administración del libro de visitas</DIV>\n";
  print "</DIV>\n";
  }

// ----------------------------------------------
// Rutina para terminar la página
function TerminaPagina()
  {
  print "</BODY>\n";
  print "</HTML>\n";
  }

// ----------------------------------------------
// Rutina para mostrar el formulario de entrada
function MuestraFormulario()
  {
  $YoMismo = $_SERVER['PHP_SELF'];

  ComienzaPagina();

  // Emitimos el formulario
  print "<DIV CLASS=\"cuadro\">\n";
  print "  <DIV CLASS=\"titulo2\">Contraseña de administración</DIV>\n";
  print "  <DIV CLASS=\"contenido\">\n";
  print "<FORM ACTION=\"$YoMismo\" METHOD=\"POST\">\n";
  print "<P CLASS=\"centrado\">\n";
  print "<INPUT TYPE=\"PASSWORD\" NAME=\"cs\">\n";
  print "&nbsp;&nbsp;";
  print "<INPUT TYPE=\"SUBMIT\" NAME=\"Entrar\" VALUE=\" Entrar \">\n";
  print "</FORM>\n";
  print "  </DIV>\n";
  print "</DIV>\n";

  TerminaPagina();
  }

// ----------------------------------------------
// Rutina para mostrar las opciones de administración
function MuestraOpciones()
  {
  $YoMismo = $_SERVER['PHP_SELF'];

  // Emitimos las opciones
  print "<DIV CLASS=\"cuadro\">\n";
  print "  <DIV CLASS=\"titulo2\">Opciones de administración</DIV>\n";
  print "  <DIV CLASS=\"contenido\">\n";
  print "  <P CLASS=\"centrado\">\n";
  print "  <A HREF=\"$YoMismo?Orden=Pendientes\">Pendientes</A>\n";
  print "  <A HREF=\"$YoMismo\">Refrescar</A>\n";
  print "  <A HREF=\"$YoMismo?Orden=Terminar\">Terminar</A>\n";
  print "</DIV>\n";
  print "</DIV>\n";

  TerminaPagina();
  }

// ----------------------------------------------
// Rutina para terminar la administración
function TerminaAdministracion()
  {
  // Terminamos la sesión PHP
  $_SESSION = array();
  session_destroy();

  // Dirigimos el navegador a la página principal
  header ('location: ./');
  }

// ----------------------------------------------
// Muestra los comentarios pendientes de administración
function MostrarPendientes()
  {
  global $Archivo, $Color;
  $YoMismo = $_SERVER['PHP_SELF'];

  // Hacemos la consulta del total de comentarios sin administrar
  $Consulta = "SELECT COUNT(num) FROM visita WHERE num=0";
  $Total = TedeceaBD_ConsultaValor ($Archivo, $Consulta);

  if ( $Total == 0 )
    { $Mensaje = 'El libro no tiene comentarios sin administrar'; }
  else if ( $Total == 1 )
    { $Mensaje = 'El libro tiene <B>un</B> comentario sin administrar'; }
  else
    { $Mensaje = "El libro tiene <B>$Total</B> comentarios sin administrar"; }

  ComienzaPagina();
  print "<DIV CLASS=\"cuadro\">\n";
  print "  <DIV CLASS=\"titulo2\">Comentarios sin administrar</DIV>\n";
  print "  <DIV CLASS=\"contenido\">\n";
  print "$Mensaje\n";
  print "</DIV>\n";
  print "</DIV>\n";

  if ( $Total )
    {
    // Averiguamos qué registros hay que administrar
    $Consulta = "SELECT ROWID,* FROM visita WHERE num=0";
    $ListaPendientes = TedeceaBD_ConsultaListaRegistro ($Archivo, $Consulta);

    // Comenzamos el formulario de administración
    print "<FORM ACTION=\"$YoMismo\" METHOD=\"POST\">\n";

    // Comenzamos la lista de RowID de los registros sin administrar
    $Lista = "";

    // Imprimimos los registros obtenidos
    foreach ( $ListaPendientes as $Registro )
      {
      // Asignamos los campos a variables, por comodidad
      $RowID = $Registro[0];
      $Momento = $Registro[2];
      $Nombre = $Registro[3];
      $Comentario = $Registro[4];
      $IP = $Registro[5];

      // Al guardar el comentario pusimos <BR> como fin de párrafo
      $Nombre = trim (str_replace ('<BR>', "\n", $Nombre));
      $Comentario = trim (str_replace ('<BR>', "\n", $Comentario));

      // Guardamos el RowID en la lista
      $Lista .= $RowID . "-";

      // Mostramos el registro en una tabla
      // con casillas de verificación para administración
      $CodigoHTML=<<<HTML
      <P>
      <TABLE WIDTH="100%" BORDER="1" CELLPADDING="10" CELLSPACING="0">
      <TR BGCOLOR="$Color">
      <TD WIDTH="10%" ALIGN="LEFT">$IP</TD>
      <TD WIDTH="60%" ALIGN="CENTER"><B>$Nombre</B></TD>
      <TD WIDTH="30%" ALIGN="RIGHT">$Momento UTC</TD>
      <TR><TD COLSPAN="3">$Comentario</TD></TR>
      <TR><TD COLSPAN="3">
          <INPUT TYPE="RADIO" NAME="C$RowID" VALUE="Esperar">Esperar
          <INPUT TYPE="RADIO" NAME="C$RowID" VALUE="Rechazar" CHECKED>Rechazar
          <INPUT TYPE="RADIO" NAME="C$RowID" VALUE="Aceptar">Aceptar
      </TD></TR>
      </TABLE>
HTML;
      print $CodigoHTML;
      }

      // Eliminamos el último guión de la lista
      $Lista = substr($Lista, 0, -1);

      // Con una entrada oculta pasamos la lista de RowID de los
      // registros que hay que tratar
      print "<INPUT TYPE=\"HIDDEN\" NAME=\"Lista\" VALUE=\"$Lista\">\n";

      print "<DIV CLASS=\"contenido\">\n";
      print "<INPUT TYPE=\"SUBMIT\" NAME=\"Administrar\" " .
            "VALUE=\"Administrar\">\n";
      print "</FORM>\n";
      print "</DIV>\n";
    }

  TerminaPagina();
  }

// ----------------------------------------------
// Administra los comentarios pendientes de administración
function AdministrarPendientes()
  {
  global $Archivo, $CorreoInvitado, $URLver;

  ComienzaPagina();

  // Recogemos la lista de comentarios
  $Lista = $_POST['Lista'];

  // Extraemos los RowID de los registros que hay que administrar
  $Listado = explode ("-", $Lista);
  $Total = count($Listado);

  // Comentarios aceptados
  $Aceptado = '';

  // Comenzamos a preparar el mensaje
  if ( $Total == 1 )
    { $Mensaje = "Se ha administrado <B>un</B> comentario: "; }
  else
    { $Mensaje = "Se han administrado <B>$Total</B> comentarios: "; }

  // Tratamos cada mensaje de la lista
  foreach ( $Listado as $RowID )
    {
    // Vemos qué hay que hacer con él
    $Accion = $_POST["C$RowID"];

    // Informamos al usuario de lo que hacemos
    $Mensaje .= "$Accion ";

    // Si nos piden algo diferente a "Esperar"
    if ( strcmp ($Accion, "Esperar") != 0 )
      {
      // Si nos piden "Rechazar"
      if ( strcmp ($Accion, "Rechazar") == 0 )
        {
        // Ponemos como nuevo num uno menos que el mínimo
        $Consulta = "SELECT MIN(num) FROM visita";
        $Nuevo = TedeceaBD_ConsultaValor($Archivo, $Consulta) - 1;
        }

      // Si nos piden "Aceptar"
      if ( strcmp ($Accion, "Aceptar") == 0 )
        {
        // Ponemos como nuevo num uno más que el máximo
        $Consulta = "SELECT MAX(num) FROM visita";
        $Nuevo = TedeceaBD_ConsultaValor($Archivo, $Consulta) + 1;

        // Anotamos que se ha aceptado
        $Aceptado .= "$Nuevo ";
        }

      // Cambiamos el num del registro
      $Consulta = "UPDATE visita SET num=$Nuevo WHERE ROWID=$RowID";
      $Respuesta = TedeceaBD_EjecutaConsulta($Archivo, $Consulta) ;
      }
    }

  // Si se ha aceptado algún comentario, informamos al amigo
  if ( $Aceptado )
    {
    $Cabeceras = "Content-Type: text/plain; charset=UTF-8\r\n";
    $Cabeceras .= "X-Mailer: PHP";
    mail ($CorreoInvitado, "Comentario en el libro de visitas",
          "Número: $Aceptado\nPara verlo: $URLver", $Cabeceras);
    }

  print "<DIV CLASS=\"cuadro\">\n";
  print "<DIV CLASS=\"titulo2\">Resultado</DIV>\n";
  print "<DIV CLASS=\"contenido\">\n";
  print "$Mensaje\n";
  print "</DIV>\n";
  print "</DIV>\n";

  TerminaPagina();
  }

?>
