#!/usr/bin/php
<?php
//--------------------------------------------------------------
// Fichero:  generaContrasena.php
// Objetivo: Generar el hash de la contraseña de administración
// Autor:    Pedro Reina <pedro@pedroreina.net>
// Fecha:    S.1.3.2014
// Licencia: CC0 1.0 Universal
//           https://creativecommons.org/publicdomain/zero/1.0/
//--------------------------------------------------------------

// La librería que hace los hash de las contraseñas
require "password.php";

// Comprobamos que nos mandan un dato
if ( count ($argv) != 2 )
  { echo "Uso: " . $argv[0] . " contraseña\n"; }

else
  {
  // Tomamos el dato de la línea de órdenes
  $Contrasena = $argv[1];

  // Calculamos el hash
  $Hash = password_hash ($Contrasena, PASSWORD_BCRYPT);

  // Lo imprimimos
  print "$Hash\n";
  }
?>
