<!--
**********************************************************************
* Fichero:  visitas/index.php
* Objetivo: Página principal del libro de visitas
* Fecha:    X.10.2.2016
* Autor:    Pedro Reina <pedro@pedroreina.net>
* Licencia: CC0 1.0 Universal
*           https://creativecommons.org/publicdomain/zero/1.0/
**********************************************************************
-->

<?php
  require 'visita.php';
  Tedecea_EmiteDTD ('HTML401strict');
?>

<HTML>

<?php Tedecea_EmiteCabecera ($Titulo, 'UTF-8'); ?>

<BODY>

<?php Tedecea_EmiteLogotipo(); ?>

<!-- Presentación -->

<DIV CLASS="cuadro">

  <DIV CLASS="titulo1"><?=$Titulo?></DIV>

  <DIV CLASS="contenido">

  Este es el libro de visitas de mi sede web. Puedes escribir
  tus comentarios en el idioma que te resulte más cómodo.

  </DIV>

</DIV>

<!-- Acciones -->

<DIV CLASS="cuadro">

  <DIV CLASS="titulo2">Acciones</DIV>

  <DIV CLASS="contenido">
    <UL>
      <LI><A HREF="ver.php">Leer los comentarios del libro</A>
      <LI><A HREF="nuevo.php">Escribir tu comentario</A>
    </UL>
  </DIV>

</DIV>

<!-- Notas técnicas -->

<DIV CLASS="cuadro">

  <DIV CLASS="titulo3">Notas técnicas</DIV>

  <DIV CLASS="contenido">

  <UL>
  <LI>El libro de visitas está escrito en PHP y usa una base de
  datos SQLite.
  <LI>El código PHP es original y lo distribuyo con licencia
  <A HREF="https://creativecommons.org/publicdomain/zero/1.0/">CC0
  1.0 Universal</A>.
  <LI>Puedes descargar el código en
  <A HREF="visitas-3.0.zip">visitas-3.0.zip</A>.
  <LI>Para garantizar el correcto funcionamiento con diferentes versiones
  de PHP del método de cifrado bcrypt se ha usado
  <A HREF="https://github.com/ircmaxell/password_compat">una librería</A>
  de <A HREF="http://blog.ircmaxell.com/">Anthony Ferrara</A> con licencia MIT.
  </UL>

  </DIV>

</DIV>

<!-- Posibilidades para seguir -->

<?php Tedecea_Seguir(); ?>

<!-- Validadores -->

<?php Tedecea_EmiteValidadores(); ?>

<!-- Fin de página web -->

</BODY>

</HTML>
