#!/usr/bin/python
# coding: latin-1

#--------------------------------------------------------------------
# Fichero:  rechaza-comentario.py
# Objetivo: Rechazar un comentario que ya ha sido aceptado
# Autor:    Pedro Reina <pedro@pedroreina.net>
# Fecha:    L.10.8.2009
#--------------------------------------------------------------------

#------------------------------------------------
# Mdulos necesarios
#------------------------------------------------

# Another Python SQLite Wrapper
import apsw

# Para leer la lnea de rdenes
import sys

#------------------------------------------------
# El programa
#------------------------------------------------

# Vemos cuntos parmetros nos han pasado
TotalParametro = len (sys.argv)

# Si no hay suficientes, protestamos
if ( TotalParametro < 3 ):
  print "Uso: rechaza-comentario.py basedatos num {num...}"
  
# Si podemos, trabajamos
else:
  # El primer parmetro es la base de datos
  BaseDatos = sys.argv[1]
  print "Base de datos: %s" % (BaseDatos)

  # El resto de los parmetros son la lista de comentarios para rechazar
  # Formamos con ellos una lista de enteros
  ListaRechazar = []
  for i in range (TotalParametro):
    if ( i>1 ): ListaRechazar.append (int(sys.argv[i]))
    
  # Ordenamos la lista...
  ListaRechazar.sort()

  # ... en orden inverso
  ListaRechazar.reverse()

  # Se la mostramos al usuario
  print "Comentarios para rechazar:",
  for Num in ListaRechazar: print Num,
  print

  # Informamos al usuario
  print "Rechazando..."

  # Abrimos una conexin a la base de datos
  Conexion = apsw.Connection (BaseDatos)

  # Creamos un cursor para dialogar con la conexin
  Cursor = Conexion.cursor()

  # Averiguamos el menor nmero de la base de datos
  for Resultado in Cursor.execute ("SELECT MIN(num) FROM visita"):
    Minimo = Resultado[0]

  # Si no se ha rechazado nunca ningn comentario,
  # el mnimo podra no ser negativo
  if ( Minimo >= 0 ): Minimo = -1

  # Averiguamos el mayor nmero de la base de datos
  for Resultado in Cursor.execute ("SELECT MAX(num) FROM visita"):
    Maximo = Resultado[0]

  # Trabajamos con cada uno de los comentarios de la lista
  for Num in ListaRechazar:

    # Si el nmero es negativo, ya estaba rechazado
    if ( Num < 0 ):
      print "%d --> ya est rechazado" % (Num)

    # Si el nmero que nos piden es mayor que el mximo, es que no existe
    elif ( Num > Maximo ):
      print "%d --> no existe" % (Num)

    # Solo borramos los que estn entre 1 y Maximo
    else:

      # El nuevo nmero que le vamos a asignar al comentario
      Minimo -= 1

      # Informamos al usuario
      print "%d --> %d" % (Num, Minimo)

      # Cambiamos el num al comentario que hay que borrar
      Orden = "UPDATE visita SET num=%d WHERE num=%d" % (Minimo, Num)
      Cursor.execute (Orden)
      
      # Restamos 1 a los num de los comentarios con num mayor que el borrado
      Orden = "UPDATE visita SET num=num-1 WHERE num>%d" % (Num)
      Cursor.execute (Orden)
  
  # Cerramos la conexin
  Conexion.close (True)

  # Informamos al usuario
  print "Terminado."