<?php

//--------------------------------------------------------------
// Fichero:  tedecea.php
// Objetivo: Rutinas PHP de apoyo de pedroreina.net
// Autor:    Pedro Reina <pedro@pedroreina.net>
// Fecha:    J.28.1.2016
//--------------------------------------------------------------

//--------------------------------------------------------------
// Emite el DTD de la página
function Tedecea_EmiteDTD ($Descripcion)
  {
  switch ($Descripcion)
    {
    case 'HTML401strict':
      print "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\"\n";
      print "  \"http://www.w3.org/TR/html4/strict.dtd\">\n";
      break;
    case 'HTML401Transitional':
      print "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"\n";
      print "  \"http://www.w3.org/TR/html4/loose.dtd\">\n";
      break;
    }
  }

//--------------------------------------------------------------
// Emite la cabecera de la página
function Tedecea_EmiteCabecera ($Titulo, $Codificacion)
  {
  $Icono = "/imagen/prnet.png";
  $Hoja = "/tedecea.css";

  print "<HEAD>\n";
  print "<TITLE>$Titulo</TITLE>\n";
  print "<META HTTP-EQUIV=\"Content-Type\" " .
        "CONTENT=\"text/html; charset=$Codificacion\">\n";
  print "<LINK REL=\"icon\" HREF=\"$Icono\" TYPE=\"image/png\">\n";
  print "<LINK REL=\"StyleSheet\" HREF=\"$Hoja\" TYPE=\"text/css\">\n";

  // Si nos pasan parámetros extra
  if ( func_num_args() > 2 )
    {
    // Examinamos cada argumento
    for ($i = 2 ; $i < func_num_args() ; $i++)
      {
      $Argumento = func_get_arg($i);

      // En algún programa nos mandan argumentos vacíos
      if ( $Argumento != "" )
        {
        // Averiguamos la extensión
        preg_match ("#^.*\.([a-zA-Z0-9]+)#", $Argumento, $Encontrado);
        $Ext = $Encontrado[1];

        // Si la extensión es css, es una hoja de estilos
        if ( $Ext == "css" )
          {
          print ("<LINK REL=\"StyleSheet\" HREF=\"$Argumento\" ");
          print ("TYPE=\"text/css\">\n");
          }

        // Si la extensión es js, es un JavaScript
        else if ( $Ext == "js" )
          {
          print ("<SCRIPT TYPE=\"text/javascript\" SRC=\"$Argumento\">");
          print ("</SCRIPT>\n");
          }

        // Si no es ninguna de esas cosas, la enviamos tal cual
        else
          { print $Argumento . "\n"; }
        }
      }
    }

  print "</HEAD>\n";
  }

//--------------------------------------------------------------
// Emite el logotipo
function Tedecea_EmiteLogotipo()
  {
  $Logotipo = '/imagen/pedroreinanet.png';

  print "<P CLASS=\"centrado\">\n";
  print "<A HREF=\"/\">\n";
  print "<IMG SRC=\"$Logotipo\" ALT=\"pedroreina.net\" " .
        "CLASS=\"sinborde\" WIDTH=\"328\" HEIGHT=\"50\">\n";
  print "</A></P>\n";
  }

//--------------------------------------------------------------
// Emite un enlace en un <LI>
function Tedecea_EmiteEnlace ($Texto, $Enlace)
  {
  print "<LI><A HREF=\"$Enlace\">&nbsp;&gt;&gt;&gt;&nbsp;</A>\n";
  print "$Texto\n";
  }

//--------------------------------------------------------------
// Escribe posibilidades para seguir
function Tedecea_Seguir()
  {
  // Vemos si nos han mandado algún argumento
  if ( func_num_args() )
    {
    $Bolo = '<LI>';
    $VariasOpciones = TRUE;
    }
  else
    {
    $Bolo = '';
    $VariasOpciones = FALSE;
    }

  print "<DIV CLASS=\"cuadro\">\n";
  print "<DIV CLASS=\"titulo3\">Posibilidades para seguir</DIV>\n";
  print "<DIV CLASS=\"contenido\">\n";
  if ( $VariasOpciones )
    { 
    print "<UL>\n"; 
    // Cada argumento es una opción con texto y enlace
    for ( $i = 0 ; $i < func_num_args() ; $i++ )
      {
      $Texto = func_get_arg($i)[0];
      $Enlace = func_get_arg($i)[1];
      print "$Bolo<A HREF=\"$Enlace\">$Texto</A>\n";
      }
    }
  print "$Bolo<A HREF=\"/\">Volver a la página principal</A>\n";
  if ( $VariasOpciones )
    { print "</UL>\n"; }
  print "</DIV>\n";
  print "</DIV>\n";
  }

//--------------------------------------------------------------
// Emite iconos publicitarios
function Tedecea_EmitePublicidad()
  {
  $CodigoHTML=<<<HTML

  <DIV CLASS="contenido">

  <TABLE WIDTH="100%">
  <TR>

  <TD ALIGN="LEFT">
  <A HREF="http://www.gnu.org/">
    <IMG SRC="imagen/gnu.png" TITLE="Sistema GNU"
     ALT="GNU" CLASS="sinborde" WIDTH="41" HEIGHT="40">
  </A>
  </TD>

  <TD ALIGN="CENTER">
  <A HREF="http://www.linux.org/">
    <IMG SRC="imagen/linux.png" TITLE="Núcleo Linux"
     ALT="Linux" CLASS="sinborde" WIDTH="34" HEIGHT="40">
  </A>
  </TD>

  <TD ALIGN="CENTER">
  <A HREF="http://www.debian.org/">
    <IMG SRC="imagen/debian.png" TITLE="Sistema operativo Debian"
     ALT="Debian" CLASS="sinborde" WIDTH="32" HEIGHT="40">
  </A>
  </TD>

  <TD ALIGN="CENTER">
  <A HREF="http://httpd.apache.org/">
    <IMG SRC="imagen/apache.png" TITLE="Servidor web Apache"
     ALT="Apache" CLASS="sinborde" WIDTH="91" HEIGHT="27">
  </A>
  </TD>

  <TD ALIGN="CENTER">
  <A HREF="http://www.php.net/">
    <IMG SRC="imagen/php.png" TITLE="Programación web PHP"
     ALT="PHP" CLASS="sinborde" WIDTH="75" HEIGHT="40">
  </A>
  </TD>

  <TD ALIGN="CENTER">
  <A HREF="http://www.sqlite.org/">
    <IMG SRC="imagen/sqlite.png" TITLE="Gestor de bases de datos SQLite"
    ALT="SQLite" CLASS="sinborde" WIDTH="" HEIGHT="36">
  </A>
  </TD>

  <TD ALIGN="CENTER">
  <A HREF="http://www.gimp.org/">
    <IMG SRC="imagen/gimp.png" TITLE="Editor de imágenes The GIMP"
     ALT="GIMP" CLASS="sinborde" WIDTH="47" HEIGHT="33">
  </A>
  </TD>

  <TD ALIGN="RIGHT">
  <A HREF="http://apostrophiclab.pedroreina.net/">
    <IMG SRC="imagen/thelab.png" TITLE="Tipografía Apostrophic Laboratories"
     ALT="Apostrophic Lab" CLASS="sinborde" WIDTH="39" HEIGHT="40">
  </A>
  </TD>

  </TR>
  </TABLE>

  </DIV>

HTML;

  print $CodigoHTML;
  }

//--------------------------------------------------------------
// Emite los iconos para validar la página
function Tedecea_EmiteValidadores()
  {
  $CodigoHTML=<<<HTML

  <DIV CLASS="contenido">

  <A HREF="http://www.anybrowser.org/campaign/">
  <IMG SRC="/imagen/anybrowser.png" CLASS="sinborde"
       ALT="Mejor visto con cualquier navegador"
       TITLE="Mejor visto con cualquier navegador"
       HEIGHT="31" WIDTH="88">
  </A>

  <A HREF="http://validator.w3.org/check/referer">
  <IMG SRC="/imagen/valido-html401.png" CLASS="sinborde"
       ALT="HTML 4.01 válido" TITLE="HTML 4.01 válido"
       HEIGHT="31" WIDTH="88">
  </A>

  <A HREF="http://jigsaw.w3.org/css-validator/">
  <IMG SRC="/imagen/valido-css.png" CLASS="sinborde"
       ALT="CSS válido" TITLE="CSS válido"
       HEIGHT="31" WIDTH="88">
  </A>

  </DIV>

HTML;

  print $CodigoHTML;
  }

//--------------------------------------------------------------
// Emite una o más imágenes
function Tedecea_EmiteImagen ($Clave)
  {
  // Las imágenes van en su propio párrafo, centrado
  print "<P CLASS=\"centrado\">\n";

  // Al menos nos mandan una clave
  Tedecea_EmiteUnaImagen ($Clave);

  // Si además nos pasan más parámetros
  if ( func_num_args() > 1 )
    {
    // Examinamos cada argumento
    for ($i = 1 ; $i < func_num_args() ; $i++)
      {
      // Nos separamos de la imagen de la izquierda
      print "<SPAN style=\"display: inline-block; width:10px;\"></SPAN>\n";
      // Lo enviamos
      $Argumento = func_get_arg($i);
      Tedecea_EmiteUnaImagen ($Argumento);
      }
    }
  }

//--------------------------------------------------------------
// Emite una imagen
function Tedecea_EmiteUnaImagen ($Clave)
  {
  // Hay dos imágenes con la misma clave
  $Pequena = $Clave . ".jpeg";
  $Grande = $Clave . ".jpg";

  // Encontramos las dimensiones de la imagen pequeña, si existe
  $TamanoImagenPequena = @GetImageSize ($Pequena);

  if ( $TamanoImagenPequena )
    {
    $DimensionesImagen = $TamanoImagenPequena[3];

    // Encontramos las dimensiones de la imagen grande, si existe
    $TamanoImagenGrande = @GetImageSize ($Grande);

    if ( $TamanoImagenGrande )
      {
      $Anchura = $TamanoImagenGrande[0];
      $Altura = $TamanoImagenGrande[1];

      // Encontramos el espacio que ocupa la imagen grande
      $Espacio = round (filesize ($Grande) / 1024);

      // Preparamos el globo amarillo
      $Tip = $Grande . ": " . $Anchura . "&times;" . $Altura . ", " .
             $Espacio . " kB";
      }

    print "<A HREF=\"$Grande\">\n";
    print "<IMG SRC=\"$Pequena\" CLASS=\"sinborde\" " .
          "$DimensionesImagen ALT=\"$Pequena\" TITLE=\"$Tip\">\n";
    print "</A>\n";
    }
  }

//--------------------------------------------------------------
// Lee el archivo XML con una lista de datos y la devuelve como
// un array con sus datos
function Tedecea_LeeArchivoXML ($ArchivoXML)
  {
  // Una lista vacía para ir rellenándola
  $Lista = array();

  // Leemos el archivo XML
  $EstructuraXML = simplexml_load_file ($ArchivoXML);

  // Vamos estudiando cada elemento
  foreach ( $EstructuraXML->children() as $ElementoXML )
    {
    // Un array vacío para ir rellenándolo con los datos de un vídeo
    $ElementoArray = array();

    // Recorremos todas las entradas del elemento XML y las pasamos al array
    foreach ( $ElementoXML as $Clave => $Valor) 
      { $ElementoArray[$Clave] = $Valor; }

    // Anotamos el elemento en la lista
    $Lista[] = $ElementoArray;
    }

  // Devolvemos el array
  return ($Lista);
  }

//--------------------------------------------------------------
// Da un listado de nombres de archivos sin extensión
function Tedecea_Listado ($Patron)
  {
  $Listado = glob ($Patron);
  foreach ( $Listado as $i => $Archivo )
    { $Listado[$i] = pathinfo($Archivo)['filename']; }
  return $Listado;
  }

//--------------------------------------------------------------
// Función que devuelve la IP de quien hace la consulta
function Tedecea_AveriguaIP()
  {
  $Respuesta = "";

  if ( getenv ('HTTP_X_FORWARDED_FOR') )
    { $Respuesta = $_SERVER['HTTP_X_FORWARDED_FOR']; }
  else
    { $Respuesta = $_SERVER['REMOTE_ADDR']; }

  return ( $Respuesta );
  }

?>
