<!--
**********************************************************************
* Fichero:  ver.php
* Objetivo: Ver los comentarios del libro de visitas
* Fecha:    S.6.2.2016
* Autor:    Pedro Reina <pedro@pedroreina.net>
* Licencia: CC0 1.0 Universal
*           https://creativecommons.org/publicdomain/zero/1.0/
**********************************************************************
-->

<?php
  require 'visita.php';
  Tedecea_EmiteDTD ('HTML401strict');
?>

<HTML>

<?php Tedecea_EmiteCabecera ($Titulo, 'UTF-8'); ?>

<BODY>

<?php Tedecea_EmiteLogotipo(); ?>

<!-- Presentación -->

<DIV CLASS="cuadro">

  <DIV CLASS="titulo1">Comentarios del libro de visitas</DIV>

  <DIV CLASS="contenido">

    <?php EmitePresentacion(); ?>

  </DIV>

</DIV>

<!-- Comentarios -->

<?php MuestraComentarios(); ?>

<!-- Segunda botonera -->

<?php SegundaBotonera(); ?>

<!-- Posibilidades para seguir -->

<?php
  $OpcionLibro = array('Volver a la página principal del libro', '.');
  $OpcionEscribir = array('Escribir un comentario', 'nuevo.php');
  Tedecea_Seguir($OpcionLibro, $OpcionEscribir);
?>

<!-- Validadores -->

<?php Tedecea_EmiteValidadores(); ?>

<!-- Fin de página web -->

</BODY>

</HTML>

<!-- Programa PHP -->

<?php

function EmitePresentacion()
  {
  global $min, $max, $Archivo, $PasoValido, $TotalComentarios, $Paso;

  // Si nos dan un Paso, lo comprobamos; si no, lo ponemos
  $Paso = isset ($_POST['Paso']) ? $_POST['Paso'] : $PasoValido[0];
  $Paso = CompruebaPaso ($Paso);

  // Hacemos la consulta del total de registros que hay
  $Consulta = "SELECT MAX(num) FROM visita";
  $TotalComentarios = TedeceaBD_ConsultaValor ($Archivo, $Consulta);

  print "El libro tiene <B>$TotalComentarios</B> comentarios. ";
  print "Elige los que quieres ver:<P>\n";

  // Si nos piden un rango de comentarios
  $Rango = isset ($_POST['Rango']) ? $_POST['Rango'] : '';
  if ( $Rango )
    {
    // Calculamos los valores mínimo y máximo
    list ($min, $max) = sscanf ($Rango, "%d-%d");
    }

  // Si no lo piden, lo ponemos nosotros
  else
    {
    $min = $TotalComentarios;
    $max = $TotalComentarios;
    }

  // Pero si nos mandan ir a un comentario, cambiamos el rango
  $Comentario = isset ($_POST['Comentario']) ? $_POST['Comentario'] : '';
  if ( $Comentario )
    {
    if ( $Comentario>0 && $Comentario <= $TotalComentarios )
      {
      $min = $Comentario;
      $max = $Comentario;
      }
    }

  MuestraBotones();
  }

// ---------------------------------

function SegundaBotonera()
  {
  global $min, $max, $Paso, $TotalComentarios;

  // Repetimos los botones de navegación si la lista es larga
  if ( $max-$min > 2 )
    {
    print "<DIV CLASS=\"cuadro\">\n";
    print "<DIV CLASS=\"titulo2\">Leer otros comentarios</DIV>\n";
    print "<DIV CLASS=\"contenido\">\n";

    MuestraBotones();
    print "</DIV></DIV>\n";
    }
  }

// ---------------------------------

function CompruebaPaso ($Paso)
  {
  global $PasoValido;

  $Vale = false;

  foreach ( $PasoValido as $PasoPosible )
    {
    if ( $PasoPosible == $Paso )
      { $Vale = true; }
    }

  if ( ! $Vale )  { $Paso = $PasoValido[0]; }

  return $Paso;
  }

// ---------------------------------

function MuestraComentarios()
  {
  global $min, $max, $Archivo, $Color;

  // Pedimos a la base de datos los registros que nos piden
  $Consulta = "SELECT * FROM visita WHERE num>=$min AND num<=$max";
  $Lista = TedeceaBD_ConsultaListaRegistro ($Archivo, $Consulta);

  // Imprimimos los registros obtenidos
  foreach ( $Lista as $Registro )
    {
    // Asignamos los campos a variables, por comodidad
    $Num = $Registro[0];
    $Momento = $Registro[1];
    $Nombre = $Registro[2];
    $Comentario = $Registro[3];

    // Al guardar el comentario pusimos <BR> como fin de párrafo
    $Nombre = trim (str_replace ('<BR>', "\n", $Nombre));
    $Comentario = trim (str_replace ('<BR>', "\n", $Comentario));

    // Mostramos el registro en una tabla dentro de un DIV
    $CodigoHTML=<<<HTML
    <DIV CLASS="cuadro">
    <TABLE WIDTH="100%" BORDER="0" CELLPADDING="10" CELLSPACING="0">
    <TR BGCOLOR="$Color">
    <TD WIDTH="10%" ALIGN="LEFT">$Num</TD>
    <TD WIDTH="60%" ALIGN="CENTER"><B>$Nombre</B></TD>
    <TD WIDTH="30%" ALIGN="RIGHT">$Momento UTC</TD>
    <TR><TD COLSPAN="3">$Comentario</TD></TR>
    </TABLE>
    </DIV>
HTML;
    print $CodigoHTML;
    }
  }

// ---------------------------------

function MuestraBotones()
  {
  global $PHP_SELF, $MaxBotones, $Paso, $PasoValido,
         $TotalComentarios, $min, $max;

  // Cuántos botones harían falta para mostrar todos los comentarios
  $BotonesNecesarios = DivEx ($TotalComentarios, $Paso);

  // Como máximo queremos $MaxBotones botones
  if ( $BotonesNecesarios <= $MaxBotones )
    {
    $Inicio = 1;
    $Final = $TotalComentarios;
    }

  // Si no caben todos los comentarios en la lista de botones,
  // hay que calcular cúales ponemos
  else
    {
    // Los botones que quedan a cada lado del botón central
    // Recuerda: $MaxBotones debe ser impar
    $Laterales = ($MaxBotones-1) / 2;

    // Calculamos en qué bloque está $min
    $Inicio = $Paso * floor ($min/$Paso) + 1;

    // Nos vamos hasta el primer botón
    $Inicio -= $Paso * $Laterales;

    // Si nos hemos pasado, empezamos desde el principio
    if ( $Inicio < 0 )
      { $Inicio = 1; }

    // Nos vamos al final del último botón
    $Final = $Inicio + $Paso * $MaxBotones - 1;

    // Si nos hemos pasado, terminamos en el último comentario
    if ( $Final > $TotalComentarios )
      {
      $Final = $TotalComentarios;

      // Puede ocurrir que no estemos usando todos los botones
      $PrincipioUltimoBoton = $Paso * floor ($Final/$Paso) + 1;
      $BotonesUsados = ($PrincipioUltimoBoton - $Inicio ) / $Paso + 1;

      // En ese caso, retrasamos $Inicio
      if ( $BotonesUsados < $MaxBotones )
        { $Inicio -= $Paso * ($MaxBotones - $BotonesUsados); }
      }
    }

  // Comenzamos el formulario
  print "<FORM ACTION=\"$PHP_SELF\" METHOD=\"POST\">\n";

  // Los botones para ir a un grupo de comentarios
  EmiteBotonera ($Inicio, $Final);

  // Una lista desplegable para elegir el paso
  print "<P>Comentarios por página: \n";
  print "<SELECT NAME=\"Paso\">\n";
  foreach ( $PasoValido as $PasoPosible )
    {
    if ( $Paso == $PasoPosible )
      { print "<OPTION SELECTED>$PasoPosible</OPTION>\n"; }
    else
      { print "<OPTION>$PasoPosible</OPTION>\n"; }
    }
  print "</SELECT>\n ";
  print "<INPUT TYPE=\"submit\" NAME=\"Cambiar\" VALUE=\" Cambiar \">\n";

  // Una caja de texto para ir a un comentario exacto
  print "<P>Ir al comentario número: \n";
  print "<INPUT NAME=\"Comentario\" SIZE=\"5\"> \n";
  print "<INPUT TYPE=\"submit\" NAME=\"Ir\" VALUE=\" Ir \">\n";

  // Hemos terminado el formulario
  print "</FORM>\n";
  }

// ---------------------------------

function EmiteBotonera ($Menor, $Tope)
  {
  global $Paso, $min, $max;

  $Sigue = 1;

  while ( $Sigue )
    {
    $Mayor = $Menor + $Paso - 1;
    if ( $Mayor >= $Tope )
      {
      $Mayor = $Tope;
      $Sigue = 0;
      }

    print "<INPUT ";

    // Resaltamos con negrita el botón que coresponde a los comentarios
    // que se están mostrando
    if ( $Menor <= $min and $max <= $Mayor )
      { print "STYLE=\"font-weight: bold;\" "; }

    print "TYPE=\"submit\" NAME=\"Rango\" VALUE=\"$Menor-$Mayor\">\n";
    print "&nbsp;&nbsp;\n";

    $Menor = $Mayor + 1;
    }
  }

// ---------------------------------

function DivEx ($Dividendo, $Divisor)
  {
  // Se calcula la división por exceso
  // Ejemplos: DivEx (8,2) = 4; DivEx (8,3) = 3

  // Empezamos por una división entera normal
  $Resultado = floor ($Dividendo / $Divisor);

  // Y si hay algún resto en la división, se suma uno al resultado
  if ( $Dividendo % $Divisor )
    { $Resultado++; }

  return $Resultado;
  }

?>
